/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.common.formatter.csv;

import io.gravitee.reporter.api.Reportable;
import io.gravitee.reporter.common.formatter.AbstractFormatter;
import io.vertx.core.buffer.Buffer;

public abstract class SingleValueFormatter<T extends Reportable>
extends AbstractFormatter<T> {
    private static final String EMPTY_VALUE = "";
    private static final char CSV_DELIMITER = ';';
    private static final char CSV_QUOTE = '\"';
    private static final char LF = '\n';
    private static final char CR = '\r';
    static final byte[] END_OF_LINE = new byte[]{13, 10};
    private static final byte FIELD_SEPARATOR = 59;
    private static final byte FIELD_QUOTE = 34;
    private static final String CSV_QUOTE_STR = String.valueOf('\"');
    private static final char[] CSV_SEARCH_CHARS = new char[]{';', '\"', '\r', '\n'};

    protected void appendEmpty(Buffer buffer) {
        this.appendString(buffer, null, false);
    }

    protected void appendString(Buffer buffer, String value) {
        this.appendString(buffer, value, false);
    }

    protected void appendString(Buffer buffer, String value, boolean last) {
        this.appendString(buffer, value, false, last);
    }

    protected void appendString(Buffer buffer, String value, boolean escape, boolean last) {
        buffer.appendByte((byte)34);
        if (!escape || value == null || SingleValueFormatter.containsNone(value, CSV_SEARCH_CHARS)) {
            buffer.appendString(value != null ? value : EMPTY_VALUE);
        } else {
            buffer.appendString(value.replace(CSV_QUOTE_STR, CSV_QUOTE_STR + CSV_QUOTE_STR));
        }
        buffer.appendByte((byte)34);
        if (!last) {
            buffer.appendByte((byte)59);
        }
    }

    void appendShort(Buffer buffer, short value) {
        this.appendShort(buffer, value, false);
    }

    void appendShort(Buffer buffer, short value, boolean last) {
        buffer.appendString(Short.toString(value));
        if (!last) {
            buffer.appendByte((byte)59);
        }
    }

    protected void appendInt(Buffer buffer, int value) {
        this.appendInt(buffer, value, false);
    }

    void appendInt(Buffer buffer, int value, boolean last) {
        buffer.appendString(Integer.toString(value));
        if (!last) {
            buffer.appendByte((byte)59);
        }
    }

    protected void appendLong(Buffer buffer, long value) {
        this.appendLong(buffer, value, false);
    }

    void appendLong(Buffer buffer, long value, boolean last) {
        buffer.appendString(Long.toString(value));
        if (!last) {
            buffer.appendByte((byte)59);
        }
    }

    protected void appendBoolean(Buffer buffer, boolean value) {
        this.appendBoolean(buffer, value, false);
    }

    void appendBoolean(Buffer buffer, boolean value, boolean last) {
        buffer.appendString(value ? "true" : "false");
        if (!last) {
            buffer.appendByte((byte)59);
        }
    }

    void appendEndOfLine(Buffer buffer) {
        buffer.appendBytes(END_OF_LINE);
    }

    private static boolean containsNone(CharSequence cs, char ... searchChars) {
        if (cs == null || searchChars == null) {
            return true;
        }
        int csLen = cs.length();
        int csLast = csLen - 1;
        int searchLen = searchChars.length;
        int searchLast = searchLen - 1;
        for (int i = 0; i < csLen; ++i) {
            char ch = cs.charAt(i);
            for (int j = 0; j < searchLen; ++j) {
                if (searchChars[j] != ch) continue;
                if (Character.isHighSurrogate(ch)) {
                    if (j == searchLast) {
                        return false;
                    }
                    if (i >= csLast || searchChars[j + 1] != cs.charAt(i + 1)) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }
}

