/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.common.formatter.csv.v4;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.reporter.api.v4.log.Log;
import io.gravitee.reporter.common.formatter.csv.SingleValueFormatter;
import io.vertx.core.buffer.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFormatter
extends SingleValueFormatter<Log> {
    private static final Logger LOG = LoggerFactory.getLogger(LogFormatter.class);
    private final ObjectMapper mapper = new ObjectMapper();

    public LogFormatter() {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Override
    protected Buffer format0(Log log) {
        Buffer buffer = Buffer.buffer();
        this.appendString(buffer, log.getRequestId());
        this.appendString(buffer, log.getApiId());
        this.appendString(buffer, log.getClientIdentifier());
        this.appendBoolean(buffer, log.isRequestEnded());
        try {
            this.appendString(buffer, this.mapper.writeValueAsString((Object)log.getEntrypointRequest()));
        }
        catch (JsonProcessingException e) {
            LOG.error("Unable to process entrypoint request", (Throwable)e);
        }
        try {
            this.appendString(buffer, this.mapper.writeValueAsString((Object)log.getEntrypointResponse()));
        }
        catch (JsonProcessingException e) {
            LOG.error("Unable to process entrypoint response", (Throwable)e);
        }
        try {
            this.appendString(buffer, this.mapper.writeValueAsString((Object)log.getEndpointRequest()));
        }
        catch (JsonProcessingException e) {
            LOG.error("Unable to process endpoint request", (Throwable)e);
        }
        try {
            this.appendString(buffer, this.mapper.writeValueAsString((Object)log.getEndpointResponse()));
        }
        catch (JsonProcessingException e) {
            LOG.error("Unable to process endpoint response", (Throwable)e);
        }
        return buffer;
    }
}

