/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.common.formatter.csv.v4;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.reporter.api.v4.log.MessageLog;
import io.gravitee.reporter.common.formatter.csv.SingleValueFormatter;
import io.vertx.core.buffer.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageLogFormatter
extends SingleValueFormatter<MessageLog> {
    private static final Logger LOG = LoggerFactory.getLogger(MessageLogFormatter.class);
    private final ObjectMapper mapper = new ObjectMapper();

    public MessageLogFormatter() {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Override
    protected Buffer format0(MessageLog log) {
        Buffer buffer = Buffer.buffer();
        this.appendString(buffer, log.getRequestId());
        this.appendString(buffer, log.getApiId());
        this.appendString(buffer, log.getCorrelationId());
        this.appendString(buffer, log.getParentCorrelationId());
        this.appendString(buffer, log.getOperation() != null ? log.getOperation().name() : null);
        this.appendString(buffer, log.getConnectorType() != null ? log.getConnectorType().name() : null);
        this.appendString(buffer, log.getConnectorId());
        try {
            this.appendString(buffer, this.mapper.writeValueAsString((Object)log.getMessage()));
        }
        catch (JsonProcessingException e) {
            LOG.error("Unable to process message", (Throwable)e);
        }
        return buffer;
    }
}

