/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.common.formatter.csv.v4;

import io.gravitee.reporter.api.v4.metric.MessageMetrics;
import io.gravitee.reporter.common.formatter.csv.SingleValueFormatter;
import io.vertx.core.buffer.Buffer;
import java.util.Iterator;
import java.util.Map;

public class MessageMetricsFormatter
extends SingleValueFormatter<MessageMetrics> {
    @Override
    protected Buffer format0(MessageMetrics metrics) {
        Map customMetrics = metrics.getCustomMetrics() == null ? Map.of() : metrics.getCustomMetrics();
        Buffer buffer = Buffer.buffer();
        this.appendString(buffer, metrics.getCorrelationId());
        this.appendString(buffer, metrics.getParentCorrelationId());
        this.appendString(buffer, metrics.getRequestId());
        this.appendLong(buffer, metrics.timestamp().toEpochMilli());
        this.appendString(buffer, metrics.getApiId());
        this.appendString(buffer, metrics.getOperation() != null ? metrics.getOperation().name() : null);
        this.appendString(buffer, metrics.getConnectorType() != null ? metrics.getConnectorType().name() : null);
        this.appendString(buffer, metrics.getConnectorId());
        this.appendLong(buffer, metrics.getContentLength());
        this.appendLong(buffer, metrics.getCount());
        this.appendLong(buffer, metrics.getErrorCount());
        this.appendBoolean(buffer, metrics.isError());
        this.appendLong(buffer, metrics.getGatewayLatencyMs());
        Iterator i = customMetrics.keySet().iterator();
        while (i.hasNext()) {
            this.appendString(buffer, (String)customMetrics.get(i.next()), true, !i.hasNext());
        }
        return buffer;
    }
}

