/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.common.formatter.csv.v4;

import io.gravitee.reporter.api.v4.metric.Metrics;
import io.gravitee.reporter.common.formatter.csv.SingleValueFormatter;
import io.vertx.core.buffer.Buffer;
import java.util.Iterator;
import java.util.Map;

public class MetricsFormatter
extends SingleValueFormatter<Metrics> {
    @Override
    protected Buffer format0(Metrics metrics) {
        Map customMetrics = metrics.getCustomMetrics() == null ? Map.of() : metrics.getCustomMetrics();
        Buffer buffer = Buffer.buffer();
        this.appendString(buffer, metrics.getTransactionId());
        this.appendString(buffer, metrics.getRequestId());
        this.appendLong(buffer, metrics.timestamp().toEpochMilli());
        this.appendString(buffer, metrics.getRemoteAddress());
        this.appendString(buffer, metrics.getLocalAddress());
        this.appendString(buffer, metrics.getApiId());
        this.appendString(buffer, metrics.getApplicationId());
        this.appendString(buffer, metrics.getPlanId());
        this.appendString(buffer, metrics.getSubscriptionId());
        this.appendString(buffer, metrics.getUser());
        this.appendString(buffer, metrics.getTenant());
        this.appendString(buffer, metrics.getUri());
        this.appendString(buffer, metrics.getPathInfo());
        this.appendString(buffer, metrics.getMappedPath());
        this.appendString(buffer, metrics.getHttpMethod().name());
        this.appendInt(buffer, metrics.getStatus());
        this.appendString(buffer, metrics.getEndpoint());
        this.appendString(buffer, metrics.getErrorKey());
        this.appendString(buffer, metrics.getErrorMessage(), true, false);
        this.appendString(buffer, metrics.getUserAgent(), true, false);
        this.appendString(buffer, metrics.getHost());
        this.appendLong(buffer, metrics.getRequestContentLength());
        this.appendLong(buffer, metrics.getResponseContentLength());
        this.appendLong(buffer, metrics.getEndpointResponseTimeMs());
        this.appendLong(buffer, metrics.getGatewayResponseTimeMs());
        this.appendLong(buffer, metrics.getGatewayLatencyMs());
        this.appendString(buffer, metrics.getSecurityType() != null ? metrics.getSecurityType().name() : null);
        this.appendString(buffer, metrics.getSecurityToken() != null ? metrics.getApiId() : null, customMetrics.isEmpty());
        Iterator i = customMetrics.keySet().iterator();
        while (i.hasNext()) {
            this.appendString(buffer, (String)customMetrics.get(i.next()), true, !i.hasNext());
        }
        return buffer;
    }
}

