/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.common.formatter.elasticsearch;

import io.gravitee.common.utils.UUID;
import io.gravitee.node.api.Node;
import io.gravitee.reporter.api.Reportable;
import io.gravitee.reporter.api.health.EndpointStatus;
import io.gravitee.reporter.api.http.Metrics;
import io.gravitee.reporter.api.monitor.Monitor;
import io.gravitee.reporter.api.v4.log.Log;
import io.gravitee.reporter.api.v4.log.MessageLog;
import io.gravitee.reporter.api.v4.metric.MessageMetrics;
import io.gravitee.reporter.common.formatter.AbstractFormatter;
import io.gravitee.reporter.common.formatter.elasticsearch.FreeMarkerComponent;
import io.vertx.core.buffer.Buffer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ElasticsearchFormatter<T extends Reportable>
extends AbstractFormatter<T> {
    private final DateTimeFormatter dtf;
    private final DateTimeFormatter sdf;
    private static String hostname;
    private final Node node;
    private final FreeMarkerComponent freeMarkerComponent;

    public ElasticsearchFormatter(Node node, FreeMarkerComponent freeMarkerComponent) {
        this.node = node;
        this.freeMarkerComponent = freeMarkerComponent;
        this.dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS[XXX]").withZone(ZoneId.systemDefault());
        this.sdf = DateTimeFormatter.ofPattern("yyyy.MM.dd").withZone(ZoneId.systemDefault());
    }

    @Override
    public Buffer format0(T reportable) {
        return this.format0(reportable, null);
    }

    @Override
    public Buffer format0(T reportable, Map<String, Object> esOptions) {
        if (reportable instanceof Metrics) {
            Metrics metrics = (Metrics)reportable;
            return this.getSource(metrics, esOptions);
        }
        if (reportable instanceof EndpointStatus) {
            EndpointStatus endpointStatus = (EndpointStatus)reportable;
            return this.getSource(endpointStatus, esOptions);
        }
        if (reportable instanceof Monitor) {
            Monitor monitor = (Monitor)reportable;
            return this.getSource(monitor, esOptions);
        }
        if (reportable instanceof io.gravitee.reporter.api.log.Log) {
            io.gravitee.reporter.api.log.Log log = (io.gravitee.reporter.api.log.Log)reportable;
            return this.getSource(log, esOptions);
        }
        if (reportable instanceof io.gravitee.reporter.api.v4.metric.Metrics) {
            io.gravitee.reporter.api.v4.metric.Metrics metrics = (io.gravitee.reporter.api.v4.metric.Metrics)reportable;
            return this.getSource(metrics, esOptions);
        }
        if (reportable instanceof MessageMetrics) {
            MessageMetrics metrics = (MessageMetrics)reportable;
            return this.getSource(metrics, esOptions);
        }
        if (reportable instanceof Log) {
            Log log = (Log)reportable;
            return this.getSource(log, esOptions);
        }
        if (reportable instanceof MessageLog) {
            MessageLog log = (MessageLog)reportable;
            return this.getSource(log, esOptions);
        }
        return null;
    }

    private Buffer getSource(Metrics metrics, Map<String, Object> esOptions) {
        HashMap<String, Object> data = new HashMap<String, Object>(10);
        this.addCommonFields(data, (Reportable)metrics, esOptions);
        data.put("metrics", metrics);
        data.put("apiResponseTime", metrics.getApiResponseTimeMs() >= 0L ? Long.valueOf(metrics.getApiResponseTimeMs()) : null);
        data.put("proxyLatency", metrics.getProxyLatencyMs() >= 0L ? Long.valueOf(metrics.getProxyLatencyMs()) : null);
        data.put("requestContentLength", metrics.getRequestContentLength() >= 0L ? Long.valueOf(metrics.getRequestContentLength()) : null);
        data.put("responseContentLength", metrics.getResponseContentLength() >= 0L ? Long.valueOf(metrics.getResponseContentLength()) : null);
        return this.generateData("request.ftl", data);
    }

    private Buffer getSource(io.gravitee.reporter.api.log.Log log, Map<String, Object> esOptions) {
        HashMap<String, Object> data = new HashMap<String, Object>(5);
        this.addCommonFields(data, (Reportable)log, esOptions);
        data.put("log", log);
        return this.generateData("log.ftl", data);
    }

    private Buffer getSource(EndpointStatus endpointStatus, Map<String, Object> esOptions) {
        HashMap<String, Object> data = new HashMap<String, Object>(5);
        this.addCommonFields(data, (Reportable)endpointStatus, esOptions);
        data.put("status", endpointStatus);
        return this.generateData("health.ftl", data);
    }

    private Buffer getSource(Monitor monitor, Map<String, Object> esOptions) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        this.addCommonFields(data, (Reportable)monitor, esOptions);
        data.put("id", UUID.random().toString());
        data.put("hostname", hostname);
        if (monitor.getOs() != null) {
            if (monitor.getOs().cpu != null) {
                data.put("percent", monitor.getOs().cpu.getPercent());
                if (monitor.getOs().cpu.getLoadAverage() != null && Arrays.stream(monitor.getOs().cpu.getLoadAverage()).anyMatch(load -> load != -1.0)) {
                    if (monitor.getOs().cpu.getLoadAverage()[0] != -1.0) {
                        data.put("load_average_1m", monitor.getOs().cpu.getLoadAverage()[0]);
                    }
                    if (monitor.getOs().cpu.getLoadAverage()[1] != -1.0) {
                        data.put("load_average_5m", monitor.getOs().cpu.getLoadAverage()[1]);
                    }
                    if (monitor.getOs().cpu.getLoadAverage()[2] != -1.0) {
                        data.put("load_average_15m", monitor.getOs().cpu.getLoadAverage()[2]);
                    }
                }
            }
            if (monitor.getOs().mem != null) {
                data.put("mem_total_in_bytes", monitor.getOs().mem.getTotal());
                data.put("mem_free_in_bytes", monitor.getOs().mem.getFree());
                data.put("mem_used_in_bytes", monitor.getOs().mem.getUsed());
                data.put("mem_free_percent", monitor.getOs().mem.getFreePercent());
                data.put("mem_used_percent", monitor.getOs().mem.getUsedPercent());
            }
        }
        if (monitor.getProcess() != null) {
            data.put("process_timestamp", monitor.getProcess().timestamp);
            data.put("open_file_descriptors", monitor.getProcess().openFileDescriptors);
            data.put("max_file_descriptors", monitor.getProcess().maxFileDescriptors);
            data.put("process_percent", monitor.getProcess().cpu.getPercent());
        }
        if (monitor.getJvm() != null) {
            data.put("jvm_timestamp", monitor.getJvm().timestamp);
            data.put("uptime_in_millis", monitor.getJvm().uptime);
            if (monitor.getJvm().mem != null) {
                data.put("heap_used_in_bytes", monitor.getJvm().mem.heapUsed);
                if (monitor.getJvm().mem.getHeapUsedPercent() >= 0) {
                    data.put("heap_used_percent", monitor.getJvm().mem.getHeapUsedPercent());
                }
                data.put("heap_committed_in_bytes", monitor.getJvm().mem.heapCommitted);
                data.put("heap_max_in_bytes", monitor.getJvm().mem.heapMax);
                data.put("non_heap_used_in_bytes", monitor.getJvm().mem.nonHeapUsed);
                data.put("non_heap_committed_in_bytes", monitor.getJvm().mem.nonHeapCommitted);
                data.put("pools", monitor.getJvm().mem.pools);
            }
            if (monitor.getJvm().threads != null) {
                data.put("count", monitor.getJvm().threads.getCount());
                data.put("peak_count", monitor.getJvm().threads.getPeakCount());
            }
            if (monitor.getJvm().gc != null) {
                data.put("collectors", monitor.getJvm().gc.collectors);
            }
        }
        return this.generateData("monitor.ftl", data);
    }

    private Buffer getSource(io.gravitee.reporter.api.v4.metric.Metrics metrics, Map<String, Object> esOptions) {
        HashMap<String, Object> data = new HashMap<String, Object>(10);
        this.addCommonFields(data, (Reportable)metrics, esOptions);
        data.put("metrics", metrics);
        data.put("endpointResponseTimeMs", metrics.getEndpointResponseTimeMs() >= 0L ? Long.valueOf(metrics.getEndpointResponseTimeMs()) : null);
        data.put("gatewayResponseTimeMs", metrics.getGatewayResponseTimeMs() >= 0L ? Long.valueOf(metrics.getGatewayResponseTimeMs()) : null);
        data.put("gatewayLatencyMs", metrics.getGatewayLatencyMs() >= 0L ? Long.valueOf(metrics.getGatewayLatencyMs()) : null);
        data.put("requestContentLength", metrics.getRequestContentLength() >= 0L ? Long.valueOf(metrics.getRequestContentLength()) : null);
        data.put("responseContentLength", metrics.getResponseContentLength() >= 0L ? Long.valueOf(metrics.getResponseContentLength()) : null);
        return this.generateData("v4-metrics.ftl", data);
    }

    private Buffer getSource(MessageMetrics metrics, Map<String, Object> esOptions) {
        HashMap<String, Object> data = new HashMap<String, Object>(10);
        this.addCommonFields(data, (Reportable)metrics, esOptions);
        data.put("metrics", metrics);
        data.put("contentLength", metrics.getContentLength() >= 0L ? Long.valueOf(metrics.getContentLength()) : null);
        data.put("count", metrics.getCount() >= 0L ? Long.valueOf(metrics.getCount()) : null);
        data.put("errorCount", metrics.getErrorCount() >= 0L ? Long.valueOf(metrics.getErrorCount()) : null);
        data.put("gatewayLatencyMs", metrics.getGatewayLatencyMs() >= 0L ? Long.valueOf(metrics.getGatewayLatencyMs()) : null);
        return this.generateData("v4-message-metrics.ftl", data);
    }

    private Buffer getSource(Log log, Map<String, Object> esOptions) {
        HashMap<String, Object> data = new HashMap<String, Object>(5);
        this.addCommonFields(data, (Reportable)log, esOptions);
        data.put("log", log);
        return this.generateData("v4-log.ftl", data);
    }

    private Buffer getSource(MessageLog log, Map<String, Object> esOptions) {
        HashMap<String, Object> data = new HashMap<String, Object>(5);
        this.addCommonFields(data, (Reportable)log, esOptions);
        data.put("log", log);
        return this.generateData("v4-message-log.ftl", data);
    }

    private Buffer generateData(String templateName, Map<String, Object> data) {
        Buffer buffer;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.freeMarkerComponent.generateFromTemplate("/index/" + templateName, data, new OutputStreamWriter(baos));
            buffer = Buffer.buffer((byte[])baos.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        baos.close();
        return buffer;
    }

    private void addCommonFields(Map<String, Object> data, Reportable reportable, Map<String, Object> esOptions) {
        data.put("@timestamp", this.dtf.format(reportable.timestamp()));
        data.put("gateway", this.node.id());
        if (esOptions != null) {
            if (esOptions.get("index") != null) {
                data.put("index", esOptions.get("index"));
            }
            if (esOptions.get("pipeline") != null) {
                data.put("pipeline", esOptions.get("pipeline"));
            }
        } else {
            data.put("date", this.sdf.format(reportable.timestamp()));
        }
    }

    static {
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostname = "unknown";
        }
    }

    static final class Fields {
        static final String GATEWAY = "gateway";
        static final String HOSTNAME = "hostname";
        static final String SPECIAL_TIMESTAMP = "@timestamp";
        static final String TIMESTAMP = "timestamp";
        static final String PERCENT = "percent";
        static final String LOAD_AVERAGE_1M = "load_average_1m";
        static final String LOAD_AVERAGE_5M = "load_average_5m";
        static final String LOAD_AVERAGE_15M = "load_average_15m";
        static final String FREE_IN_BYTES = "free_in_bytes";
        static final String USED_IN_BYTES = "used_in_bytes";
        static final String TOTAL_IN_BYTES = "total_in_bytes";
        static final String FREE_PERCENT = "free_percent";
        static final String USED_PERCENT = "used_percent";
        static final String OPEN_FILE_DESCRIPTORS = "open_file_descriptors";
        static final String MAX_FILE_DESCRIPTORS = "max_file_descriptors";
        static final String UPTIME_IN_MILLIS = "uptime_in_millis";
        static final String HEAP_USED_IN_BYTES = "heap_used_in_bytes";
        static final String HEAP_USED_PERCENT = "heap_used_percent";
        static final String HEAP_MAX_IN_BYTES = "heap_max_in_bytes";
        static final String HEAP_COMMITTED_IN_BYTES = "heap_committed_in_bytes";
        static final String NON_HEAP_USED_IN_BYTES = "non_heap_used_in_bytes";
        static final String NON_HEAP_COMMITTED_IN_BYTES = "non_heap_committed_in_bytes";
        static final String POOLS = "pools";
        static final String COUNT = "count";
        static final String PEAK_COUNT = "peak_count";
        static final String COLLECTORS = "collectors";

        private Fields() {
        }
    }
}

