/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.common.formatter.elasticsearch;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.TemplateClassResolver;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreeMarkerComponent {
    private final Logger logger = LoggerFactory.getLogger(FreeMarkerComponent.class);
    private static final String DIRECTORY_NAME_PATTERN = "/freemarker/es%dx";
    private final Configuration configuration = new Configuration(Configuration.VERSION_2_3_23);

    public FreeMarkerComponent(int elasticsearchVersion) {
        this.configuration.setDefaultEncoding(StandardCharsets.UTF_8.name());
        this.configuration.setDateFormat("iso_utc");
        this.configuration.setLocale(Locale.ENGLISH);
        this.configuration.setNumberFormat("computer");
        this.configuration.setNewBuiltinClassResolver(TemplateClassResolver.SAFER_RESOLVER);
        this.configuration.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(FreeMarkerComponent.class.getClassLoader(), String.format(DIRECTORY_NAME_PATTERN, elasticsearchVersion)));
    }

    void generateFromTemplate(String templateName, Map<String, Object> data, Writer writer) {
        try {
            Template template = this.configuration.getTemplate(templateName);
            template.process(data, writer);
        }
        catch (TemplateException | IOException exception) {
            this.logger.error("Impossible to generate from template " + templateName, exception);
            throw new IllegalArgumentException();
        }
    }
}

