/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.NameResolver;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.xds.PriorityLoadBalancer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

final class PriorityLoadBalancerProvider
extends LoadBalancerProvider {
    PriorityLoadBalancerProvider() {
    }

    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "priority_experimental";
    }

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new PriorityLoadBalancer(helper);
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawConfig) {
        throw new UnsupportedOperationException();
    }

    static final class PriorityLbConfig {
        final Map<String, ServiceConfigUtil.PolicySelection> childConfigs;
        final List<String> priorities;

        PriorityLbConfig(Map<String, ServiceConfigUtil.PolicySelection> childConfigs, List<String> priorities) {
            this.childConfigs = Collections.unmodifiableMap((Map)Preconditions.checkNotNull(childConfigs, (Object)"childConfigs"));
            this.priorities = Collections.unmodifiableList((List)Preconditions.checkNotNull(priorities, (Object)"priorities"));
            Preconditions.checkArgument((!priorities.isEmpty() ? 1 : 0) != 0, (Object)"priority list is empty");
            Preconditions.checkArgument((boolean)childConfigs.keySet().containsAll(priorities), (Object)"missing child config for at lease one of the priorities");
            Preconditions.checkArgument((priorities.size() == new HashSet<String>(priorities).size() ? 1 : 0) != 0, (Object)"duplicate names in priorities");
            Preconditions.checkArgument((priorities.size() == childConfigs.keySet().size() ? 1 : 0) != 0, (Object)"some names in childConfigs are not referenced by priorities");
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("childConfigs", this.childConfigs).add("priorities", this.priorities).toString();
        }
    }
}

