/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.certprovider;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.Status;
import io.grpc.xds.internal.sds.Closeable;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class CertificateProvider
implements Closeable {
    private final DistributorWatcher watcher;
    private final boolean notifyCertUpdates;

    protected CertificateProvider(DistributorWatcher watcher, boolean notifyCertUpdates) {
        this.watcher = watcher;
        this.notifyCertUpdates = notifyCertUpdates;
    }

    @Override
    public abstract void close();

    public DistributorWatcher getWatcher() {
        return this.watcher;
    }

    public boolean isNotifyCertUpdates() {
        return this.notifyCertUpdates;
    }

    @VisibleForTesting
    static final class DistributorWatcher
    implements Watcher {
        @VisibleForTesting
        final Set<Watcher> downsstreamWatchers = new HashSet<Watcher>();

        DistributorWatcher() {
        }

        synchronized void addWatcher(Watcher watcher) {
            this.downsstreamWatchers.add(watcher);
        }

        synchronized void removeWatcher(Watcher watcher) {
            this.downsstreamWatchers.remove(watcher);
        }

        @Override
        public void updateCertificate(PrivateKey key, List<X509Certificate> certChain) {
            for (Watcher watcher : this.downsstreamWatchers) {
                watcher.updateCertificate(key, certChain);
            }
        }

        @Override
        public void updateTrustedRoots(List<X509Certificate> trustedRoots) {
            for (Watcher watcher : this.downsstreamWatchers) {
                watcher.updateTrustedRoots(trustedRoots);
            }
        }

        @Override
        public void onError(Status errorStatus) {
            for (Watcher watcher : this.downsstreamWatchers) {
                watcher.onError(errorStatus);
            }
        }
    }

    public static interface Watcher {
        public void updateCertificate(PrivateKey var1, List<X509Certificate> var2);

        public void updateTrustedRoots(List<X509Certificate> var1);

        public void onError(Status var1);
    }
}

