/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.internal.sds.CommonTlsContextUtil;
import io.grpc.xds.internal.sds.ReferenceCountingMap;
import io.grpc.xds.internal.sds.SdsClientSslContextProvider;
import io.grpc.xds.internal.sds.SecretVolumeClientSslContextProvider;
import io.grpc.xds.internal.sds.SslContextProvider;
import java.io.IOException;
import java.util.concurrent.Executors;

final class ClientSslContextProviderFactory
implements ReferenceCountingMap.ValueFactory<EnvoyServerProtoData.UpstreamTlsContext, SslContextProvider> {
    ClientSslContextProviderFactory() {
    }

    @Override
    public SslContextProvider create(EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext) {
        Preconditions.checkNotNull((Object)upstreamTlsContext, (Object)"upstreamTlsContext");
        Preconditions.checkNotNull((Object)upstreamTlsContext.getCommonTlsContext(), (Object)"upstreamTlsContext should have CommonTlsContext");
        if (CommonTlsContextUtil.hasAllSecretsUsingFilename(upstreamTlsContext.getCommonTlsContext())) {
            return SecretVolumeClientSslContextProvider.getProvider(upstreamTlsContext);
        }
        if (CommonTlsContextUtil.hasAllSecretsUsingSds(upstreamTlsContext.getCommonTlsContext())) {
            try {
                return SdsClientSslContextProvider.getProvider(upstreamTlsContext, Bootstrapper.getInstance().readBootstrap().getNode(), Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("client-sds-sslcontext-provider-%d").setDaemon(true).build()), null);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        throw new UnsupportedOperationException("UpstreamTlsContext to have all filenames or all SdsConfig");
    }
}

