/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.serviceloader;

import io.helidon.common.serviceloader.Priorities;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class HelidonServiceLoader<T>
implements Iterable<T> {
    public static final String SYSTEM_PROPERTY_EXCLUDE = "io.helidon.common.serviceloader.exclude";
    private static final Logger LOGGER = Logger.getLogger(HelidonServiceLoader.class.getName());
    private final List<T> services;

    public static <T> Builder<T> builder(ServiceLoader<T> serviceLoader) {
        return new Builder<T>(serviceLoader);
    }

    public static <T> HelidonServiceLoader<T> create(ServiceLoader<T> serviceLoader) {
        Builder<T> builder = HelidonServiceLoader.builder(serviceLoader);
        return builder.build();
    }

    private HelidonServiceLoader(List<T> services) {
        this.services = new LinkedList<T>(services);
    }

    @Override
    public Iterator<T> iterator() {
        return Collections.unmodifiableList(this.services).iterator();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.services.forEach(action);
    }

    public List<T> asList() {
        return new LinkedList<T>(this.services);
    }

    public static final class Builder<T>
    implements io.helidon.common.Builder<HelidonServiceLoader<T>> {
        private final ServiceLoader<T> serviceLoader;
        private final List<ServiceWithPriority<T>> customServices = new LinkedList<ServiceWithPriority<T>>();
        private final Set<String> excludedServiceClasses = new HashSet<String>();
        private boolean useSysPropExclude = true;
        private boolean useSystemServiceLoader = true;
        private boolean replaceImplementations = true;
        private int defaultPriority = 5000;

        private Builder(ServiceLoader<T> serviceLoader) {
            this.serviceLoader = serviceLoader;
        }

        public HelidonServiceLoader<T> build() {
            LinkedList<ServiceWithPriority<T>> services = new LinkedList<ServiceWithPriority<T>>(this.customServices);
            if (this.useSystemServiceLoader) {
                HashSet uniqueImplementations = new HashSet();
                if (this.replaceImplementations) {
                    this.customServices.stream().map(rec$ -> ((ServiceWithPriority)rec$).instanceClassName()).forEach(uniqueImplementations::add);
                }
                this.serviceLoader.forEach(service -> {
                    if (this.replaceImplementations) {
                        if (!uniqueImplementations.contains(service.getClass().getName())) {
                            services.add(ServiceWithPriority.createFindPriority(service, this.defaultPriority));
                        }
                    } else {
                        services.add(ServiceWithPriority.createFindPriority(service, this.defaultPriority));
                    }
                });
            }
            if (this.useSysPropExclude) {
                this.addSystemExcludes();
            }
            List<ServiceWithPriority<T>> withoutExclusions = services.stream().filter(this::notExcluded).collect(Collectors.toList());
            return new HelidonServiceLoader<T>(this.orderByPriority(withoutExclusions));
        }

        public Builder<T> useSystemExcludes(boolean useSysPropExclude) {
            this.useSysPropExclude = useSysPropExclude;
            return this;
        }

        public Builder<T> useSystemServiceLoader(boolean useServiceLoader) {
            this.useSystemServiceLoader = useServiceLoader;
            return this;
        }

        public Builder<T> replaceImplementations(boolean replace) {
            this.replaceImplementations = replace;
            return this;
        }

        public Builder<T> addService(T service) {
            this.customServices.add(ServiceWithPriority.createFindPriority(service, this.defaultPriority));
            return this;
        }

        public Builder<T> addService(T service, int priority) {
            this.customServices.add(ServiceWithPriority.create(service, priority));
            return this;
        }

        public Builder<T> addExcludedClass(Class<? extends T> excluded) {
            this.excludedServiceClasses.add(excluded.getName());
            return this;
        }

        public Builder<T> addExcludedClassName(String excludeName) {
            this.excludedServiceClasses.add(excludeName);
            return this;
        }

        public Builder<T> defaultPriority(int defaultPriority) {
            this.defaultPriority = defaultPriority;
            return this;
        }

        private boolean notExcluded(ServiceWithPriority<T> service) {
            String className = service.instance.getClass().getName();
            if (this.excludedServiceClasses.contains(className)) {
                LOGGER.finest(() -> "Excluding service implementation " + className);
                return false;
            }
            return true;
        }

        private List<T> orderByPriority(List<ServiceWithPriority<T>> services) {
            services.sort(ServiceWithPriority.COMPARATOR);
            List result = services.stream().map(rec$ -> ((ServiceWithPriority)rec$).instance()).collect(Collectors.toList());
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Final order of enabled service implementations for service: " + this.serviceLoader);
                result.stream().map(Object::getClass).map(Class::getName).forEach(LOGGER::finest);
            }
            return result;
        }

        private void addSystemExcludes() {
            String excludes = System.getProperty(HelidonServiceLoader.SYSTEM_PROPERTY_EXCLUDE);
            if (null == excludes) {
                return;
            }
            for (String exclude : excludes.split(",")) {
                LOGGER.finest(() -> "Adding exclude from system properties: " + exclude);
                this.addExcludedClassName(exclude);
            }
        }

        private static final class ServiceWithPriority<T> {
            public static final Comparator<ServiceWithPriority<?>> COMPARATOR = Comparator.comparingInt(ServiceWithPriority::priority);
            private final T instance;
            private final int priority;

            private ServiceWithPriority(T instance, int priority) {
                this.instance = instance;
                this.priority = priority;
                if (priority < 0) {
                    throw new IllegalArgumentException("Service: " + instance.getClass().getName() + " declares a negative priority, which is not allowed. Priority: " + priority);
                }
            }

            private static <T> ServiceWithPriority<T> create(T instance, int priority) {
                return new ServiceWithPriority<T>(instance, priority);
            }

            private static <T> ServiceWithPriority<T> createFindPriority(T instance, int defaultPriority) {
                return new ServiceWithPriority<T>(instance, Priorities.find(instance, defaultPriority));
            }

            private int priority() {
                return this.priority;
            }

            private T instance() {
                return this.instance;
            }

            private String instanceClassName() {
                return this.instance.getClass().getName();
            }

            public String toString() {
                return this.instance.toString();
            }
        }
    }
}

