/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.internal.LettuceAssert;
import java.util.Objects;

public class Range<T> {
    private Boundary<T> lower;
    private Boundary<T> upper;

    private Range(Boundary<T> lower, Boundary<T> upper) {
        LettuceAssert.notNull(lower, "Lower boundary must not be null");
        LettuceAssert.notNull(upper, "Upper boundary must not be null");
        this.lower = lower;
        this.upper = upper;
    }

    public static <T> Range<T> create(T lower, T upper) {
        LettuceAssert.isTrue(!(lower instanceof Boundary), "Lower must not be a Boundary. Use #from(Boundary, Boundary) instead");
        LettuceAssert.isTrue(!(upper instanceof Boundary), "Upper must not be a Boundary. Use #from(Boundary, Boundary) instead");
        return new Range<T>(Boundary.including(lower), Boundary.including(upper));
    }

    public static <T> Range<T> from(Boundary<T> lower, Boundary<T> upper) {
        return new Range<T>(lower, upper);
    }

    public static <T> Range<T> unbounded() {
        return new Range(Boundary.unbounded(), Boundary.unbounded());
    }

    public Range<T> gte(T lower) {
        this.lower = Boundary.including(lower);
        return this;
    }

    public Range<T> gt(T lower) {
        this.lower = Boundary.excluding(lower);
        return this;
    }

    public Range<T> lte(T upper) {
        this.upper = Boundary.including(upper);
        return this;
    }

    public Range<T> lt(T upper) {
        this.upper = Boundary.excluding(upper);
        return this;
    }

    public Boundary<T> getLower() {
        return this.lower;
    }

    public Boundary<T> getUpper() {
        return this.upper;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range range = (Range)o;
        return Objects.equals(this.lower, range.lower) && Objects.equals(this.upper, range.upper);
    }

    public int hashCode() {
        return Objects.hash(this.lower, this.upper);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(" [");
        sb.append(this.lower).append(" to ").append(this.upper).append("]");
        return sb.toString();
    }

    public static class Boundary<T> {
        private static final Boundary<?> UNBOUNDED = new Boundary<Object>(null, true);
        private final T value;
        private final boolean including;

        private Boundary(T value, boolean including) {
            this.value = value;
            this.including = including;
        }

        public static <T> Boundary<T> unbounded() {
            return UNBOUNDED;
        }

        public static <T> Boundary<T> including(T value) {
            LettuceAssert.notNull(value, "Value must not be null");
            return new Boundary<T>(value, true);
        }

        public static <T> Boundary<T> excluding(T value) {
            LettuceAssert.notNull(value, "Value must not be null");
            return new Boundary<T>(value, false);
        }

        public T getValue() {
            return this.value;
        }

        public boolean isIncluding() {
            return this.including;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Boundary)) {
                return false;
            }
            Boundary boundary = (Boundary)o;
            return this.including == boundary.including && Objects.equals(this.value, boundary.value);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.including);
        }

        public String toString() {
            if (this.value == null) {
                return "[unbounded]";
            }
            StringBuilder sb = new StringBuilder();
            if (this.including) {
                sb.append('[');
            } else {
                sb.append('(');
            }
            sb.append(this.value);
            return sb.toString();
        }
    }
}

