/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.resource;

import io.lettuce.core.resource.Delay;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

class DecorrelatedJitterDelay
extends Delay
implements Delay.StatefulDelay {
    private final Duration lower;
    private final Duration upper;
    private final long base;
    private final TimeUnit targetTimeUnit;
    private volatile long prevDelay;

    DecorrelatedJitterDelay(Duration lower, Duration upper, long base, TimeUnit targetTimeUnit) {
        this.lower = lower;
        this.upper = upper;
        this.base = base;
        this.targetTimeUnit = targetTimeUnit;
        this.reset();
    }

    @Override
    public Duration createDelay(long attempt) {
        long value = DecorrelatedJitterDelay.randomBetween(this.base, Math.max(this.base, this.prevDelay * 3L));
        Duration delay = DecorrelatedJitterDelay.applyBounds(Duration.ofNanos(this.targetTimeUnit.toNanos(value)), this.lower, this.upper);
        this.prevDelay = this.targetTimeUnit.convert(delay.toNanos(), TimeUnit.NANOSECONDS);
        return delay;
    }

    @Override
    public void reset() {
        this.prevDelay = 0L;
    }
}

