/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator;

import io.micronaut.aop.Intercepted;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.MessageSource;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ArgumentValue;
import io.micronaut.core.type.MutableArgumentValue;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.type.TypeInformation;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.InjectionPoint;
import io.micronaut.inject.MethodReference;
import io.micronaut.inject.annotation.AnnotatedElementValidator;
import io.micronaut.inject.validation.BeanDefinitionValidator;
import io.micronaut.validation.validator.DefaultConstraintDescriptor;
import io.micronaut.validation.validator.ExecutableMethodValidator;
import io.micronaut.validation.validator.IntrospectedBeanDescriptor;
import io.micronaut.validation.validator.ReactiveValidator;
import io.micronaut.validation.validator.Validator;
import io.micronaut.validation.validator.ValidatorConfiguration;
import io.micronaut.validation.validator.constraints.ConstraintValidator;
import io.micronaut.validation.validator.constraints.ConstraintValidatorContext;
import io.micronaut.validation.validator.constraints.ConstraintValidatorRegistry;
import io.micronaut.validation.validator.extractors.ValueExtractorRegistry;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.validation.ClockProvider;
import javax.validation.Constraint;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ElementKind;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.Valid;
import javax.validation.ValidationException;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ConstructorDescriptor;
import javax.validation.metadata.ElementDescriptor;
import javax.validation.metadata.MethodDescriptor;
import javax.validation.metadata.MethodType;
import javax.validation.metadata.PropertyDescriptor;
import javax.validation.metadata.Scope;
import javax.validation.valueextraction.ValueExtractor;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Singleton
@Primary
@Requires(property="micronaut.validator.enabled", value="true", defaultValue="true")
public class DefaultValidator
implements Validator,
ExecutableMethodValidator,
ReactiveValidator,
AnnotatedElementValidator,
BeanDefinitionValidator {
    private static final List<Class> DEFAULT_GROUPS = Collections.singletonList(Default.class);
    private final ConstraintValidatorRegistry constraintValidatorRegistry;
    private final ClockProvider clockProvider;
    private final ValueExtractorRegistry valueExtractorRegistry;
    private final TraversableResolver traversableResolver;
    private final ExecutionHandleLocator executionHandleLocator;
    private final MessageSource messageSource;

    protected DefaultValidator(@NonNull ValidatorConfiguration configuration) {
        ArgumentUtils.requireNonNull((String)"configuration", (Object)configuration);
        this.constraintValidatorRegistry = configuration.getConstraintValidatorRegistry();
        this.clockProvider = configuration.getClockProvider();
        this.valueExtractorRegistry = configuration.getValueExtractorRegistry();
        this.traversableResolver = configuration.getTraversableResolver();
        this.executionHandleLocator = configuration.getExecutionHandleLocator();
        this.messageSource = configuration.getMessageSource();
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validate(@NonNull T object, Class<?> ... groups) {
        ArgumentUtils.requireNonNull((String)"object", object);
        BeanIntrospection<Object> introspection = this.getBeanIntrospection(object);
        if (introspection == null) {
            return Collections.emptySet();
        }
        return this.validate(introspection, object, groups);
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validate(@NonNull BeanIntrospection<T> introspection, @NonNull T object, Class<?> ... groups) {
        if (introspection == null) {
            throw new ValidationException("Passed object [" + object + "] cannot be introspected. Please annotate with @Introspected");
        }
        Collection constrainedProperties = introspection.getIndexedProperties(Constraint.class);
        Collection cascadeProperties = introspection.getIndexedProperties(Valid.class);
        List pojoConstraints = introspection.getAnnotationTypesByStereotype(Constraint.class);
        if (CollectionUtils.isNotEmpty((Collection)constrainedProperties) || CollectionUtils.isNotEmpty((Collection)cascadeProperties) || CollectionUtils.isNotEmpty((Collection)pojoConstraints)) {
            DefaultConstraintValidatorContext context = new DefaultConstraintValidatorContext((Object)object, (Class[])groups);
            HashSet overallViolations = new HashSet(5);
            return this.doValidate(introspection, object, object, constrainedProperties, cascadeProperties, context, overallViolations, pojoConstraints);
        }
        return Collections.emptySet();
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateProperty(@NonNull T object, @NonNull String propertyName, Class<?> ... groups) {
        ArgumentUtils.requireNonNull((String)"object", object);
        ArgumentUtils.requireNonNull((String)"propertyName", (Object)propertyName);
        BeanIntrospection<Object> introspection = this.getBeanIntrospection(object);
        if (introspection == null) {
            throw new ValidationException("Passed object [" + object + "] cannot be introspected. Please annotate with @Introspected");
        }
        Optional property = introspection.getProperty(propertyName);
        if (property.isPresent()) {
            BeanProperty constrainedProperty = (BeanProperty)property.get();
            DefaultConstraintValidatorContext context = new DefaultConstraintValidatorContext((Object)object, (Class[])groups);
            HashSet<ConstraintViolation<Object>> overallViolations = new HashSet<ConstraintViolation<Object>>(5);
            Object propertyValue = constrainedProperty.get(object);
            Class<?> rootBeanClass = object.getClass();
            this.validateConstrainedPropertyInternal(rootBeanClass, object, object, (AnnotatedElement)constrainedProperty, constrainedProperty.getType(), propertyValue, context, overallViolations, null);
            return Collections.unmodifiableSet(overallViolations);
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateValue(@NonNull Class<T> beanType, @NonNull String propertyName, @Nullable Object value, Class<?> ... groups) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        ArgumentUtils.requireNonNull((String)"propertyName", (Object)propertyName);
        BeanIntrospection<Object> introspection = this.getBeanIntrospection(beanType);
        if (introspection == null) {
            throw new ValidationException("Passed bean type [" + beanType + "] cannot be introspected. Please annotate with @Introspected");
        }
        BeanProperty beanProperty = (BeanProperty)introspection.getProperty(propertyName).orElseThrow(() -> new ValidationException("No property [" + propertyName + "] found on type: " + beanType));
        HashSet<ConstraintViolation<Object>> overallViolations = new HashSet<ConstraintViolation<Object>>(5);
        DefaultConstraintValidatorContext context = new DefaultConstraintValidatorContext((Class[])groups);
        try {
            context.addPropertyNode(propertyName, null);
            this.validatePropertyInternal(beanType, null, null, context, overallViolations, beanProperty.getType(), (AnnotatedElement)beanProperty, value);
        }
        finally {
            context.removeLast();
        }
        return Collections.unmodifiableSet(overallViolations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Set<String> validatedAnnotatedElement(@NonNull AnnotatedElement element, @Nullable Object value) {
        ArgumentUtils.requireNonNull((String)"element", (Object)element);
        if (!element.getAnnotationMetadata().hasStereotype(Constraint.class)) {
            return Collections.emptySet();
        }
        HashSet<ConstraintViolation<Object>> overallViolations = new HashSet<ConstraintViolation<Object>>(5);
        DefaultConstraintValidatorContext context = new DefaultConstraintValidatorContext(new Class[0]);
        try {
            context.addPropertyNode(element.getName(), null);
            this.validatePropertyInternal(null, element, element, context, overallViolations, value != null ? value.getClass() : Object.class, element, value);
        }
        finally {
            context.removeLast();
        }
        return Collections.unmodifiableSet(overallViolations.stream().map(ConstraintViolation::getMessage).collect(Collectors.toSet()));
    }

    @Override
    @NonNull
    public <T> T createValid(@NonNull Class<T> beanType, Object ... arguments) throws ConstraintViolationException {
        ArgumentUtils.requireNonNull((String)"type", beanType);
        BeanIntrospection<Object> introspection = this.getBeanIntrospection(beanType);
        if (introspection == null) {
            throw new ValidationException("Passed bean type [" + beanType + "] cannot be introspected. Please annotate with @Introspected");
        }
        Set<ConstraintViolation<Object>> constraintViolations = this.validateConstructorParameters(introspection, arguments, new Class[0]);
        if (constraintViolations.isEmpty()) {
            Object instance = introspection.instantiate(arguments);
            Set<ConstraintViolation<Object>> errors = this.validate(introspection, instance, new Class[0]);
            if (errors.isEmpty()) {
                return (T)instance;
            }
            throw new ConstraintViolationException(errors);
        }
        throw new ConstraintViolationException(constraintViolations);
    }

    public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        return BeanIntrospector.SHARED.findIntrospection(clazz).map(IntrospectedBeanDescriptor::new).orElseGet(() -> new EmptyDescriptor(clazz));
    }

    public <T> T unwrap(Class<T> type) {
        throw new UnsupportedOperationException("Validator unwrapping not supported by this implementation");
    }

    @Override
    @NonNull
    public ExecutableMethodValidator forExecutables() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateParameters(@NonNull T object, @NonNull ExecutableMethod method, @NonNull Object[] parameterValues, Class<?> ... groups) {
        ArgumentUtils.requireNonNull((String)"parameterValues", (Object)parameterValues);
        ArgumentUtils.requireNonNull((String)"object", object);
        ArgumentUtils.requireNonNull((String)"method", (Object)method);
        Argument[] arguments = method.getArguments();
        int argLen = arguments.length;
        if (argLen != parameterValues.length) {
            throw new IllegalArgumentException("The method parameter array must have exactly " + argLen + " elements.");
        }
        DefaultConstraintValidatorContext context = new DefaultConstraintValidatorContext((Object)object, (Class[])groups);
        HashSet overallViolations = new HashSet(5);
        Path.Node node = context.addMethodNode((MethodReference<?, ?>)method);
        try {
            Class<?> rootClass = object.getClass();
            this.validateParametersInternal(rootClass, object, parameterValues, arguments, argLen, context, overallViolations, node);
        }
        finally {
            context.removeLast();
        }
        return Collections.unmodifiableSet(overallViolations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateParameters(@NonNull T object, @NonNull ExecutableMethod method, @NonNull Collection<MutableArgumentValue<?>> argumentValues, Class<?> ... groups) {
        ArgumentUtils.requireNonNull((String)"object", object);
        ArgumentUtils.requireNonNull((String)"method", (Object)method);
        ArgumentUtils.requireNonNull((String)"parameterValues", argumentValues);
        Argument[] arguments = method.getArguments();
        int argLen = arguments.length;
        if (argLen != argumentValues.size()) {
            throw new IllegalArgumentException("The method parameter array must have exactly " + argLen + " elements.");
        }
        DefaultConstraintValidatorContext context = new DefaultConstraintValidatorContext((Object)object, (Class[])groups);
        HashSet overallViolations = new HashSet(5);
        Path.Node node = context.addMethodNode((MethodReference<?, ?>)method);
        try {
            Class<?> rootClass = object.getClass();
            this.validateParametersInternal(rootClass, object, argumentValues.stream().map(ArgumentValue::getValue).toArray(), arguments, argLen, context, overallViolations, node);
        }
        finally {
            context.removeLast();
        }
        return Collections.unmodifiableSet(overallViolations);
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateParameters(@NonNull T object, @NonNull Method method, @NonNull Object[] parameterValues, Class<?> ... groups) {
        ArgumentUtils.requireNonNull((String)"method", (Object)method);
        return this.executionHandleLocator.findExecutableMethod(method.getDeclaringClass(), method.getName(), (Class[])method.getParameterTypes()).map(executableMethod -> this.validateParameters(object, (ExecutableMethod)executableMethod, parameterValues, groups)).orElse(Collections.emptySet());
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateReturnValue(@NonNull T object, @NonNull Method method, @Nullable Object returnValue, Class<?> ... groups) {
        ArgumentUtils.requireNonNull((String)"method", (Object)method);
        ArgumentUtils.requireNonNull((String)"object", object);
        return this.executionHandleLocator.findExecutableMethod(method.getDeclaringClass(), method.getName(), (Class[])method.getParameterTypes()).map(executableMethod -> this.validateReturnValue(object, (ExecutableMethod<?, Object>)executableMethod, returnValue, groups)).orElse(Collections.emptySet());
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateReturnValue(@NonNull T object, @NonNull ExecutableMethod<?, Object> executableMethod, @Nullable Object returnValue, Class<?> ... groups) {
        ReturnType returnType = executableMethod.getReturnType();
        Argument returnTypeArgument = returnType.asArgument();
        HashSet<ConstraintViolation<T>> overallViolations = new HashSet<ConstraintViolation<T>>(3);
        Class<?> rootBeanClass = object.getClass();
        DefaultConstraintValidatorContext context = new DefaultConstraintValidatorContext((Object)object, (Class[])groups);
        this.validateConstrainedPropertyInternal(rootBeanClass, object, object, (AnnotatedElement)returnTypeArgument, returnType.getType(), returnValue, context, overallViolations, null);
        AnnotationMetadata annotationMetadata = returnTypeArgument.getAnnotationMetadata();
        boolean hasValid = annotationMetadata.isAnnotationPresent(Valid.class);
        if (hasValid) {
            this.validateCascadePropertyInternal(context, rootBeanClass, object, object, returnTypeArgument, returnValue, overallViolations);
        }
        return overallViolations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void validateCascadePropertyInternal(final DefaultConstraintValidatorContext context, final @NonNull Class<T> rootBeanClass, final @Nullable T rootBean, final Object object, final @NonNull Argument<?> cascadeProperty, @Nullable Object propertyValue, final Set overallViolations) {
        if (propertyValue != null) {
            Optional<ValueExtractor<ValueExtractor>> opt = this.valueExtractorRegistry.findValueExtractor(cascadeProperty.getType());
            opt.ifPresent(valueExtractor -> valueExtractor.extractValues(propertyValue, new ValueExtractor.ValueReceiver(){

                public void value(String nodeName, Object object1) {
                }

                public void iterableValue(String nodeName, Object iterableValue) {
                    if (iterableValue != null && context.validatedObjects.contains(iterableValue)) {
                        return;
                    }
                    DefaultValidator.this.cascadeToIterableValue(context, rootBeanClass, rootBean, object, null, cascadeProperty, iterableValue, overallViolations, null, null, true);
                }

                public void indexedValue(String nodeName, int i, Object iterableValue) {
                    if (iterableValue != null && context.validatedObjects.contains(iterableValue)) {
                        return;
                    }
                    DefaultValidator.this.cascadeToIterableValue(context, rootBeanClass, rootBean, object, null, cascadeProperty, iterableValue, overallViolations, i, null, true);
                }

                public void keyedValue(String nodeName, Object key, Object keyedValue) {
                    if (keyedValue != null && context.validatedObjects.contains(keyedValue)) {
                        return;
                    }
                    DefaultValidator.this.cascadeToIterableValue(context, rootBeanClass, rootBean, object, null, cascadeProperty, keyedValue, overallViolations, null, key, false);
                }
            }));
            if (!opt.isPresent() && !context.validatedObjects.contains(propertyValue)) {
                try {
                    Path.Node node = context.addReturnValueNode(cascadeProperty.getName());
                    boolean canCascade = this.canCascade(rootBeanClass, context, propertyValue, node);
                    if (canCascade) {
                        this.cascadeToOne(rootBeanClass, rootBean, object, context, overallViolations, (AnnotatedElement)cascadeProperty, cascadeProperty.getType(), propertyValue, null);
                    }
                }
                finally {
                    context.removeLast();
                }
            }
        }
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateConstructorParameters(@NonNull Constructor<? extends T> constructor, @NonNull Object[] parameterValues, Class<?> ... groups) {
        ArgumentUtils.requireNonNull((String)"constructor", constructor);
        Class<? extends T> declaringClass = constructor.getDeclaringClass();
        BeanIntrospection introspection = BeanIntrospection.getIntrospection(declaringClass);
        return this.validateConstructorParameters(introspection, parameterValues, new Class[0]);
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateConstructorParameters(@NonNull BeanIntrospection<? extends T> introspection, @NonNull Object[] parameterValues, Class<?> ... groups) {
        ArgumentUtils.requireNonNull((String)"introspection", introspection);
        Class beanType = introspection.getBeanType();
        Argument[] constructorArguments = introspection.getConstructorArguments();
        return this.validateConstructorParameters(beanType, constructorArguments, parameterValues, groups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Set<ConstraintViolation<T>> validateConstructorParameters(Class<? extends T> beanType, Argument<?>[] constructorArguments, @NonNull Object[] parameterValues, @Nullable Class<?>[] groups) {
        int argLength;
        if ((parameterValues = parameterValues != null ? parameterValues : ArrayUtils.EMPTY_OBJECT_ARRAY).length != (argLength = constructorArguments.length)) {
            throw new IllegalArgumentException("Expected exactly [" + argLength + "] constructor arguments");
        }
        DefaultConstraintValidatorContext context = new DefaultConstraintValidatorContext((Class[])groups);
        HashSet overallViolations = new HashSet(5);
        Path.Node node = context.addConstructorNode(beanType.getSimpleName(), constructorArguments);
        try {
            this.validateParametersInternal(beanType, null, parameterValues, constructorArguments, argLength, context, overallViolations, node);
        }
        finally {
            context.removeLast();
        }
        return Collections.unmodifiableSet(overallViolations);
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateConstructorReturnValue(@NonNull Constructor<? extends T> constructor, @NonNull T createdObject, Class<?> ... groups) {
        return this.validate(createdObject, groups);
    }

    @Nullable
    protected BeanIntrospection<Object> getBeanIntrospection(@NonNull Object object, @NonNull Class<?> definedClass) {
        if (object == null) {
            return null;
        }
        return BeanIntrospector.SHARED.findIntrospection(object.getClass()).orElseGet(() -> BeanIntrospector.SHARED.findIntrospection(definedClass).orElse(null));
    }

    @Nullable
    protected BeanIntrospection<Object> getBeanIntrospection(@NonNull Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Class) {
            return BeanIntrospector.SHARED.findIntrospection((Class)object).orElse(null);
        }
        return BeanIntrospector.SHARED.findIntrospection(object.getClass()).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void validateParametersInternal(final @NonNull Class<T> rootClass, final @Nullable T object, @NonNull Object[] parameters, Argument[] arguments, int argLen, final DefaultConstraintValidatorContext context, final Set overallViolations, final Path.Node parentNode) {
        for (int i = 0; i < argLen; ++i) {
            boolean isCompletionStage;
            boolean isPublisher;
            final Argument argument = arguments[i];
            Class parameterType = argument.getType();
            AnnotationMetadata annotationMetadata = argument.getAnnotationMetadata();
            boolean hasValid = annotationMetadata.hasStereotype(Validator.ANN_VALID);
            boolean hasConstraint = annotationMetadata.hasStereotype(Validator.ANN_CONSTRAINT);
            if (!hasValid && !hasConstraint) continue;
            final Object parameterValue = parameters[i];
            ValueExtractor valueExtractor = null;
            boolean hasValue = parameterValue != null;
            boolean isValid = hasValue && hasValid;
            boolean bl = isPublisher = hasValue && Publishers.isConvertibleToPublisher((Class)parameterType);
            if (isPublisher) {
                this.instrumentPublisherArgumentWithValidation(rootClass, object, parameters, context, i, argument, parameterType, annotationMetadata, parameterValue, isValid);
                continue;
            }
            boolean bl2 = isCompletionStage = hasValue && CompletionStage.class.isAssignableFrom(parameterType);
            if (isCompletionStage) {
                this.instrumentCompletionStageArgumentWithValidation(rootClass, object, parameters, context, i, argument, annotationMetadata, parameterValue, isValid);
                continue;
            }
            if (hasValue) {
                valueExtractor = this.valueExtractorRegistry.findUnwrapValueExtractor(parameterType).orElse(null);
            }
            int finalIndex = i;
            if (valueExtractor != null) {
                valueExtractor.extractValues(parameterValue, (nodeName, unwrappedValue) -> this.validateParameterInternal(rootClass, object, parameters, context, overallViolations, argument.getName(), unwrappedValue == null ? Object.class : unwrappedValue.getClass(), finalIndex, annotationMetadata, unwrappedValue));
            } else {
                this.validateParameterInternal(rootClass, object, parameters, context, overallViolations, argument.getName(), parameterType, finalIndex, annotationMetadata, parameterValue);
            }
            if (!isValid || context.validatedObjects.contains(parameterValue)) continue;
            valueExtractor = this.valueExtractorRegistry.findValueExtractor(parameterType).orElse(null);
            if (valueExtractor != null) {
                valueExtractor.extractValues(parameterValue, new ValueExtractor.ValueReceiver(){

                    public void value(String nodeName, Object object1) {
                    }

                    public void iterableValue(String nodeName, Object iterableValue) {
                        if (iterableValue != null && context.validatedObjects.contains(iterableValue)) {
                            return;
                        }
                        DefaultValidator.this.cascadeToIterableValue(context, rootClass, object, parameterValue, parentNode, argument, iterableValue, overallViolations, null, null, true);
                    }

                    public void indexedValue(String nodeName, int i, Object iterableValue) {
                        if (iterableValue != null && context.validatedObjects.contains(iterableValue)) {
                            return;
                        }
                        DefaultValidator.this.cascadeToIterableValue(context, rootClass, object, parameterValue, parentNode, argument, iterableValue, overallViolations, i, null, true);
                    }

                    public void keyedValue(String nodeName, Object key, Object keyedValue) {
                        if (keyedValue != null && context.validatedObjects.contains(keyedValue)) {
                            return;
                        }
                        DefaultValidator.this.cascadeToIterableValue(context, rootClass, object, parameterValue, parentNode, argument, keyedValue, overallViolations, null, key, false);
                    }
                });
                continue;
            }
            BeanIntrospection<Object> beanIntrospection = this.getBeanIntrospection(parameterValue, parameterType);
            if (beanIntrospection != null) {
                try {
                    context.addParameterNode(argument.getName(), i);
                    this.cascadeToOneIntrospection(context, object, parameterValue, beanIntrospection, overallViolations);
                    continue;
                }
                finally {
                    context.removeLast();
                }
            }
            context.addParameterNode(argument.getName(), i);
            overallViolations.add(this.createIntrospectionConstraintViolation(rootClass, object, context, parameterType, parameterValue, parameters));
            context.removeLast();
        }
    }

    private <T> void instrumentPublisherArgumentWithValidation(@NonNull Class<T> rootClass, @Nullable T object, @NonNull Object[] argumentValues, DefaultConstraintValidatorContext context, int argumentIndex, Argument argument, Class<?> parameterType, AnnotationMetadata annotationMetadata, Object parameterValue, boolean isValid) {
        Publisher publisher = (Publisher)Publishers.convertPublisher((Object)parameterValue, Publisher.class);
        PathImpl copied = new PathImpl(context.currentPath);
        Flux finalFlowable = Flux.from((Publisher)publisher).flatMap(o -> {
            BeanIntrospection<Object> beanIntrospection;
            DefaultConstraintValidatorContext newContext = new DefaultConstraintValidatorContext(object, copied, new Class[0]);
            HashSet newViolations = new HashSet();
            BeanIntrospection<Object> beanIntrospection2 = beanIntrospection = !isValid || o == null || ClassUtils.isJavaBasicType(o.getClass()) ? null : this.getBeanIntrospection(o);
            if (beanIntrospection != null) {
                try {
                    context.addParameterNode(argument.getName(), argumentIndex);
                    this.cascadeToOneIntrospection(newContext, object, o, beanIntrospection, newViolations);
                }
                finally {
                    context.removeLast();
                }
            } else {
                Class<Object> t = argument.getFirstTypeVariable().map(TypeInformation::getType).orElse(null);
                this.validateParameterInternal(rootClass, object, argumentValues, newContext, newViolations, argument.getName(), t != null ? t : Object.class, argumentIndex, annotationMetadata, o);
            }
            if (!newViolations.isEmpty()) {
                return Flux.error((Throwable)new ConstraintViolationException(newViolations));
            }
            return Flux.just((Object)o);
        });
        argumentValues[argumentIndex] = Publishers.convertPublisher((Object)finalFlowable, parameterType);
    }

    private <T> void instrumentCompletionStageArgumentWithValidation(@NonNull Class<T> rootClass, @Nullable T object, @NonNull Object[] argumentValues, DefaultConstraintValidatorContext context, int argumentIndex, Argument argument, AnnotationMetadata annotationMetadata, Object parameterValue, boolean isValid) {
        CompletionStage<Object> validatedStage;
        CompletionStage publisher = (CompletionStage)parameterValue;
        PathImpl copied = new PathImpl(context.currentPath);
        argumentValues[argumentIndex] = validatedStage = publisher.thenApply(o -> {
            BeanIntrospection<Object> beanIntrospection;
            DefaultConstraintValidatorContext newContext = new DefaultConstraintValidatorContext(object, copied, new Class[0]);
            HashSet newViolations = new HashSet();
            BeanIntrospection<Object> beanIntrospection2 = beanIntrospection = !isValid || o == null || ClassUtils.isJavaBasicType(o.getClass()) ? null : this.getBeanIntrospection(o);
            if (beanIntrospection != null) {
                try {
                    context.addParameterNode(argument.getName(), argumentIndex);
                    this.cascadeToOneIntrospection(newContext, object, o, beanIntrospection, newViolations);
                }
                finally {
                    context.removeLast();
                }
            } else {
                Class<Object> t = argument.getFirstTypeVariable().map(TypeInformation::getType).orElse(null);
                this.validateParameterInternal(rootClass, object, argumentValues, newContext, newViolations, argument.getName(), t != null ? t : Object.class, argumentIndex, annotationMetadata, o);
            }
            if (!newViolations.isEmpty()) {
                throw new ConstraintViolationException(newViolations);
            }
            return o;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void validateParameterInternal(@NonNull Class<T> rootClass, @Nullable T object, @NonNull Object[] argumentValues, @NonNull DefaultConstraintValidatorContext context, @NonNull Set overallViolations, @NonNull String parameterName, @NonNull Class<?> parameterType, int parameterIndex, @NonNull AnnotationMetadata annotationMetadata, @Nullable Object parameterValue) {
        String currentMessageTemplate = context.getMessageTemplate().orElse(null);
        try {
            context.addParameterNode(parameterName, parameterIndex);
            List constraintTypes = annotationMetadata.getAnnotationTypesByStereotype(Constraint.class);
            for (Class constraintType : constraintTypes) {
                AnnotationValue annotationValue;
                ConstraintValidator constraintValidator = this.constraintValidatorRegistry.findConstraintValidator(constraintType, parameterType).orElse(null);
                if (constraintValidator == null || (annotationValue = annotationMetadata.getAnnotation(constraintType)) == null || constraintValidator.isValid(parameterValue, annotationValue, context)) continue;
                String messageTemplate = this.buildMessageTemplate(context, annotationValue, annotationMetadata);
                Map<String, Object> variables = this.newConstraintVariables(annotationValue, parameterValue, annotationMetadata);
                overallViolations.add(new DefaultConstraintViolation(object, rootClass, object, parameterValue, this.messageSource.interpolate(messageTemplate, MessageSource.MessageContext.of(variables)), messageTemplate, (Path)new PathImpl(context.currentPath), new DefaultConstraintDescriptor(annotationMetadata, constraintType, annotationValue), argumentValues));
            }
            BeanIntrospection<Object> introspection = this.getBeanIntrospection(parameterType);
            if (introspection != null) {
                List pojoConstraints = introspection.getAnnotationTypesByStereotype(Constraint.class);
                for (Class pojoConstraint : pojoConstraints) {
                    this.validatePojoInternal(rootClass, object, argumentValues, context, overallViolations, parameterType, parameterValue, pojoConstraint, introspection.getAnnotation(pojoConstraint));
                }
            }
        }
        finally {
            context.removeLast();
            context.messageTemplate(currentMessageTemplate);
        }
    }

    private <T> void validatePojoInternal(@NonNull Class<T> rootClass, @Nullable T object, @Nullable Object[] argumentValues, @NonNull DefaultConstraintValidatorContext context, @NonNull Set overallViolations, @NonNull Class<?> parameterType, @NonNull Object parameterValue, Class<? extends Annotation> pojoConstraint, AnnotationValue constraintAnnotation) {
        ConstraintValidator constraintValidator = this.constraintValidatorRegistry.findConstraintValidator(pojoConstraint, parameterType).orElse(null);
        if (constraintValidator != null && !constraintValidator.isValid(parameterValue, constraintAnnotation, context)) {
            BeanIntrospection<Object> beanIntrospection = this.getBeanIntrospection(parameterValue);
            if (beanIntrospection == null) {
                throw new ValidationException("Passed object [" + parameterValue + "] cannot be introspected. Please annotate with @Introspected");
            }
            AnnotationMetadata beanAnnotationMetadata = beanIntrospection.getAnnotationMetadata();
            AnnotationValue annotationValue = beanAnnotationMetadata.getAnnotation(pojoConstraint);
            String propertyValue = "";
            String messageTemplate = this.buildMessageTemplate(context, annotationValue, beanAnnotationMetadata);
            Map<String, Object> variables = this.newConstraintVariables(annotationValue, "", beanAnnotationMetadata);
            overallViolations.add(new DefaultConstraintViolation(object, rootClass, object, parameterValue, this.messageSource.interpolate(messageTemplate, MessageSource.MessageContext.of(variables)), messageTemplate, (Path)new PathImpl(context.currentPath), new DefaultConstraintDescriptor<Annotation>(beanAnnotationMetadata, pojoConstraint, annotationValue), argumentValues));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Set<ConstraintViolation<T>> doValidate(BeanIntrospection<T> introspection, final @NonNull T rootBean, final @NonNull Object object, Collection<? extends BeanProperty<Object, Object>> constrainedProperties, Collection<BeanProperty<Object, Object>> cascadeProperties, final DefaultConstraintValidatorContext context, final Set overallViolations, List<Class<? extends Annotation>> pojoConstraints) {
        Object propertyValue;
        Class<?> rootBeanClass = rootBean.getClass();
        for (BeanProperty<Object, Object> beanProperty : constrainedProperties) {
            propertyValue = beanProperty.get(object);
            this.validateConstrainedPropertyInternal(rootBeanClass, rootBean, object, (AnnotatedElement)beanProperty, beanProperty.getType(), propertyValue, context, overallViolations, null);
        }
        for (Class clazz : pojoConstraints) {
            this.validatePojoInternal(rootBeanClass, rootBean, null, context, overallViolations, object.getClass(), object, clazz, introspection.getAnnotation(clazz));
        }
        for (BeanProperty beanProperty : cascadeProperties) {
            propertyValue = beanProperty.get(object);
            if (propertyValue == null) continue;
            Optional<ValueExtractor<?>> opt = this.valueExtractorRegistry.findValueExtractor(propertyValue.getClass());
            opt.ifPresent(valueExtractor -> valueExtractor.extractValues(propertyValue, new ValueExtractor.ValueReceiver(){

                public void value(String nodeName, Object object1) {
                }

                public void iterableValue(String nodeName, Object iterableValue) {
                    if (iterableValue != null && context.validatedObjects.contains(iterableValue)) {
                        return;
                    }
                    DefaultValidator.this.cascadeToIterableValue(context, rootBeanClass, rootBean, object, (BeanProperty<Object, Object>)cascadeProperty, iterableValue, overallViolations, null, null, true);
                }

                public void indexedValue(String nodeName, int i, Object iterableValue) {
                    if (iterableValue != null && context.validatedObjects.contains(iterableValue)) {
                        return;
                    }
                    DefaultValidator.this.cascadeToIterableValue(context, rootBeanClass, rootBean, object, (BeanProperty<Object, Object>)cascadeProperty, iterableValue, overallViolations, i, null, true);
                }

                public void keyedValue(String nodeName, Object key, Object keyedValue) {
                    if (keyedValue != null && context.validatedObjects.contains(keyedValue)) {
                        return;
                    }
                    DefaultValidator.this.cascadeToIterableValue(context, rootBeanClass, rootBean, object, (BeanProperty<Object, Object>)cascadeProperty, keyedValue, overallViolations, null, key, false);
                }
            }));
            if (opt.isPresent() || context.validatedObjects.contains(propertyValue)) continue;
            Path.Node node = context.addPropertyNode(beanProperty.getName(), null);
            try {
                boolean canCascade = this.canCascade(rootBeanClass, context, propertyValue, node);
                if (!canCascade) continue;
                this.cascadeToOne(rootBeanClass, rootBean, object, context, overallViolations, (AnnotatedElement)beanProperty, beanProperty.getType(), propertyValue, null);
            }
            finally {
                context.removeLast();
            }
        }
        return Collections.unmodifiableSet(overallViolations);
    }

    private <T> boolean canCascade(Class<T> rootBeanClass, DefaultConstraintValidatorContext context, Object propertyValue, Path.Node node) {
        boolean canCascade = this.traversableResolver.isCascadable(propertyValue, node, rootBeanClass, (Path)context.currentPath, ElementType.FIELD);
        boolean isReachable = this.traversableResolver.isReachable(propertyValue, node, rootBeanClass, (Path)context.currentPath, ElementType.FIELD);
        return canCascade && isReachable;
    }

    private <T> void cascadeToIterableValue(DefaultConstraintValidatorContext context, @NonNull Class<T> rootClass, @Nullable T rootBean, Object object, BeanProperty<Object, Object> cascadeProperty, Object iterableValue, Set overallViolations, Integer index, Object key, boolean isIterable) {
        DefaultPropertyNode container = new DefaultPropertyNode(cascadeProperty.getName(), cascadeProperty.getType(), index, key, ElementKind.CONTAINER_ELEMENT, isIterable);
        this.cascadeToOne(rootClass, rootBean, object, context, overallViolations, (AnnotatedElement)cascadeProperty, cascadeProperty.getType(), iterableValue, container);
    }

    private <T> void cascadeToIterableValue(DefaultConstraintValidatorContext context, @NonNull Class<T> rootClass, @Nullable T rootBean, @Nullable Object object, Path.Node node, Argument methodArgument, Object iterableValue, Set overallViolations, Integer index, Object key, boolean isIterable) {
        if (this.canCascade(rootClass, context, iterableValue, node)) {
            DefaultPropertyNode currentContainerNode = new DefaultPropertyNode(methodArgument.getName(), methodArgument.getClass(), index, key, ElementKind.CONTAINER_ELEMENT, isIterable);
            this.cascadeToOne(rootClass, rootBean, object, context, overallViolations, (AnnotatedElement)methodArgument, methodArgument.getType(), iterableValue, currentContainerNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void cascadeToOne(@NonNull Class<T> rootClass, @Nullable T rootBean, Object object, DefaultConstraintValidatorContext context, Set overallViolations, AnnotatedElement cascadeProperty, Class propertyType, Object propertyValue, @Nullable DefaultPropertyNode container) {
        Class beanType = Object.class;
        if (propertyValue != null) {
            beanType = propertyValue.getClass();
        } else if (cascadeProperty instanceof BeanProperty) {
            Argument argument = ((BeanProperty)cascadeProperty).asArgument();
            if (Map.class.isAssignableFrom(argument.getType())) {
                Argument[] typeParameters = argument.getTypeParameters();
                if (typeParameters.length == 2) {
                    beanType = typeParameters[1].getType();
                }
            } else {
                beanType = argument.getFirstTypeVariable().map(TypeInformation::getType).orElse(null);
            }
        }
        BeanIntrospection<Object> beanIntrospection = this.getBeanIntrospection(beanType);
        AnnotationMetadata annotationMetadata = cascadeProperty.getAnnotationMetadata();
        if (beanIntrospection == null && !annotationMetadata.hasStereotype(Constraint.class)) {
            overallViolations.add(this.createIntrospectionConstraintViolation(rootClass, rootBean, context, beanType, propertyValue, new Object[0]));
            return;
        }
        if (beanIntrospection != null) {
            if (container != null) {
                context.addPropertyNode(container.getName(), container);
            }
            try {
                this.cascadeToOneIntrospection(context, rootBean, propertyValue, beanIntrospection, overallViolations);
            }
            finally {
                if (container != null) {
                    context.removeLast();
                }
            }
        } else {
            this.validateConstrainedPropertyInternal(rootClass, rootBean, object, cascadeProperty, propertyType, propertyValue, context, overallViolations, container);
        }
    }

    private <T> void cascadeToOneIntrospection(DefaultConstraintValidatorContext context, T rootBean, Object bean, BeanIntrospection<Object> beanIntrospection, Set overallViolations) {
        context.validatedObjects.add(bean);
        Collection cascadeConstraints = beanIntrospection.getIndexedProperties(Constraint.class);
        Collection cascadeNestedProperties = beanIntrospection.getIndexedProperties(Valid.class);
        List pojoConstraints = beanIntrospection.getAnnotationMetadata().getAnnotationTypesByStereotype(Constraint.class);
        if (CollectionUtils.isNotEmpty((Collection)cascadeConstraints) || CollectionUtils.isNotEmpty((Collection)cascadeNestedProperties) || CollectionUtils.isNotEmpty((Collection)pojoConstraints)) {
            this.doValidate(beanIntrospection, rootBean, bean, cascadeConstraints, cascadeNestedProperties, context, overallViolations, pojoConstraints);
        }
    }

    private <T> void validateConstrainedPropertyInternal(@NonNull Class<T> rootBeanClass, @Nullable T rootBean, @NonNull Object object, @NonNull AnnotatedElement constrainedProperty, @NonNull Class propertyType, @Nullable Object propertyValue, DefaultConstraintValidatorContext context, Set<ConstraintViolation<Object>> overallViolations, @Nullable DefaultPropertyNode container) {
        context.addPropertyNode(constrainedProperty.getName(), container);
        String currentMessageTemplate = context.getMessageTemplate().orElse(null);
        this.validatePropertyInternal(rootBeanClass, rootBean, object, context, overallViolations, propertyType, constrainedProperty, propertyValue);
        context.removeLast();
        context.messageTemplate(currentMessageTemplate);
    }

    private <T> void validatePropertyInternal(@Nullable Class<T> rootBeanClass, @Nullable T rootBean, @Nullable Object object, @NonNull DefaultConstraintValidatorContext context, @NonNull Set<ConstraintViolation<Object>> overallViolations, @NonNull Class propertyType, @NonNull AnnotatedElement constrainedProperty, @Nullable Object propertyValue) {
        AnnotationMetadata annotationMetadata = constrainedProperty.getAnnotationMetadata();
        List constraintTypes = annotationMetadata.getAnnotationTypesByStereotype(Constraint.class);
        for (Class constraintType : constraintTypes) {
            ValueExtractor valueExtractor = null;
            if (propertyValue != null && !annotationMetadata.hasAnnotation(Valid.class)) {
                valueExtractor = this.valueExtractorRegistry.findUnwrapValueExtractor(propertyValue.getClass()).orElse(null);
            }
            if (valueExtractor != null) {
                valueExtractor.extractValues(propertyValue, (nodeName, extractedValue) -> this.valueConstraintOnProperty(rootBeanClass, rootBean, object, context, overallViolations, constrainedProperty, propertyType, extractedValue, constraintType));
                continue;
            }
            this.valueConstraintOnProperty(rootBeanClass, rootBean, object, context, overallViolations, constrainedProperty, propertyType, propertyValue, constraintType);
        }
    }

    private <T> void valueConstraintOnProperty(@Nullable Class<T> rootBeanClass, @Nullable T rootBean, @Nullable Object object, DefaultConstraintValidatorContext context, Set<ConstraintViolation<Object>> overallViolations, AnnotatedElement constrainedProperty, Class propertyType, @Nullable Object propertyValue, Class<? extends Annotation> constraintType) {
        AnnotationMetadata annotationMetadata = constrainedProperty.getAnnotationMetadata();
        List annotationValues = annotationMetadata.getAnnotationValuesByType(constraintType);
        HashSet<AnnotationValue> constraints = new HashSet<AnnotationValue>(3);
        for (Class group : context.groups) {
            for (AnnotationValue annotationValue : annotationValues) {
                Object[] classValues = annotationValue.classValues("groups");
                if (ArrayUtils.isEmpty((Object[])classValues)) {
                    if (context.groups != DEFAULT_GROUPS && group != Default.class) continue;
                    constraints.add(annotationValue);
                    continue;
                }
                List<Object> constraintGroups = Arrays.asList(classValues);
                if (!constraintGroups.contains(group)) continue;
                constraints.add(annotationValue);
            }
        }
        Class<?> targetType = propertyValue != null ? propertyValue.getClass() : propertyType;
        ConstraintValidator validator = this.constraintValidatorRegistry.findConstraintValidator(constraintType, targetType).orElse(null);
        if (validator != null) {
            for (AnnotationValue annotationValue : constraints) {
                if (validator.isValid(propertyValue, annotationValue, context)) continue;
                String messageTemplate = this.buildMessageTemplate(context, annotationValue, annotationMetadata);
                Map<String, Object> variables = this.newConstraintVariables(annotationValue, propertyValue, annotationMetadata);
                overallViolations.add(new DefaultConstraintViolation(rootBean, rootBeanClass, object, propertyValue, this.messageSource.interpolate(messageTemplate, MessageSource.MessageContext.of(variables)), messageTemplate, (Path)new PathImpl(context.currentPath), new DefaultConstraintDescriptor<Annotation>(annotationMetadata, constraintType, annotationValue), new Object[0]));
            }
        }
    }

    private Map<String, Object> newConstraintVariables(AnnotationValue annotationValue, @Nullable Object propertyValue, AnnotationMetadata annotationMetadata) {
        Map values = annotationValue.getValues();
        int initSize = (int)Math.ceil((double)values.size() / 0.75);
        LinkedHashMap<String, Object> variables = new LinkedHashMap<String, Object>(initSize);
        for (Map.Entry entry : values.entrySet()) {
            variables.put(entry.getKey().toString(), entry.getValue());
        }
        variables.put("validatedValue", propertyValue);
        Map defaultValues = annotationMetadata.getDefaultValues(annotationValue.getAnnotationName());
        for (Map.Entry entry : defaultValues.entrySet()) {
            Object v;
            String n = (String)entry.getKey();
            if (variables.containsKey(n) || (v = entry.getValue()) == null) continue;
            variables.put(n, v);
        }
        return variables;
    }

    private String buildMessageTemplate(DefaultConstraintValidatorContext context, AnnotationValue<?> annotationValue, AnnotationMetadata annotationMetadata) {
        return context.getMessageTemplate().orElseGet(() -> annotationValue.stringValue("message").orElseGet(() -> annotationMetadata.getDefaultValue(annotationValue.getAnnotationName(), "message", String.class).orElse("{" + annotationValue.getAnnotationName() + ".message}")));
    }

    @Override
    @NonNull
    public <T> Publisher<T> validatePublisher(@NonNull Publisher<T> publisher, Class<?> ... groups) {
        ArgumentUtils.requireNonNull((String)"publisher", publisher);
        Publisher reactiveSequence = (Publisher)Publishers.convertPublisher(publisher, Publisher.class);
        return Flux.from((Publisher)reactiveSequence).flatMap(object -> {
            Set<ConstraintViolation<Object>> constraintViolations = this.validate(object, groups);
            if (!constraintViolations.isEmpty()) {
                return Flux.error((Throwable)new ConstraintViolationException(constraintViolations));
            }
            return Flux.just((Object)object);
        });
    }

    @Override
    @NonNull
    public <T> CompletionStage<T> validateCompletionStage(@NonNull CompletionStage<T> completionStage, Class<?> ... groups) {
        ArgumentUtils.requireNonNull((String)"completionStage", completionStage);
        return completionStage.thenApply(t -> {
            Set<ConstraintViolation<Object>> constraintViolations = this.validate(t, groups);
            if (!constraintViolations.isEmpty()) {
                throw new ConstraintViolationException(constraintViolations);
            }
            return t;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void validateBeanArgument(@NonNull BeanResolutionContext resolutionContext, @NonNull InjectionPoint injectionPoint, final @NonNull Argument<T> argument, int index, final @Nullable T value) throws BeanInstantiationException {
        BeanIntrospection<Object> beanIntrospection;
        AnnotationMetadata annotationMetadata = argument.getAnnotationMetadata();
        boolean hasValid = annotationMetadata.hasStereotype(Valid.class);
        boolean hasConstraint = annotationMetadata.hasStereotype(Constraint.class);
        Class parameterType = argument.getType();
        final Class rootClass = injectionPoint.getDeclaringBean().getBeanType();
        final DefaultConstraintValidatorContext context = new DefaultConstraintValidatorContext((Object)value, new Class[0]);
        final HashSet<ConstraintViolation<T>> overallViolations = new HashSet<ConstraintViolation<T>>(5);
        if (hasConstraint) {
            final Path.Node parentNode = context.addConstructorNode(rootClass.getName(), injectionPoint.getDeclaringBean().getConstructor().getArguments());
            ValueExtractor valueExtractor = this.valueExtractorRegistry.findValueExtractor(parameterType).orElse(null);
            if (valueExtractor != null) {
                valueExtractor.extractValues(value, new ValueExtractor.ValueReceiver(){

                    public void value(String nodeName, Object object1) {
                    }

                    public void iterableValue(String nodeName, Object iterableValue) {
                        if (iterableValue != null && context.validatedObjects.contains(iterableValue)) {
                            return;
                        }
                        DefaultValidator.this.cascadeToIterableValue(context, rootClass, null, value, parentNode, argument, iterableValue, overallViolations, null, null, true);
                    }

                    public void indexedValue(String nodeName, int i, Object iterableValue) {
                        if (iterableValue != null && context.validatedObjects.contains(iterableValue)) {
                            return;
                        }
                        DefaultValidator.this.cascadeToIterableValue(context, rootClass, null, value, parentNode, argument, iterableValue, overallViolations, i, null, true);
                    }

                    public void keyedValue(String nodeName, Object key, Object keyedValue) {
                        if (keyedValue != null && context.validatedObjects.contains(keyedValue)) {
                            return;
                        }
                        DefaultValidator.this.cascadeToIterableValue(context, rootClass, null, value, parentNode, argument, keyedValue, overallViolations, null, key, false);
                    }
                });
            } else {
                this.validateParameterInternal(rootClass, null, ArrayUtils.EMPTY_OBJECT_ARRAY, context, overallViolations, argument.getName(), parameterType, index, annotationMetadata, value);
            }
            context.removeLast();
        } else if (hasValid && value != null && (beanIntrospection = this.getBeanIntrospection(value, parameterType)) != null) {
            try {
                context.addParameterNode(argument.getName(), index);
                this.cascadeToOneIntrospection(context, null, value, beanIntrospection, overallViolations);
            }
            finally {
                context.removeLast();
            }
        }
        this.failOnError(resolutionContext, overallViolations, rootClass);
    }

    public <T> void validateBean(@NonNull BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> definition, @NonNull T bean) throws BeanInstantiationException {
        Collection executableMethods;
        BeanIntrospection<Object> introspection = this.getBeanIntrospection(bean);
        if (introspection != null) {
            Set<ConstraintViolation<T>> errors = this.validate(introspection, bean, new Class[0]);
            Class<?> beanType = bean.getClass();
            this.failOnError(resolutionContext, errors, beanType);
        } else if (bean instanceof Intercepted && definition.hasStereotype(ConfigurationReader.class) && CollectionUtils.isNotEmpty((Collection)(executableMethods = definition.getExecutableMethods()))) {
            HashSet<ConstraintViolation<Object>> errors = new HashSet<ConstraintViolation<Object>>();
            DefaultConstraintValidatorContext context = new DefaultConstraintValidatorContext((Object)bean, new Class[0]);
            Class beanType = definition.getBeanType();
            Object[] interfaces = beanType.getInterfaces();
            if (ArrayUtils.isNotEmpty((Object[])interfaces)) {
                context.addConstructorNode(((Class)interfaces[0]).getSimpleName(), new Argument[0]);
            } else {
                context.addConstructorNode(beanType.getSimpleName(), new Argument[0]);
            }
            for (ExecutableMethod executableMethod : executableMethods) {
                if (!executableMethod.hasAnnotation(Property.class)) continue;
                boolean hasConstraint = executableMethod.hasStereotype(Constraint.class);
                boolean isValid = executableMethod.hasStereotype(Valid.class);
                if (!hasConstraint && !isValid) continue;
                Object value = executableMethod.invoke(bean, new Object[0]);
                this.validateConstrainedPropertyInternal(beanType, bean, bean, (AnnotatedElement)executableMethod, executableMethod.getReturnType().getType(), value, context, errors, null);
            }
            this.failOnError(resolutionContext, errors, beanType);
        }
    }

    private <T> void failOnError(@NonNull BeanResolutionContext resolutionContext, Set<ConstraintViolation<T>> errors, Class<?> beanType) {
        if (!errors.isEmpty()) {
            StringBuilder builder = new StringBuilder().append("Validation failed for bean definition [").append(beanType.getName()).append("]\nList of constraint violations:[\n");
            for (ConstraintViolation<T> violation : errors) {
                builder.append('\t').append(violation.getPropertyPath()).append(" - ").append(violation.getMessage()).append('\n');
            }
            builder.append(']');
            throw new BeanInstantiationException(resolutionContext, builder.toString());
        }
    }

    @NonNull
    private <T> DefaultConstraintViolation<T> createIntrospectionConstraintViolation(@NonNull Class<T> rootClass, T object, DefaultConstraintValidatorContext context, Class<?> parameterType, Object parameterValue, Object ... parameters) {
        String messageTemplate = context.getMessageTemplate().orElseGet(() -> "{" + Introspected.class.getName() + ".message}");
        return new DefaultConstraintViolation(object, rootClass, object, parameterValue, this.messageSource.interpolate(messageTemplate, MessageSource.MessageContext.of(Collections.singletonMap("type", parameterType.getName()))), messageTemplate, (Path)new PathImpl(context.currentPath), null, parameters);
    }

    private final class EmptyDescriptor
    implements BeanDescriptor,
    ElementDescriptor.ConstraintFinder {
        private final Class<?> elementClass;

        EmptyDescriptor(Class<?> elementClass) {
            this.elementClass = elementClass;
        }

        public boolean isBeanConstrained() {
            return false;
        }

        public PropertyDescriptor getConstraintsForProperty(String propertyName) {
            return null;
        }

        public Set<PropertyDescriptor> getConstrainedProperties() {
            return Collections.emptySet();
        }

        public MethodDescriptor getConstraintsForMethod(String methodName, Class<?> ... parameterTypes) {
            return null;
        }

        public Set<MethodDescriptor> getConstrainedMethods(MethodType methodType, MethodType ... methodTypes) {
            return Collections.emptySet();
        }

        public ConstructorDescriptor getConstraintsForConstructor(Class<?> ... parameterTypes) {
            return null;
        }

        public Set<ConstructorDescriptor> getConstrainedConstructors() {
            return Collections.emptySet();
        }

        public boolean hasConstraints() {
            return false;
        }

        public Class<?> getElementClass() {
            return this.elementClass;
        }

        public ElementDescriptor.ConstraintFinder unorderedAndMatchingGroups(Class<?> ... groups) {
            return this;
        }

        public ElementDescriptor.ConstraintFinder lookingAt(Scope scope) {
            return this;
        }

        public ElementDescriptor.ConstraintFinder declaredOn(ElementType ... types) {
            return this;
        }

        public Set<ConstraintDescriptor<?>> getConstraintDescriptors() {
            return Collections.emptySet();
        }

        public ElementDescriptor.ConstraintFinder findConstraints() {
            return this;
        }
    }

    private final class DefaultConstraintViolation<T>
    implements ConstraintViolation<T> {
        private final T rootBean;
        private final Object invalidValue;
        private final String message;
        private final String messageTemplate;
        private final Path path;
        private final Class<T> rootBeanClass;
        private final Object leafBean;
        private final ConstraintDescriptor<?> constraintDescriptor;
        private final Object[] executableParams;

        private DefaultConstraintViolation(@Nullable T rootBean, Class<T> rootBeanClass, Object leafBean, Object invalidValue, String message, String messageTemplate, Path path, ConstraintDescriptor<?> constraintDescriptor, Object ... executableParams) {
            this.rootBean = rootBean;
            this.rootBeanClass = rootBeanClass;
            this.invalidValue = invalidValue;
            this.message = message;
            this.messageTemplate = messageTemplate;
            this.path = path;
            this.leafBean = leafBean;
            this.constraintDescriptor = constraintDescriptor;
            this.executableParams = executableParams;
        }

        public String getMessage() {
            return this.message;
        }

        public String getMessageTemplate() {
            return this.messageTemplate;
        }

        public T getRootBean() {
            return this.rootBean;
        }

        public Class<T> getRootBeanClass() {
            return this.rootBeanClass;
        }

        public Object getLeafBean() {
            return this.leafBean;
        }

        public Object[] getExecutableParameters() {
            if (this.executableParams != null) {
                return this.executableParams;
            }
            return ArrayUtils.EMPTY_OBJECT_ARRAY;
        }

        public Object getExecutableReturnValue() {
            return null;
        }

        public Path getPropertyPath() {
            return this.path;
        }

        public Object getInvalidValue() {
            return this.invalidValue;
        }

        public ConstraintDescriptor<?> getConstraintDescriptor() {
            return this.constraintDescriptor;
        }

        public <U> U unwrap(Class<U> type) {
            throw new UnsupportedOperationException("Unwrapping is unsupported by this implementation");
        }

        public String toString() {
            return "DefaultConstraintViolation{rootBean=" + this.rootBean.getClass() + ", invalidValue=" + this.invalidValue + ", path=" + this.path + '}';
        }
    }

    private class DefaultPropertyNode
    implements Path.PropertyNode {
        private final Class<?> containerClass;
        private final String name;
        private final Integer index;
        private final Object key;
        private final ElementKind kind;
        private final boolean isIterable;

        DefaultPropertyNode(@Nullable String name, @Nullable Class<?> containerClass, @Nullable Integer index, @NonNull Object key, ElementKind kind, boolean isIterable) {
            this.containerClass = containerClass;
            this.name = name;
            this.index = index;
            this.key = key;
            this.kind = kind;
            this.isIterable = isIterable || index != null;
        }

        DefaultPropertyNode(@NonNull String name, DefaultPropertyNode parent) {
            this(name, parent.containerClass, parent.getIndex(), parent.getKey(), ElementKind.CONTAINER_ELEMENT, parent.isInIterable());
        }

        public Class<?> getContainerClass() {
            return this.containerClass;
        }

        public Integer getTypeArgumentIndex() {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public boolean isInIterable() {
            return this.isIterable;
        }

        public Integer getIndex() {
            return this.index;
        }

        public Object getKey() {
            return this.key;
        }

        public ElementKind getKind() {
            return this.kind;
        }

        public String toString() {
            return this.getName();
        }

        public <T extends Path.Node> T as(Class<T> nodeType) {
            throw new UnsupportedOperationException("Unwrapping is unsupported by this implementation");
        }
    }

    private class DefaultReturnValueNode
    implements Path.ReturnValueNode {
        private final String name;
        private final Integer index;
        private final Object key;
        private final ElementKind kind;
        private final boolean isInIterable;

        public DefaultReturnValueNode(String name, Integer index, Object key, ElementKind kind, boolean isInIterable) {
            this.name = name;
            this.index = index;
            this.key = key;
            this.kind = kind;
            this.isInIterable = isInIterable;
        }

        public DefaultReturnValueNode(String name) {
            this(name, null, null, ElementKind.RETURN_VALUE, false);
        }

        public String getName() {
            return this.name;
        }

        public Integer getIndex() {
            return this.index;
        }

        public Object getKey() {
            return this.key;
        }

        public ElementKind getKind() {
            return this.kind;
        }

        public boolean isInIterable() {
            return this.isInIterable;
        }

        public <T extends Path.Node> T as(Class<T> nodeType) {
            throw new UnsupportedOperationException("Unwrapping is unsupported by this implementation");
        }
    }

    private final class DefaultParameterNode
    extends DefaultPropertyNode
    implements Path.ParameterNode {
        private final int parameterIndex;

        DefaultParameterNode(String name, int parameterIndex) {
            super(name, null, null, null, ElementKind.PARAMETER, false);
            this.parameterIndex = parameterIndex;
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.PARAMETER;
        }

        @Override
        public <T extends Path.Node> T as(Class<T> nodeType) {
            throw new UnsupportedOperationException("Unwrapping is unsupported by this implementation");
        }

        public int getParameterIndex() {
            return this.parameterIndex;
        }
    }

    private class DefaultMethodNode
    implements Path.MethodNode {
        private final MethodReference<?, ?> methodReference;

        public DefaultMethodNode(MethodReference<?, ?> methodReference) {
            this.methodReference = methodReference;
        }

        public List<Class<?>> getParameterTypes() {
            return Arrays.asList(this.methodReference.getArgumentTypes());
        }

        public String getName() {
            return this.methodReference.getMethodName();
        }

        public boolean isInIterable() {
            return false;
        }

        public Integer getIndex() {
            return null;
        }

        public Object getKey() {
            return null;
        }

        public ElementKind getKind() {
            return ElementKind.METHOD;
        }

        public String toString() {
            return this.getName();
        }

        public <T extends Path.Node> T as(Class<T> nodeType) {
            throw new UnsupportedOperationException("Unwrapping is unsupported by this implementation");
        }
    }

    private final class DefaultConstructorNode
    extends DefaultMethodNode
    implements Path.ConstructorNode {
        public DefaultConstructorNode(MethodReference<Object, Object> methodReference) {
            super(methodReference);
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.CONSTRUCTOR;
        }
    }

    private final class PathImpl
    implements Path {
        final Deque<Path.Node> nodes;

        private PathImpl(PathImpl nodes) {
            this.nodes = new LinkedList<Path.Node>(nodes.nodes);
        }

        private PathImpl() {
            this.nodes = new LinkedList<Path.Node>();
        }

        public Iterator<Path.Node> iterator() {
            return this.nodes.iterator();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            Iterator<Path.Node> i = this.nodes.iterator();
            while (i.hasNext()) {
                Path.Node node = i.next();
                builder.append(node.getName());
                if (node.getKind() == ElementKind.CONTAINER_ELEMENT) {
                    Integer index = node.getIndex();
                    if (index != null) {
                        builder.append('[').append(index).append(']');
                    } else {
                        Object key = node.getKey();
                        if (key != null) {
                            builder.append('[').append(key).append(']');
                        } else {
                            builder.append("[]");
                        }
                    }
                }
                if (!i.hasNext()) continue;
                builder.append('.');
            }
            return builder.toString();
        }
    }

    private final class DefaultConstraintValidatorContext
    implements ConstraintValidatorContext {
        final Set<Object> validatedObjects = new HashSet<Object>(20);
        final PathImpl currentPath;
        final List<Class> groups;
        String messageTemplate = null;

        private <T> DefaultConstraintValidatorContext(T object, Class<?> ... groups) {
            this(object, defaultValidator.new PathImpl(), groups);
        }

        private <T> DefaultConstraintValidatorContext(T object, PathImpl path, Class<?> ... groups) {
            if (object != null) {
                this.validatedObjects.add(object);
            }
            this.groups = ArrayUtils.isNotEmpty((Object[])groups) ? Arrays.asList(groups) : DEFAULT_GROUPS;
            this.currentPath = path != null ? path : new PathImpl();
        }

        private DefaultConstraintValidatorContext(Class<?> ... groups) {
            this((Object)null, groups);
        }

        @Override
        @NonNull
        public ClockProvider getClockProvider() {
            return DefaultValidator.this.clockProvider;
        }

        @Override
        @Nullable
        public Object getRootBean() {
            return this.validatedObjects.isEmpty() ? null : this.validatedObjects.iterator().next();
        }

        @Override
        public void messageTemplate(@Nullable String messageTemplate) {
            this.messageTemplate = messageTemplate;
        }

        Optional<String> getMessageTemplate() {
            return Optional.ofNullable(this.messageTemplate);
        }

        Path.Node addPropertyNode(String name, @Nullable DefaultPropertyNode container) {
            DefaultPropertyNode node = container != null ? new DefaultPropertyNode(name, container) : new DefaultPropertyNode(name, null, null, null, ElementKind.PROPERTY, false);
            this.currentPath.nodes.add((Path.Node)node);
            return node;
        }

        Path.Node addReturnValueNode(String name) {
            DefaultReturnValueNode returnValueNode = new DefaultReturnValueNode(name);
            this.currentPath.nodes.add((Path.Node)returnValueNode);
            return returnValueNode;
        }

        void removeLast() {
            this.currentPath.nodes.removeLast();
        }

        Path.Node addMethodNode(MethodReference<?, ?> reference) {
            DefaultMethodNode methodNode = new DefaultMethodNode(reference);
            this.currentPath.nodes.add((Path.Node)methodNode);
            return methodNode;
        }

        void addParameterNode(String name, int index) {
            DefaultParameterNode node = new DefaultParameterNode(name, index);
            this.currentPath.nodes.add((Path.Node)node);
        }

        Path.Node addConstructorNode(final String simpleName, final Argument<?> ... constructorArguments) {
            DefaultConstructorNode node = new DefaultConstructorNode(new MethodReference<Object, Object>(){

                public Argument[] getArguments() {
                    return constructorArguments;
                }

                public Method getTargetMethod() {
                    return null;
                }

                public ReturnType<Object> getReturnType() {
                    return null;
                }

                public Class getDeclaringType() {
                    return null;
                }

                public String getMethodName() {
                    return simpleName;
                }
            });
            this.currentPath.nodes.add((Path.Node)node);
            return node;
        }
    }
}

