/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker;

import io.netty.handler.codec.mqtt.MqttVersion;
import java.time.Clock;
import java.time.Instant;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public interface ISessionsRepository {
    public Collection<SessionData> list();

    public void saveSession(SessionData var1);

    public void delete(SessionData var1);

    public static final class SessionData
    implements Delayed {
        private final String clientId;
        private Instant expireAt = null;
        final MqttVersion version;
        private final int expiryInterval;
        private final transient Clock clock;

        public SessionData(String clientId, MqttVersion version, int expiryInterval, Clock clock) {
            this.clientId = clientId;
            this.clock = clock;
            this.expiryInterval = expiryInterval;
            this.version = version;
        }

        public SessionData(String clientId, Instant expireAt, MqttVersion version, int expiryInterval, Clock clock) {
            Objects.requireNonNull(expireAt, "An expiration time is requested");
            this.clock = clock;
            this.clientId = clientId;
            this.expireAt = expireAt;
            this.expiryInterval = expiryInterval;
            this.version = version;
        }

        public String clientId() {
            return this.clientId;
        }

        public MqttVersion protocolVersion() {
            return this.version;
        }

        public Optional<Instant> expireAt() {
            return Optional.ofNullable(this.expireAt);
        }

        public Optional<Long> expiryInstant() {
            return this.expireAt().map(Instant::toEpochMilli);
        }

        public int expiryInterval() {
            return this.expiryInterval;
        }

        public SessionData withExpirationComputed() {
            Instant expiresAt = this.clock.instant().plusSeconds(this.expiryInterval);
            return new SessionData(this.clientId, expiresAt, this.version, this.expiryInterval, this.clock);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SessionData that = (SessionData)o;
            return this.clientId.equals(that.clientId);
        }

        public int hashCode() {
            return Objects.hash(this.clientId);
        }

        public String toString() {
            return "SessionData{clientId='" + this.clientId + '\'' + ", expireAt=" + this.expireAt + ", version=" + this.version + ", expiryInterval=" + this.expiryInterval + '}';
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.expireAt.toEpochMilli() - this.clock.millis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            return Long.compare(this.getDelay(TimeUnit.MILLISECONDS), o.getDelay(TimeUnit.MILLISECONDS));
        }
    }
}

