/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jms.common;

import io.opentracing.Tracer;
import io.opentracing.contrib.jms.common.TracingMessageUtils;
import io.opentracing.util.GlobalTracer;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;

public class TracingMessageConsumer
implements MessageConsumer {
    private final MessageConsumer messageConsumer;
    private final Tracer tracer;

    public TracingMessageConsumer(MessageConsumer messageConsumer) {
        this(messageConsumer, GlobalTracer.get());
    }

    public TracingMessageConsumer(MessageConsumer messageConsumer, Tracer tracer) {
        this.messageConsumer = messageConsumer;
        this.tracer = tracer;
    }

    public String getMessageSelector() throws JMSException {
        return this.messageConsumer.getMessageSelector();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.messageConsumer.getMessageListener();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.messageConsumer.setMessageListener(listener);
    }

    public Message receive() throws JMSException {
        Message message = this.messageConsumer.receive();
        this.finishSpan(message);
        return message;
    }

    public Message receive(long timeout) throws JMSException {
        Message message = this.messageConsumer.receive(timeout);
        this.finishSpan(message);
        return message;
    }

    public Message receiveNoWait() throws JMSException {
        Message message = this.messageConsumer.receiveNoWait();
        this.finishSpan(message);
        return message;
    }

    public void close() throws JMSException {
        this.messageConsumer.close();
    }

    private void finishSpan(Message message) throws JMSException {
        TracingMessageUtils.buildAndFinishChildSpan(message, this.tracer);
    }
}

