/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jms.common;

import io.opentracing.Scope;
import io.opentracing.Tracer;
import io.opentracing.contrib.jms.common.TracingMessageUtils;
import io.opentracing.util.GlobalTracer;
import javax.jms.Message;
import javax.jms.MessageListener;

public class TracingMessageListener
implements MessageListener {
    private final MessageListener messageListener;
    private final Tracer tracer;

    public TracingMessageListener(MessageListener messageListener) {
        this(messageListener, GlobalTracer.get());
    }

    public TracingMessageListener(MessageListener messageListener, Tracer tracer) {
        this.messageListener = messageListener;
        this.tracer = tracer;
    }

    public void onMessage(Message message) {
        try (Scope scope = TracingMessageUtils.buildFollowingSpan(message, this.tracer);){
            if (this.messageListener != null) {
                this.messageListener.onMessage(message);
            }
        }
    }
}

