/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jms.common;

import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.jms.common.SpanContextContainer;
import io.opentracing.contrib.jms.common.TracingMessageListener;
import io.opentracing.contrib.jms.common.TracingMessageUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;

public class TracingMessageConsumer
implements MessageConsumer {
    private final MessageConsumer messageConsumer;
    private final Tracer tracer;
    private final boolean proxyMessage;
    private final boolean traceInLog;

    public TracingMessageConsumer(MessageConsumer messageConsumer, Tracer tracer) {
        this(messageConsumer, tracer, false, false);
    }

    public TracingMessageConsumer(MessageConsumer messageConsumer, Tracer tracer, boolean proxyMessage) {
        this(messageConsumer, tracer, proxyMessage, false);
    }

    public TracingMessageConsumer(MessageConsumer messageConsumer, Tracer tracer, boolean proxyMessage, boolean traceInLog) {
        this.messageConsumer = messageConsumer;
        this.tracer = tracer;
        this.proxyMessage = proxyMessage;
        this.traceInLog = traceInLog;
    }

    public String getMessageSelector() throws JMSException {
        return this.messageConsumer.getMessageSelector();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.messageConsumer.getMessageListener();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        if (listener instanceof TracingMessageConsumer) {
            this.messageConsumer.setMessageListener(listener);
        } else {
            this.messageConsumer.setMessageListener((MessageListener)new TracingMessageListener(listener, this.tracer, this.traceInLog));
        }
    }

    public Message receive() throws JMSException {
        Message message = this.messageConsumer.receive();
        if (this.proxyMessage) {
            return this.proxy(message, this.finishSpan(message));
        }
        this.finishSpan(message);
        return message;
    }

    public Message receive(long timeout) throws JMSException {
        Message message = this.messageConsumer.receive(timeout);
        if (this.proxyMessage) {
            return this.proxy(message, this.finishSpan(message));
        }
        this.finishSpan(message);
        return message;
    }

    public Message receiveNoWait() throws JMSException {
        Message message = this.messageConsumer.receiveNoWait();
        if (this.proxyMessage) {
            return this.proxy(message, this.finishSpan(message));
        }
        this.finishSpan(message);
        return message;
    }

    public void close() throws JMSException {
        this.messageConsumer.close();
    }

    private SpanContext finishSpan(Message message) {
        return TracingMessageUtils.buildAndFinishChildSpan(message, this.tracer);
    }

    private Message proxy(final Message message, final SpanContext spanContext) {
        if (message == null) {
            return null;
        }
        Class<?>[] interfaces = message.getClass().getInterfaces();
        Class[] allInterfaces = new Class[interfaces.length + 1];
        System.arraycopy(interfaces, 0, allInterfaces, 0, interfaces.length);
        allInterfaces[interfaces.length] = SpanContextContainer.class;
        return (Message)Proxy.newProxyInstance(message.getClass().getClassLoader(), allInterfaces, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("getSpanContext")) {
                    return spanContext;
                }
                return method.invoke((Object)message, args);
            }
        });
    }
}

