/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.kafka.spring;

import io.opentracing.Tracer;
import io.opentracing.contrib.kafka.ClientSpanNameProvider;
import io.opentracing.contrib.kafka.SpanDecorator;
import io.opentracing.contrib.kafka.TracingKafkaProducerBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiFunction;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.kafka.core.ProducerFactory;

public class TracingProducerFactory<K, V>
implements ProducerFactory<K, V>,
DisposableBean {
    private final ProducerFactory<K, V> producerFactory;
    private final Tracer tracer;
    private final Collection<SpanDecorator> spanDecorators;
    private final BiFunction<String, ProducerRecord, String> producerSpanNameProvider;

    public TracingProducerFactory(ProducerFactory<K, V> producerFactory, Tracer tracer) {
        this(producerFactory, tracer, null, null);
    }

    public TracingProducerFactory(ProducerFactory<K, V> producerFactory, Tracer tracer, Collection<SpanDecorator> spanDecorators) {
        this(producerFactory, tracer, spanDecorators, null);
    }

    public TracingProducerFactory(ProducerFactory<K, V> producerFactory, Tracer tracer, BiFunction<String, ProducerRecord, String> producerSpanNameProvider) {
        this(producerFactory, tracer, null, producerSpanNameProvider);
    }

    public TracingProducerFactory(ProducerFactory<K, V> producerFactory, Tracer tracer, Collection<SpanDecorator> spanDecorators, BiFunction<String, ProducerRecord, String> producerSpanNameProvider) {
        this.producerFactory = producerFactory;
        this.tracer = tracer;
        this.spanDecorators = spanDecorators == null ? Collections.singletonList(SpanDecorator.STANDARD_TAGS) : spanDecorators;
        this.producerSpanNameProvider = producerSpanNameProvider == null ? ClientSpanNameProvider.PRODUCER_OPERATION_NAME : producerSpanNameProvider;
    }

    public Producer<K, V> createProducer() {
        return new TracingKafkaProducerBuilder(this.producerFactory.createProducer(), this.tracer).withDecorators(this.spanDecorators).withSpanNameProvider(this.producerSpanNameProvider).build();
    }

    public Producer<K, V> createProducer(String txIdPrefix) {
        return new TracingKafkaProducerBuilder(this.producerFactory.createProducer(txIdPrefix), this.tracer).withDecorators(this.spanDecorators).withSpanNameProvider(this.producerSpanNameProvider).build();
    }

    public boolean transactionCapable() {
        return this.producerFactory.transactionCapable();
    }

    public void closeProducerFor(String transactionIdSuffix) {
        this.producerFactory.closeProducerFor(transactionIdSuffix);
    }

    public boolean isProducerPerConsumerPartition() {
        return this.producerFactory.isProducerPerConsumerPartition();
    }

    public void closeThreadBoundProducer() {
        this.producerFactory.closeThreadBoundProducer();
    }

    public void destroy() throws Exception {
        if (this.producerFactory instanceof DisposableBean) {
            ((DisposableBean)this.producerFactory).destroy();
        }
    }
}

