/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.mongo.common;

import com.mongodb.event.CommandFailedEvent;
import com.mongodb.event.CommandStartedEvent;
import com.mongodb.event.CommandSucceededEvent;
import io.opentracing.Span;
import io.opentracing.contrib.mongo.common.SpanDecorator;
import io.opentracing.tag.Tags;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

final class DefaultSpanDecorator
implements SpanDecorator {
    DefaultSpanDecorator() {
    }

    @Override
    public void commandStarted(CommandStartedEvent event, Span span) {
        Tags.COMPONENT.set(span, "java-mongo");
        Tags.DB_STATEMENT.set(span, event.getCommand().toString());
        Tags.DB_INSTANCE.set(span, event.getDatabaseName());
        Tags.PEER_HOSTNAME.set(span, event.getConnectionDescription().getServerAddress().getHost());
        InetAddress inetAddress = event.getConnectionDescription().getServerAddress().getSocketAddress().getAddress();
        if (inetAddress instanceof Inet4Address) {
            byte[] address = inetAddress.getAddress();
            Tags.PEER_HOST_IPV4.set(span, Integer.valueOf(ByteBuffer.wrap(address).getInt()));
        } else {
            Tags.PEER_HOST_IPV6.set(span, inetAddress.getHostAddress());
        }
        Tags.PEER_PORT.set(span, Integer.valueOf(event.getConnectionDescription().getServerAddress().getPort()));
        Tags.DB_TYPE.set(span, "mongo");
    }

    @Override
    public void commandSucceeded(CommandSucceededEvent event, Span span) {
    }

    @Override
    public void commandFailed(CommandFailedEvent event, Span span) {
        Tags.ERROR.set(span, Boolean.TRUE);
        span.log(DefaultSpanDecorator.errorLogs(event.getThrowable()));
    }

    private static Map<String, Object> errorLogs(Throwable throwable) {
        HashMap<String, Object> errorLogs = new HashMap<String, Object>(4);
        errorLogs.put("event", Tags.ERROR.getKey());
        errorLogs.put("error.kind", throwable.getClass().getName());
        errorLogs.put("error.object", throwable);
        errorLogs.put("message", throwable.getMessage());
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        errorLogs.put("stack", sw.toString());
        return errorLogs;
    }
}

