/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.zuul;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapInjectAdapter;
import io.opentracing.tag.Tags;

class TracePreZuulFilter
extends ZuulFilter {
    static final String COMPONENT_NAME = "zuul";
    static final String CONTEXT_SPAN_KEY = TracePreZuulFilter.class.getName();
    private final Tracer tracer;

    TracePreZuulFilter(Tracer tracer) {
        this.tracer = tracer;
    }

    public String filterType() {
        return "pre";
    }

    public int filterOrder() {
        return 0;
    }

    public boolean shouldFilter() {
        return true;
    }

    public Object run() {
        RequestContext ctx = RequestContext.getCurrentContext();
        Span span = this.tracer.buildSpan(ctx.getRequest().getMethod()).withTag(Tags.COMPONENT.getKey(), COMPONENT_NAME).start();
        this.tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new TextMapInjectAdapter(ctx.getZuulRequestHeaders()));
        ctx.set(CONTEXT_SPAN_KEY, (Object)span);
        return null;
    }
}

