/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.rabbitmq;

import io.opentracing.contrib.spring.rabbitmq.RabbitMqReceiveTracingInterceptor;
import java.lang.reflect.Field;
import org.aopalliance.aop.Advice;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ReflectionUtils;

class RabbitMqBeanPostProcessor
implements BeanPostProcessor {
    private final RabbitMqReceiveTracingInterceptor rabbitMqReceiveTracingInterceptor;

    RabbitMqBeanPostProcessor(RabbitMqReceiveTracingInterceptor rabbitMqReceiveTracingInterceptor) {
        this.rabbitMqReceiveTracingInterceptor = rabbitMqReceiveTracingInterceptor;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof SimpleRabbitListenerContainerFactory) {
            SimpleRabbitListenerContainerFactory factory = (SimpleRabbitListenerContainerFactory)bean;
            this.registerTracingInterceptor(factory);
        } else if (bean instanceof SimpleMessageListenerContainer) {
            SimpleMessageListenerContainer container = (SimpleMessageListenerContainer)bean;
            this.registerTracingInterceptor(container);
        }
        return bean;
    }

    private void registerTracingInterceptor(SimpleRabbitListenerContainerFactory factory) {
        Advice[] chain = factory.getAdviceChain();
        Advice[] adviceChainWithTracing = this.getAdviceChainOrAddInterceptorToChain(chain);
        factory.setAdviceChain(adviceChainWithTracing);
    }

    private void registerTracingInterceptor(SimpleMessageListenerContainer container) {
        Field adviceChainField = ReflectionUtils.findField(SimpleMessageListenerContainer.class, (String)"adviceChain");
        ReflectionUtils.makeAccessible((Field)adviceChainField);
        Advice[] chain = (Advice[])ReflectionUtils.getField((Field)adviceChainField, (Object)container);
        Advice[] adviceChainWithTracing = this.getAdviceChainOrAddInterceptorToChain(chain);
        container.setAdviceChain(adviceChainWithTracing);
    }

    private Advice[] getAdviceChainOrAddInterceptorToChain(Advice ... existingAdviceChain) {
        if (existingAdviceChain == null) {
            return new Advice[]{this.rabbitMqReceiveTracingInterceptor};
        }
        for (Advice advice : existingAdviceChain) {
            if (!(advice instanceof RabbitMqReceiveTracingInterceptor)) continue;
            return existingAdviceChain;
        }
        Advice[] newChain = new Advice[existingAdviceChain.length + 1];
        System.arraycopy(existingAdviceChain, 0, newChain, 0, existingAdviceChain.length);
        newChain[existingAdviceChain.length] = this.rabbitMqReceiveTracingInterceptor;
        return newChain;
    }
}

