/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.maven;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="generate-service-descriptor", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ServiceDescriptorGenerator
extends AbstractMojo {
    private static final String LS = System.getProperty("line.separator");
    @Parameter(defaultValue="io.prestosql.spi.Plugin")
    private String pluginClassName;
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/services")
    private File servicesDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classesDirectory;
    @Parameter(defaultValue="${project}")
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        List<Class<?>> pluginClasses;
        File servicesFile = new File(this.servicesDirectory, this.pluginClassName);
        if (servicesFile.exists()) {
            return;
        }
        if (!servicesFile.getParentFile().exists()) {
            ServiceDescriptorGenerator.mkdirs(servicesFile.getParentFile());
        }
        try {
            URLClassLoader loader = this.createClassloaderFromCompileTimeDependencies();
            pluginClasses = this.findPluginImplementations(loader);
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("%n%nError scanning for classes implementing %s.", this.pluginClassName), e);
        }
        if (pluginClasses.isEmpty()) {
            throw new MojoExecutionException(String.format("%n%nYou must have at least one class that implements %s.", this.pluginClassName));
        }
        if (pluginClasses.size() > 1) {
            StringBuilder sb = new StringBuilder();
            for (Class<?> pluginClass : pluginClasses) {
                sb.append(pluginClass.getName()).append(LS);
            }
            throw new MojoExecutionException(String.format("%n%nYou have more than one class that implements %s:%n%n%s%nYou can only have one per plugin project.", this.pluginClassName, sb));
        }
        try {
            Class<?> pluginClass = pluginClasses.get(0);
            Files.write(servicesFile.toPath(), pluginClass.getName().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            this.getLog().info((CharSequence)String.format("Wrote %s to %s", pluginClass.getName(), servicesFile));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write service descriptor.", (Exception)e);
        }
    }

    private URLClassLoader createClassloaderFromCompileTimeDependencies() throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(this.classesDirectory.toURI().toURL());
        for (Artifact artifact : this.project.getArtifacts()) {
            if (artifact.getFile() == null) continue;
            urls.add(artifact.getFile().toURI().toURL());
        }
        return new URLClassLoader(urls.toArray(new URL[0]));
    }

    private List<Class<?>> findPluginImplementations(URLClassLoader searchRealm) throws IOException, MojoExecutionException {
        ArrayList implementations = new ArrayList();
        List classes = FileUtils.getFileNames((File)this.classesDirectory, (String)"**/*.class", null, (boolean)false);
        for (String classPath : classes) {
            String className = classPath.substring(0, classPath.length() - 6).replace(File.separatorChar, '.');
            try {
                Class<?> implementation = searchRealm.loadClass(this.pluginClassName);
                Class<?> clazz = searchRealm.loadClass(className);
                if (!implementation.isAssignableFrom(clazz)) continue;
                implementations.add(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new MojoExecutionException("Failed to load class.", (Exception)e);
            }
        }
        return implementations;
    }

    private static void mkdirs(File file) throws MojoExecutionException {
        file.mkdirs();
        if (!file.isDirectory()) {
            throw new MojoExecutionException(String.format("%n%nFailed to create directory: %s", file));
        }
    }
}

