/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.group.ChannelGroup;
import io.netty.util.AttributeKey;
import java.util.Objects;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.channel.BootstrapHandlers;
import reactor.netty.tcp.TcpServer;
import reactor.netty.tcp.TcpServerOperator;

final class TcpServerChannelGroup
extends TcpServerOperator
implements ConnectionObserver {
    static final AttributeKey<ChannelGroup> CHANNEL_GROUP = AttributeKey.newInstance((String)"channelGroup");
    final ChannelGroup channelGroup;

    TcpServerChannelGroup(TcpServer source, ChannelGroup channelGroup) {
        super(source);
        this.channelGroup = Objects.requireNonNull(channelGroup, "channelGroup");
    }

    @Override
    public ServerBootstrap configure() {
        ServerBootstrap b = this.source.configure();
        b.attr(CHANNEL_GROUP, (Object)this.channelGroup);
        ConnectionObserver observer = BootstrapHandlers.childConnectionObserver(b);
        BootstrapHandlers.childConnectionObserver(b, observer.then(this));
        return b;
    }

    @Override
    public void onStateChange(Connection connection, ConnectionObserver.State newState) {
        if (newState == ConnectionObserver.State.CONNECTED) {
            this.channelGroup.add((Object)connection.channel());
        }
    }
}

