/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.Input;
import io.protostuff.Output;
import io.protostuff.Pipe;
import io.protostuff.ProtostuffException;
import io.protostuff.Schema;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;

public abstract class CollectionSchema<V>
implements Schema<Collection<V>> {
    public static final String FIELD_NAME_VALUE = "v";
    static final Set<String> MESSAGE_FACTORIES_NAMES;
    public final MessageFactory messageFactory;
    public final Pipe.Schema<Collection<V>> pipeSchema = new Pipe.Schema<Collection<V>>(this){

        protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
            int number = input.readFieldNumber((Schema)this);
            while (true) {
                switch (number) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        CollectionSchema.this.transferValue(pipe, input, output, 1, true);
                        break;
                    }
                    default: {
                        throw new ProtostuffException("The collection was incorrectly serialized.");
                    }
                }
                number = input.readFieldNumber((Schema)this);
            }
        }
    };

    public CollectionSchema() {
        this(MessageFactories.ArrayList);
    }

    public CollectionSchema(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    protected abstract void addValueFrom(Input var1, Collection<V> var2) throws IOException;

    protected abstract void writeValueTo(Output var1, int var2, V var3, boolean var4) throws IOException;

    protected abstract void transferValue(Pipe var1, Input var2, Output var3, int var4, boolean var5) throws IOException;

    public final String getFieldName(int number) {
        return number == 1 ? FIELD_NAME_VALUE : null;
    }

    public final int getFieldNumber(String name) {
        return name.length() == 1 && name.charAt(0) == 'v' ? 1 : 0;
    }

    public final boolean isInitialized(Collection<V> map) {
        return true;
    }

    public final String messageFullName() {
        return Collection.class.getName();
    }

    public final String messageName() {
        return Collection.class.getSimpleName();
    }

    public final Class<? super Collection<V>> typeClass() {
        return Collection.class;
    }

    public final Collection<V> newMessage() {
        return this.messageFactory.newMessage();
    }

    public void mergeFrom(Input input, Collection<V> message) throws IOException {
        int number = input.readFieldNumber((Schema)this);
        while (true) {
            switch (number) {
                case 0: {
                    return;
                }
                case 1: {
                    this.addValueFrom(input, message);
                    break;
                }
                default: {
                    throw new ProtostuffException("The collection was incorrectly serialized.");
                }
            }
            number = input.readFieldNumber((Schema)this);
        }
    }

    public void writeTo(Output output, Collection<V> message) throws IOException {
        for (V value : message) {
            if (value == null) continue;
            this.writeValueTo(output, 1, value, true);
        }
    }

    static {
        MessageFactories[] messageFactories = MessageFactories.values();
        MESSAGE_FACTORIES_NAMES = new HashSet<String>(messageFactories.length);
        for (MessageFactories messageFactory : messageFactories) {
            MESSAGE_FACTORIES_NAMES.add(messageFactory.name());
        }
    }

    public static enum MessageFactories implements MessageFactory
    {
        Collection((Class)ArrayList.class){

            @Override
            public <V> Collection<V> newMessage() {
                return new ArrayList();
            }
        }
        ,
        List((Class)ArrayList.class){

            @Override
            public <V> Collection<V> newMessage() {
                return new ArrayList();
            }
        }
        ,
        ArrayList((Class)ArrayList.class){

            @Override
            public <V> Collection<V> newMessage() {
                return new ArrayList();
            }
        }
        ,
        LinkedList((Class)LinkedList.class){

            @Override
            public <V> Collection<V> newMessage() {
                return new LinkedList();
            }
        }
        ,
        CopyOnWriteArrayList((Class)CopyOnWriteArrayList.class){

            @Override
            public <V> Collection<V> newMessage() {
                return new CopyOnWriteArrayList();
            }
        }
        ,
        Stack((Class)Stack.class){

            @Override
            public <V> Collection<V> newMessage() {
                return new Stack();
            }
        }
        ,
        Vector((Class)Vector.class){

            @Override
            public <V> Collection<V> newMessage() {
                return new Vector();
            }
        }
        ,
        Set((Class)HashSet.class){

            @Override
            public <V> Collection<V> newMessage() {
                return new HashSet();
            }
        }
        ,
        HashSet((Class)HashSet.class){

            @Override
            public <V> Collection<V> newMessage() {
                return new HashSet();
            }
        }
        ,
        LinkedHashSet((Class)LinkedHashSet.class){

            @Override
            public <V> Collection<V> newMessage() {
                return new LinkedHashSet();
            }
        }
        ,
        SortedSet((Class)TreeSet.class){

            @Override
            public <V> Collection<V> newMessage() {
                return new TreeSet();
            }
        }
        ,
        NavigableSet((Class)TreeSet.class){

            @Override
            public <V> Collection<V> newMessage() {
                return new TreeSet();
            }
        }
        ,
        TreeSet((Class)TreeSet.class){

            @Override
            public <V> Collection<V> newMessage() {
                return new TreeSet();
            }
        }
        ,
        ConcurrentSkipListSet((Class)ConcurrentSkipListSet.class){

            @Override
            public <V> Collection<V> newMessage() {
                return new ConcurrentSkipListSet();
            }
        }
        ,
        CopyOnWriteArraySet((Class)CopyOnWriteArraySet.class){

            @Override
            public <V> Collection<V> newMessage() {
                return new CopyOnWriteArraySet();
            }
        }
        ,
        Queue((Class)LinkedList.class){

            @Override
            public <V> Collection<V> newMessage() {
                return new LinkedList();
            }
        }
        ,
        BlockingQueue((Class)LinkedBlockingQueue.class){

            @Override
            public <V> Collection<V> newMessage() {
                return new LinkedBlockingQueue();
            }
        }
        ,
        LinkedBlockingQueue((Class)LinkedBlockingQueue.class){

            @Override
            public <V> Collection<V> newMessage() {
                return new LinkedBlockingQueue();
            }
        }
        ,
        Deque((Class)LinkedList.class){

            @Override
            public <V> Collection<V> newMessage() {
                return new LinkedList();
            }
        }
        ,
        BlockingDeque((Class)LinkedBlockingDeque.class){

            @Override
            public <V> Collection<V> newMessage() {
                return new LinkedBlockingDeque();
            }
        }
        ,
        LinkedBlockingDeque((Class)LinkedBlockingDeque.class){

            @Override
            public <V> Collection<V> newMessage() {
                return new LinkedBlockingDeque();
            }
        }
        ,
        ArrayBlockingQueue((Class)ArrayBlockingQueue.class){

            @Override
            public <V> Collection<V> newMessage() {
                return new ArrayBlockingQueue(10);
            }
        }
        ,
        ArrayDeque((Class)ArrayDeque.class){

            @Override
            public <V> Collection<V> newMessage() {
                return new ArrayDeque();
            }
        }
        ,
        ConcurrentLinkedQueue((Class)ConcurrentLinkedQueue.class){

            @Override
            public <V> Collection<V> newMessage() {
                return new ConcurrentLinkedQueue();
            }
        }
        ,
        ConcurrentLinkedDeque((Class)ConcurrentLinkedDeque.class){

            @Override
            public <V> Collection<V> newMessage() {
                return new ConcurrentLinkedDeque();
            }
        }
        ,
        PriorityBlockingQueue((Class)PriorityBlockingQueue.class){

            @Override
            public <V> Collection<V> newMessage() {
                return new PriorityBlockingQueue();
            }
        }
        ,
        PriorityQueue((Class)PriorityQueue.class){

            @Override
            public <V> Collection<V> newMessage() {
                return new PriorityQueue();
            }
        };

        public final Class<?> typeClass;

        private MessageFactories(Class<?> typeClass) {
            this.typeClass = typeClass;
        }

        @Override
        public Class<?> typeClass() {
            return this.typeClass;
        }

        public static MessageFactories getFactory(Class<? extends Collection<?>> clazz) {
            return clazz.getName().startsWith("java.util") ? MessageFactories.valueOf(clazz.getSimpleName()) : null;
        }

        public static MessageFactories getFactory(String name) {
            return MessageFactories.valueOf(name);
        }

        public static boolean accept(String name) {
            return MESSAGE_FACTORIES_NAMES.contains(name);
        }
    }

    public static interface MessageFactory {
        public <V> Collection<V> newMessage();

        public Class<?> typeClass();
    }
}

