/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.CodedInput;
import io.protostuff.FilterInput;
import io.protostuff.GraphInput;
import io.protostuff.Input;
import io.protostuff.Output;
import io.protostuff.Schema;
import io.protostuff.UninitializedMessageException;
import io.protostuff.WireFormat;
import java.io.IOException;
import java.util.ArrayList;

public final class GraphCodedInput
extends FilterInput<CodedInput>
implements GraphInput,
Schema<Object> {
    private final ArrayList<Object> references;
    private int lastRef = -1;
    private Schema<Object> lastSchema;
    private boolean messageReference = false;

    public GraphCodedInput(CodedInput input) {
        super((Input)input);
        assert (input.decodeNestedMessageAsGroup);
        this.references = new ArrayList();
    }

    public GraphCodedInput(CodedInput input, int initialCapacity) {
        super((Input)input);
        assert (input.decodeNestedMessageAsGroup);
        this.references = new ArrayList(initialCapacity);
    }

    public void updateLast(Object morphedMessage, Object lastMessage) {
        int last = this.references.size() - 1;
        if (lastMessage != null && lastMessage == this.references.get(last)) {
            this.references.set(last, morphedMessage);
        }
    }

    public boolean isCurrentMessageReference() {
        return this.messageReference;
    }

    public <T> int readFieldNumber(Schema<T> schema) throws IOException {
        int fieldNumber = ((CodedInput)this.input).readFieldNumber(schema);
        if (WireFormat.getTagWireType((int)((CodedInput)this.input).getLastTag()) == 6) {
            this.lastRef = ((CodedInput)this.input).readUInt32();
            this.messageReference = true;
        } else {
            this.messageReference = false;
        }
        return fieldNumber;
    }

    public <T> T mergeObject(T value, Schema<T> schema) throws IOException {
        if (this.messageReference) {
            return (T)this.references.get(this.lastRef);
        }
        this.lastSchema = schema;
        if (value == null) {
            value = schema.newMessage();
        }
        this.references.add(value);
        ((CodedInput)this.input).mergeObject(value, this);
        return value;
    }

    public String getFieldName(int number) {
        throw new UnsupportedOperationException();
    }

    public int getFieldNumber(String name) {
        throw new UnsupportedOperationException();
    }

    public boolean isInitialized(Object owner) {
        return true;
    }

    public String messageFullName() {
        throw new UnsupportedOperationException();
    }

    public String messageName() {
        throw new UnsupportedOperationException();
    }

    public Object newMessage() {
        throw new UnsupportedOperationException();
    }

    public Class<? super Object> typeClass() {
        throw new UnsupportedOperationException();
    }

    public void mergeFrom(Input input, Object message) throws IOException {
        Schema<Object> schema = this.lastSchema;
        schema.mergeFrom((Input)this, message);
        if (!schema.isInitialized(message)) {
            throw new UninitializedMessageException(message, schema);
        }
        this.lastSchema = schema;
    }

    public void writeTo(Output output, Object message) throws IOException {
        throw new UnsupportedOperationException();
    }
}

