/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.runtime;

import io.protostuff.ByteString;
import io.protostuff.GraphInput;
import io.protostuff.Input;
import io.protostuff.MapSchema;
import io.protostuff.Output;
import io.protostuff.Pipe;
import io.protostuff.ProtostuffException;
import io.protostuff.Schema;
import io.protostuff.runtime.Delegate;
import io.protostuff.runtime.EnumIO;
import io.protostuff.runtime.HasSchema;
import io.protostuff.runtime.IdStrategy;
import io.protostuff.runtime.PolymorphicSchema;
import io.protostuff.runtime.RuntimeEnv;
import io.protostuff.runtime.RuntimeFieldFactory;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;

public final class ArraySchemas {
    static final int ID_ARRAY_LEN = 1;
    static final int ID_ARRAY_DATA = 2;
    static final int ID_ARRAY_NULLCOUNT = 3;
    static final String STR_ARRAY_LEN = "a";
    static final String STR_ARRAY_DATA = "b";
    static final String STR_ARRAY_NULLCOUNT = "c";

    private ArraySchemas() {
    }

    static boolean isPrimitive(int arrayId) {
        return arrayId < 8;
    }

    static int toArrayId(int id, boolean primitive) {
        if (primitive) {
            return id - 1;
        }
        return id < 9 ? id - 1 | 8 : id + 7;
    }

    static int toInlineId(int arrayId) {
        if (arrayId < 8) {
            return arrayId + 1;
        }
        if (arrayId < 16) {
            return 1 + (arrayId & 7);
        }
        return arrayId - 7;
    }

    static Base getSchema(int id, boolean primitive) {
        switch (id) {
            case 1: {
                return primitive ? BoolArray.PRIMITIVE : BoolArray.ELEMENT_SCHEMA;
            }
            case 3: {
                return primitive ? CharArray.PRIMITIVE : CharArray.ELEMENT_SCHEMA;
            }
            case 4: {
                return primitive ? ShortArray.PRIMITIVE : ShortArray.ELEMENT_SCHEMA;
            }
            case 5: {
                return primitive ? Int32Array.PRIMITIVE : Int32Array.ELEMENT_SCHEMA;
            }
            case 6: {
                return primitive ? Int64Array.PRIMITIVE : Int64Array.ELEMENT_SCHEMA;
            }
            case 7: {
                return primitive ? FloatArray.PRIMITIVE : FloatArray.ELEMENT_SCHEMA;
            }
            case 8: {
                return primitive ? DoubleArray.PRIMITIVE : DoubleArray.ELEMENT_SCHEMA;
            }
            case 9: {
                return StringArray.ELEMENT_SCHEMA;
            }
            case 10: {
                return ByteStringArray.ELEMENT_SCHEMA;
            }
            case 11: {
                return ByteArrayArray.ELEMENT_SCHEMA;
            }
            case 12: {
                return BigDecimalArray.ELEMENT_SCHEMA;
            }
            case 13: {
                return BigIntegerArray.ELEMENT_SCHEMA;
            }
            case 14: {
                return DateArray.ELEMENT_SCHEMA;
            }
        }
        throw new RuntimeException("Should not happen.");
    }

    static Base getGenericElementSchema(int id) {
        switch (id) {
            case 1: {
                return BoolArray.ELEMENT_SCHEMA;
            }
            case 3: {
                return CharArray.ELEMENT_SCHEMA;
            }
            case 4: {
                return ShortArray.ELEMENT_SCHEMA;
            }
            case 5: {
                return Int32Array.ELEMENT_SCHEMA;
            }
            case 6: {
                return Int64Array.ELEMENT_SCHEMA;
            }
            case 7: {
                return FloatArray.ELEMENT_SCHEMA;
            }
            case 8: {
                return DoubleArray.ELEMENT_SCHEMA;
            }
            case 9: {
                return StringArray.ELEMENT_SCHEMA;
            }
            case 10: {
                return ByteStringArray.ELEMENT_SCHEMA;
            }
            case 11: {
                return ByteArrayArray.ELEMENT_SCHEMA;
            }
            case 12: {
                return BigDecimalArray.ELEMENT_SCHEMA;
            }
            case 13: {
                return BigIntegerArray.ELEMENT_SCHEMA;
            }
            case 14: {
                return DateArray.ELEMENT_SCHEMA;
            }
        }
        throw new RuntimeException("Should not happen.");
    }

    static Base newSchema(int id, Class<?> compontentType, Class<?> typeClass, IdStrategy strategy, PolymorphicSchema.Handler handler) {
        switch (id) {
            case 1: {
                return new BoolArray(handler, compontentType.isPrimitive());
            }
            case 3: {
                return new CharArray(handler, compontentType.isPrimitive());
            }
            case 4: {
                return new ShortArray(handler, compontentType.isPrimitive());
            }
            case 5: {
                return new Int32Array(handler, compontentType.isPrimitive());
            }
            case 6: {
                return new Int64Array(handler, compontentType.isPrimitive());
            }
            case 7: {
                return new FloatArray(handler, compontentType.isPrimitive());
            }
            case 8: {
                return new DoubleArray(handler, compontentType.isPrimitive());
            }
            case 9: {
                return new StringArray(handler);
            }
            case 10: {
                return new ByteStringArray(handler);
            }
            case 11: {
                return new ByteArrayArray(handler);
            }
            case 12: {
                return new BigDecimalArray(handler);
            }
            case 13: {
                return new BigIntegerArray(handler);
            }
            case 14: {
                return new DateArray(handler);
            }
        }
        throw new RuntimeException("Should not happen.");
    }

    static String name(int number) {
        switch (number) {
            case 1: {
                return STR_ARRAY_LEN;
            }
            case 2: {
                return STR_ARRAY_DATA;
            }
            case 3: {
                return STR_ARRAY_NULLCOUNT;
            }
        }
        return null;
    }

    static int number(String name) {
        if (name.length() != 1) {
            return 0;
        }
        switch (name.charAt(0)) {
            case 'a': {
                return 1;
            }
            case 'b': {
                return 2;
            }
            case 'c': {
                return 3;
            }
        }
        return 0;
    }

    static void transferObject(Pipe.Schema<Object> pipeSchema, Pipe pipe, Input input, Output output, IdStrategy strategy, Delegate<?> delegate) throws IOException {
        if (1 != input.readFieldNumber(pipeSchema.wrappedSchema)) {
            throw new ProtostuffException("Corrupt input.");
        }
        int len = input.readUInt32();
        output.writeUInt32(1, len, false);
        int i = 0;
        int nullCount = 0;
        block4: while (i < len) {
            switch (input.readFieldNumber(pipeSchema.wrappedSchema)) {
                case 2: {
                    ++i;
                    delegate.transfer(pipe, input, output, 2, true);
                    continue block4;
                }
                case 3: {
                    nullCount = input.readUInt32();
                    i += nullCount;
                    output.writeUInt32(3, nullCount, false);
                    continue block4;
                }
            }
            throw new ProtostuffException("Corrupt input.");
        }
        if (0 != input.readFieldNumber(pipeSchema.wrappedSchema)) {
            throw new ProtostuffException("Corrupt input.");
        }
    }

    public static class PojoArray
    extends Base {
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                if (1 != input.readFieldNumber(PojoArray.this.pipeSchema.wrappedSchema)) {
                    throw new ProtostuffException("Corrupt input.");
                }
                int len = input.readUInt32();
                output.writeUInt32(1, len, false);
                int i = 0;
                int nullCount = 0;
                block4: while (i < len) {
                    switch (input.readFieldNumber(PojoArray.this.pipeSchema.wrappedSchema)) {
                        case 2: {
                            ++i;
                            output.writeObject(2, (Object)pipe, PojoArray.this.hs.getPipeSchema(), true);
                            continue block4;
                        }
                        case 3: {
                            nullCount = input.readUInt32();
                            i += nullCount;
                            output.writeUInt32(3, nullCount, false);
                            continue block4;
                        }
                    }
                    throw new ProtostuffException("Corrupt input.");
                }
                if (0 != input.readFieldNumber(PojoArray.this.pipeSchema.wrappedSchema)) {
                    throw new ProtostuffException("Corrupt input.");
                }
            }
        };
        final HasSchema<Object> hs;

        public PojoArray(PolymorphicSchema.Handler handler, HasSchema<Object> hs) {
            super(handler);
            this.hs = hs;
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readUInt32();
            Object array = Array.newInstance(this.hs.getSchema().typeClass(), len);
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(array, owner);
            }
            int i = 0;
            block4: while (i < len) {
                switch (input.readFieldNumber((Schema)this)) {
                    case 2: {
                        Array.set(array, i++, input.mergeObject(null, this.hs.getSchema()));
                        continue block4;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block4;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        public void writeTo(Output output, Object array) throws IOException {
            int len = Array.getLength(array);
            output.writeUInt32(1, len, false);
            int nullCount = 0;
            for (int i = 0; i < len; ++i) {
                Object v = Array.get(array, i);
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    output.writeObject(2, v, this.hs.getSchema(), true);
                    continue;
                }
                if (!RuntimeEnv.ALLOW_NULL_ARRAY_ELEMENT) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }
    }

    public static class EnumArray
    extends Base {
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                if (1 != input.readFieldNumber(EnumArray.this.pipeSchema.wrappedSchema)) {
                    throw new ProtostuffException("Corrupt input.");
                }
                int len = input.readUInt32();
                output.writeUInt32(1, len, false);
                int i = 0;
                int nullCount = 0;
                block4: while (i < len) {
                    switch (input.readFieldNumber(EnumArray.this.pipeSchema.wrappedSchema)) {
                        case 2: {
                            ++i;
                            EnumIO.transfer(pipe, input, output, 2, true);
                            continue block4;
                        }
                        case 3: {
                            nullCount = input.readUInt32();
                            i += nullCount;
                            output.writeUInt32(3, nullCount, false);
                            continue block4;
                        }
                    }
                    throw new ProtostuffException("Corrupt input.");
                }
                if (0 != input.readFieldNumber(EnumArray.this.pipeSchema.wrappedSchema)) {
                    throw new ProtostuffException("Corrupt input.");
                }
            }
        };
        final EnumIO<?> eio;

        public EnumArray(PolymorphicSchema.Handler handler, EnumIO<?> eio) {
            super(handler);
            this.eio = eio;
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readUInt32();
            Object array = Array.newInstance(this.eio.enumClass, len);
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(array, owner);
            }
            int i = 0;
            block4: while (i < len) {
                switch (input.readFieldNumber((Schema)this)) {
                    case 2: {
                        Array.set(array, i++, this.eio.readFrom(input));
                        continue block4;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block4;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        public void writeTo(Output output, Object array) throws IOException {
            int len = Array.getLength(array);
            output.writeUInt32(1, len, false);
            int nullCount = 0;
            for (int i = 0; i < len; ++i) {
                Enum v = (Enum)Array.get(array, i);
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    this.eio.writeTo(output, 2, true, v);
                    continue;
                }
                if (!RuntimeEnv.ALLOW_NULL_ARRAY_ELEMENT) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }
    }

    public static class DelegateArray
    extends Base {
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                ArraySchemas.transferObject(this, pipe, input, output, DelegateArray.this.strategy, DelegateArray.this.delegate);
            }
        };
        final Delegate<Object> delegate;

        public DelegateArray(PolymorphicSchema.Handler handler, Delegate<Object> delegate) {
            super(handler);
            this.delegate = delegate;
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readUInt32();
            Object array = Array.newInstance(this.delegate.typeClass(), len);
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(array, owner);
            }
            int i = 0;
            block4: while (i < len) {
                switch (input.readFieldNumber((Schema)this)) {
                    case 2: {
                        Array.set(array, i++, this.delegate.readFrom(input));
                        continue block4;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block4;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        public void writeTo(Output output, Object array) throws IOException {
            int len = Array.getLength(array);
            output.writeUInt32(1, len, false);
            int nullCount = 0;
            for (int i = 0; i < len; ++i) {
                Object v = Array.get(array, i);
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    this.delegate.writeTo(output, 2, v, true);
                    continue;
                }
                if (!RuntimeEnv.ALLOW_NULL_ARRAY_ELEMENT) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }
    }

    public static class DateArray
    extends Base {
        public static final DateArray ELEMENT_SCHEMA = new DateArray(null){

            @Override
            protected void setValue(Object value, Object owner) {
                if (MapSchema.MapWrapper.class == owner.getClass()) {
                    ((MapSchema.MapWrapper)owner).setValue(value);
                } else {
                    ((Collection)owner).add(value);
                }
            }
        };
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                ArraySchemas.transferObject(this, pipe, input, output, DateArray.this.strategy, RuntimeFieldFactory.DATE);
            }
        };

        DateArray(PolymorphicSchema.Handler handler) {
            super(handler);
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readUInt32();
            Date[] array = new Date[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast((Object)array, owner);
            }
            int i = 0;
            block4: while (i < len) {
                switch (input.readFieldNumber((Schema)this)) {
                    case 2: {
                        array[i++] = new Date(input.readFixed64());
                        continue block4;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block4;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        public void writeTo(Output output, Object value) throws IOException {
            Date[] array = (Date[])value;
            output.writeUInt32(1, array.length, false);
            int nullCount = 0;
            for (Date v : array) {
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    output.writeFixed64(2, v.getTime(), true);
                    continue;
                }
                if (!RuntimeEnv.ALLOW_NULL_ARRAY_ELEMENT) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }
    }

    public static class BigIntegerArray
    extends Base {
        public static final BigIntegerArray ELEMENT_SCHEMA = new BigIntegerArray(null){

            @Override
            protected void setValue(Object value, Object owner) {
                if (MapSchema.MapWrapper.class == owner.getClass()) {
                    ((MapSchema.MapWrapper)owner).setValue(value);
                } else {
                    ((Collection)owner).add(value);
                }
            }
        };
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                ArraySchemas.transferObject(this, pipe, input, output, BigIntegerArray.this.strategy, RuntimeFieldFactory.BIGINTEGER);
            }
        };

        BigIntegerArray(PolymorphicSchema.Handler handler) {
            super(handler);
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readUInt32();
            BigInteger[] array = new BigInteger[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast((Object)array, owner);
            }
            int i = 0;
            block4: while (i < len) {
                switch (input.readFieldNumber((Schema)this)) {
                    case 2: {
                        array[i++] = new BigInteger(input.readByteArray());
                        continue block4;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block4;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        public void writeTo(Output output, Object value) throws IOException {
            BigInteger[] array = (BigInteger[])value;
            output.writeUInt32(1, array.length, false);
            int nullCount = 0;
            for (BigInteger v : array) {
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    output.writeByteArray(2, v.toByteArray(), true);
                    continue;
                }
                if (!RuntimeEnv.ALLOW_NULL_ARRAY_ELEMENT) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }
    }

    public static class BigDecimalArray
    extends Base {
        public static final BigDecimalArray ELEMENT_SCHEMA = new BigDecimalArray(null){

            @Override
            protected void setValue(Object value, Object owner) {
                if (MapSchema.MapWrapper.class == owner.getClass()) {
                    ((MapSchema.MapWrapper)owner).setValue(value);
                } else {
                    ((Collection)owner).add(value);
                }
            }
        };
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                ArraySchemas.transferObject(this, pipe, input, output, BigDecimalArray.this.strategy, RuntimeFieldFactory.BIGDECIMAL);
            }
        };

        BigDecimalArray(PolymorphicSchema.Handler handler) {
            super(handler);
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readUInt32();
            BigDecimal[] array = new BigDecimal[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast((Object)array, owner);
            }
            int i = 0;
            block4: while (i < len) {
                switch (input.readFieldNumber((Schema)this)) {
                    case 2: {
                        array[i++] = new BigDecimal(input.readString());
                        continue block4;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block4;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        public void writeTo(Output output, Object value) throws IOException {
            BigDecimal[] array = (BigDecimal[])value;
            output.writeUInt32(1, array.length, false);
            int nullCount = 0;
            for (BigDecimal v : array) {
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    output.writeString(2, v.toString(), true);
                    continue;
                }
                if (!RuntimeEnv.ALLOW_NULL_ARRAY_ELEMENT) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }
    }

    public static class ByteArrayArray
    extends Base {
        public static final ByteArrayArray ELEMENT_SCHEMA = new ByteArrayArray(null){

            @Override
            protected void setValue(Object value, Object owner) {
                if (MapSchema.MapWrapper.class == owner.getClass()) {
                    ((MapSchema.MapWrapper)owner).setValue(value);
                } else {
                    ((Collection)owner).add(value);
                }
            }
        };
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                ArraySchemas.transferObject(this, pipe, input, output, ByteArrayArray.this.strategy, RuntimeFieldFactory.BYTE_ARRAY);
            }
        };

        ByteArrayArray(PolymorphicSchema.Handler handler) {
            super(handler);
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readUInt32();
            byte[][] array = new byte[len][];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast((Object)array, owner);
            }
            int i = 0;
            block4: while (i < len) {
                switch (input.readFieldNumber((Schema)this)) {
                    case 2: {
                        array[i++] = input.readByteArray();
                        continue block4;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block4;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        public void writeTo(Output output, Object value) throws IOException {
            byte[][] array = (byte[][])value;
            output.writeUInt32(1, array.length, false);
            int nullCount = 0;
            for (byte[] v : array) {
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    output.writeByteArray(2, v, true);
                    continue;
                }
                if (!RuntimeEnv.ALLOW_NULL_ARRAY_ELEMENT) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }
    }

    public static class ByteStringArray
    extends Base {
        public static final ByteStringArray ELEMENT_SCHEMA = new ByteStringArray(null){

            @Override
            protected void setValue(Object value, Object owner) {
                if (MapSchema.MapWrapper.class == owner.getClass()) {
                    ((MapSchema.MapWrapper)owner).setValue(value);
                } else {
                    ((Collection)owner).add(value);
                }
            }
        };
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                ArraySchemas.transferObject(this, pipe, input, output, ByteStringArray.this.strategy, RuntimeFieldFactory.BYTES);
            }
        };

        ByteStringArray(PolymorphicSchema.Handler handler) {
            super(handler);
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readUInt32();
            ByteString[] array = new ByteString[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast((Object)array, owner);
            }
            int i = 0;
            block4: while (i < len) {
                switch (input.readFieldNumber((Schema)this)) {
                    case 2: {
                        array[i++] = input.readBytes();
                        continue block4;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block4;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        public void writeTo(Output output, Object value) throws IOException {
            ByteString[] array = (ByteString[])value;
            output.writeUInt32(1, array.length, false);
            int nullCount = 0;
            for (ByteString v : array) {
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    output.writeBytes(2, v, true);
                    continue;
                }
                if (!RuntimeEnv.ALLOW_NULL_ARRAY_ELEMENT) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }
    }

    public static class StringArray
    extends Base {
        public static final StringArray ELEMENT_SCHEMA = new StringArray(null){

            @Override
            protected void setValue(Object value, Object owner) {
                if (MapSchema.MapWrapper.class == owner.getClass()) {
                    ((MapSchema.MapWrapper)owner).setValue(value);
                } else {
                    ((Collection)owner).add(value);
                }
            }
        };
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                ArraySchemas.transferObject(this, pipe, input, output, StringArray.this.strategy, RuntimeFieldFactory.STRING);
            }
        };

        StringArray(PolymorphicSchema.Handler handler) {
            super(handler);
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readUInt32();
            String[] array = new String[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast((Object)array, owner);
            }
            int i = 0;
            block4: while (i < len) {
                switch (input.readFieldNumber((Schema)this)) {
                    case 2: {
                        array[i++] = input.readString();
                        continue block4;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block4;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        public void writeTo(Output output, Object value) throws IOException {
            String[] array = (String[])value;
            output.writeUInt32(1, array.length, false);
            int nullCount = 0;
            for (String v : array) {
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    output.writeString(2, v, true);
                    continue;
                }
                if (!RuntimeEnv.ALLOW_NULL_ARRAY_ELEMENT) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }
    }

    public static class DoubleArray
    extends Base {
        public static final DoubleArray PRIMITIVE = new DoubleArray(null, true);
        public static final DoubleArray ELEMENT_SCHEMA = new DoubleArray(null, false){

            @Override
            protected void setValue(Object value, Object owner) {
                if (MapSchema.MapWrapper.class == owner.getClass()) {
                    ((MapSchema.MapWrapper)owner).setValue(value);
                } else {
                    ((Collection)owner).add(value);
                }
            }
        };
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                ArraySchemas.transferObject(this, pipe, input, output, DoubleArray.this.strategy, RuntimeFieldFactory.DOUBLE);
            }
        };
        final boolean primitive;

        DoubleArray(PolymorphicSchema.Handler handler, boolean primitive) {
            super(handler);
            this.primitive = primitive;
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readUInt32();
            if (this.primitive) {
                double[] array = new double[len];
                if (input instanceof GraphInput) {
                    ((GraphInput)input).updateLast((Object)array, owner);
                }
                for (int i = 0; i < len; ++i) {
                    if (2 != input.readFieldNumber((Schema)this)) {
                        throw new ProtostuffException("Corrupt input.");
                    }
                    array[i] = input.readDouble();
                }
                if (0 != input.readFieldNumber((Schema)this)) {
                    throw new ProtostuffException("Corrupt input.");
                }
                return array;
            }
            Double[] array = new Double[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast((Object)array, owner);
            }
            int i = 0;
            block5: while (i < len) {
                switch (input.readFieldNumber((Schema)this)) {
                    case 2: {
                        array[i++] = input.readDouble();
                        continue block5;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block5;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        public void writeTo(Output output, Object value) throws IOException {
            if (this.primitive) {
                double[] array = (double[])value;
                output.writeUInt32(1, array.length, false);
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    output.writeDouble(2, array[i], true);
                }
                return;
            }
            Double[] array = (Double[])value;
            output.writeUInt32(1, array.length, false);
            int nullCount = 0;
            for (Double v : array) {
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    output.writeDouble(2, v.doubleValue(), true);
                    continue;
                }
                if (!RuntimeEnv.ALLOW_NULL_ARRAY_ELEMENT) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }
    }

    public static class FloatArray
    extends Base {
        public static final FloatArray PRIMITIVE = new FloatArray(null, true);
        public static final FloatArray ELEMENT_SCHEMA = new FloatArray(null, false){

            @Override
            protected void setValue(Object value, Object owner) {
                if (MapSchema.MapWrapper.class == owner.getClass()) {
                    ((MapSchema.MapWrapper)owner).setValue(value);
                } else {
                    ((Collection)owner).add(value);
                }
            }
        };
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                ArraySchemas.transferObject(this, pipe, input, output, FloatArray.this.strategy, RuntimeFieldFactory.FLOAT);
            }
        };
        final boolean primitive;

        FloatArray(PolymorphicSchema.Handler handler, boolean primitive) {
            super(handler);
            this.primitive = primitive;
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readUInt32();
            if (this.primitive) {
                float[] array = new float[len];
                if (input instanceof GraphInput) {
                    ((GraphInput)input).updateLast((Object)array, owner);
                }
                for (int i = 0; i < len; ++i) {
                    if (2 != input.readFieldNumber((Schema)this)) {
                        throw new ProtostuffException("Corrupt input.");
                    }
                    array[i] = input.readFloat();
                }
                if (0 != input.readFieldNumber((Schema)this)) {
                    throw new ProtostuffException("Corrupt input.");
                }
                return array;
            }
            Float[] array = new Float[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast((Object)array, owner);
            }
            int i = 0;
            block5: while (i < len) {
                switch (input.readFieldNumber((Schema)this)) {
                    case 2: {
                        array[i++] = Float.valueOf(input.readFloat());
                        continue block5;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block5;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        public void writeTo(Output output, Object value) throws IOException {
            if (this.primitive) {
                float[] array = (float[])value;
                output.writeUInt32(1, array.length, false);
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    output.writeFloat(2, array[i], true);
                }
                return;
            }
            Float[] array = (Float[])value;
            output.writeUInt32(1, array.length, false);
            int nullCount = 0;
            for (Float v : array) {
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    output.writeFloat(2, v.floatValue(), true);
                    continue;
                }
                if (!RuntimeEnv.ALLOW_NULL_ARRAY_ELEMENT) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }
    }

    public static class Int64Array
    extends Base {
        public static final Int64Array PRIMITIVE = new Int64Array(null, true);
        public static final Int64Array ELEMENT_SCHEMA = new Int64Array(null, false){

            @Override
            protected void setValue(Object value, Object owner) {
                if (MapSchema.MapWrapper.class == owner.getClass()) {
                    ((MapSchema.MapWrapper)owner).setValue(value);
                } else {
                    ((Collection)owner).add(value);
                }
            }
        };
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                ArraySchemas.transferObject(this, pipe, input, output, Int64Array.this.strategy, RuntimeFieldFactory.INT64);
            }
        };
        final boolean primitive;

        Int64Array(PolymorphicSchema.Handler handler, boolean primitive) {
            super(handler);
            this.primitive = primitive;
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readUInt32();
            if (this.primitive) {
                long[] array = new long[len];
                if (input instanceof GraphInput) {
                    ((GraphInput)input).updateLast((Object)array, owner);
                }
                for (int i = 0; i < len; ++i) {
                    if (2 != input.readFieldNumber((Schema)this)) {
                        throw new ProtostuffException("Corrupt input.");
                    }
                    array[i] = input.readInt64();
                }
                if (0 != input.readFieldNumber((Schema)this)) {
                    throw new ProtostuffException("Corrupt input.");
                }
                return array;
            }
            Long[] array = new Long[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast((Object)array, owner);
            }
            int i = 0;
            block5: while (i < len) {
                switch (input.readFieldNumber((Schema)this)) {
                    case 2: {
                        array[i++] = input.readInt64();
                        continue block5;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block5;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        public void writeTo(Output output, Object value) throws IOException {
            if (this.primitive) {
                long[] array = (long[])value;
                output.writeUInt32(1, array.length, false);
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    output.writeInt64(2, array[i], true);
                }
                return;
            }
            Long[] array = (Long[])value;
            output.writeUInt32(1, array.length, false);
            int nullCount = 0;
            for (Long v : array) {
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    output.writeInt64(2, v.longValue(), true);
                    continue;
                }
                if (!RuntimeEnv.ALLOW_NULL_ARRAY_ELEMENT) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }
    }

    public static class Int32Array
    extends Base {
        public static final Int32Array PRIMITIVE = new Int32Array(null, true);
        public static final Int32Array ELEMENT_SCHEMA = new Int32Array(null, false){

            @Override
            protected void setValue(Object value, Object owner) {
                if (MapSchema.MapWrapper.class == owner.getClass()) {
                    ((MapSchema.MapWrapper)owner).setValue(value);
                } else {
                    ((Collection)owner).add(value);
                }
            }
        };
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                ArraySchemas.transferObject(this, pipe, input, output, Int32Array.this.strategy, RuntimeFieldFactory.INT32);
            }
        };
        final boolean primitive;

        Int32Array(PolymorphicSchema.Handler handler, boolean primitive) {
            super(handler);
            this.primitive = primitive;
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readUInt32();
            if (this.primitive) {
                int[] array = new int[len];
                if (input instanceof GraphInput) {
                    ((GraphInput)input).updateLast((Object)array, owner);
                }
                for (int i = 0; i < len; ++i) {
                    if (2 != input.readFieldNumber((Schema)this)) {
                        throw new ProtostuffException("Corrupt input.");
                    }
                    array[i] = input.readInt32();
                }
                if (0 != input.readFieldNumber((Schema)this)) {
                    throw new ProtostuffException("Corrupt input.");
                }
                return array;
            }
            Integer[] array = new Integer[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast((Object)array, owner);
            }
            int i = 0;
            block5: while (i < len) {
                switch (input.readFieldNumber((Schema)this)) {
                    case 2: {
                        array[i++] = input.readInt32();
                        continue block5;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block5;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        public void writeTo(Output output, Object value) throws IOException {
            if (this.primitive) {
                int[] array = (int[])value;
                output.writeUInt32(1, array.length, false);
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    output.writeInt32(2, array[i], true);
                }
                return;
            }
            Integer[] array = (Integer[])value;
            output.writeUInt32(1, array.length, false);
            int nullCount = 0;
            for (Integer v : array) {
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    output.writeInt32(2, v.intValue(), true);
                    continue;
                }
                if (!RuntimeEnv.ALLOW_NULL_ARRAY_ELEMENT) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }
    }

    public static class ShortArray
    extends Base {
        public static final ShortArray PRIMITIVE = new ShortArray(null, true);
        public static final ShortArray ELEMENT_SCHEMA = new ShortArray(null, false){

            @Override
            protected void setValue(Object value, Object owner) {
                if (MapSchema.MapWrapper.class == owner.getClass()) {
                    ((MapSchema.MapWrapper)owner).setValue(value);
                } else {
                    ((Collection)owner).add(value);
                }
            }
        };
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                ArraySchemas.transferObject(this, pipe, input, output, ShortArray.this.strategy, RuntimeFieldFactory.SHORT);
            }
        };
        final boolean primitive;

        ShortArray(PolymorphicSchema.Handler handler, boolean primitive) {
            super(handler);
            this.primitive = primitive;
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readUInt32();
            if (this.primitive) {
                short[] array = new short[len];
                if (input instanceof GraphInput) {
                    ((GraphInput)input).updateLast((Object)array, owner);
                }
                for (int i = 0; i < len; ++i) {
                    if (2 != input.readFieldNumber((Schema)this)) {
                        throw new ProtostuffException("Corrupt input.");
                    }
                    array[i] = (short)input.readUInt32();
                }
                if (0 != input.readFieldNumber((Schema)this)) {
                    throw new ProtostuffException("Corrupt input.");
                }
                return array;
            }
            Short[] array = new Short[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast((Object)array, owner);
            }
            int i = 0;
            block5: while (i < len) {
                switch (input.readFieldNumber((Schema)this)) {
                    case 2: {
                        array[i++] = (short)input.readUInt32();
                        continue block5;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block5;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        public void writeTo(Output output, Object value) throws IOException {
            if (this.primitive) {
                short[] array = (short[])value;
                output.writeUInt32(1, array.length, false);
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    output.writeUInt32(2, (int)array[i], true);
                }
                return;
            }
            Short[] array = (Short[])value;
            output.writeUInt32(1, array.length, false);
            int nullCount = 0;
            for (Short v : array) {
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    output.writeUInt32(2, (int)v.shortValue(), true);
                    continue;
                }
                if (!RuntimeEnv.ALLOW_NULL_ARRAY_ELEMENT) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }
    }

    public static class CharArray
    extends Base {
        public static final CharArray PRIMITIVE = new CharArray(null, true);
        public static final CharArray ELEMENT_SCHEMA = new CharArray(null, false){

            @Override
            protected void setValue(Object value, Object owner) {
                if (MapSchema.MapWrapper.class == owner.getClass()) {
                    ((MapSchema.MapWrapper)owner).setValue(value);
                } else {
                    ((Collection)owner).add(value);
                }
            }
        };
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                ArraySchemas.transferObject(this, pipe, input, output, CharArray.this.strategy, RuntimeFieldFactory.CHAR);
            }
        };
        final boolean primitive;

        CharArray(PolymorphicSchema.Handler handler, boolean primitive) {
            super(handler);
            this.primitive = primitive;
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readUInt32();
            if (this.primitive) {
                char[] array = new char[len];
                if (input instanceof GraphInput) {
                    ((GraphInput)input).updateLast((Object)array, owner);
                }
                for (int i = 0; i < len; ++i) {
                    if (2 != input.readFieldNumber((Schema)this)) {
                        throw new ProtostuffException("Corrupt input.");
                    }
                    array[i] = (char)input.readUInt32();
                }
                if (0 != input.readFieldNumber((Schema)this)) {
                    throw new ProtostuffException("Corrupt input.");
                }
                return array;
            }
            Character[] array = new Character[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast((Object)array, owner);
            }
            int i = 0;
            block5: while (i < len) {
                switch (input.readFieldNumber((Schema)this)) {
                    case 2: {
                        array[i++] = Character.valueOf((char)input.readUInt32());
                        continue block5;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block5;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        public void writeTo(Output output, Object value) throws IOException {
            if (this.primitive) {
                char[] array = (char[])value;
                output.writeUInt32(1, array.length, false);
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    output.writeUInt32(2, (int)array[i], true);
                }
                return;
            }
            Character[] array = (Character[])value;
            output.writeUInt32(1, array.length, false);
            int nullCount = 0;
            for (Character v : array) {
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    output.writeUInt32(2, (int)v.charValue(), true);
                    continue;
                }
                if (!RuntimeEnv.ALLOW_NULL_ARRAY_ELEMENT) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }
    }

    public static class BoolArray
    extends Base {
        public static final BoolArray PRIMITIVE = new BoolArray(null, true);
        public static final BoolArray ELEMENT_SCHEMA = new BoolArray(null, false){

            @Override
            protected void setValue(Object value, Object owner) {
                if (MapSchema.MapWrapper.class == owner.getClass()) {
                    ((MapSchema.MapWrapper)owner).setValue(value);
                } else {
                    ((Collection)owner).add(value);
                }
            }
        };
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                ArraySchemas.transferObject(this, pipe, input, output, BoolArray.this.strategy, RuntimeFieldFactory.BOOL);
            }
        };
        final boolean primitive;

        BoolArray(PolymorphicSchema.Handler handler, boolean primitive) {
            super(handler);
            this.primitive = primitive;
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readUInt32();
            if (this.primitive) {
                boolean[] array = new boolean[len];
                if (input instanceof GraphInput) {
                    ((GraphInput)input).updateLast((Object)array, owner);
                }
                for (int i = 0; i < len; ++i) {
                    if (2 != input.readFieldNumber((Schema)this)) {
                        throw new ProtostuffException("Corrupt input.");
                    }
                    array[i] = input.readBool();
                }
                if (0 != input.readFieldNumber((Schema)this)) {
                    throw new ProtostuffException("Corrupt input.");
                }
                return array;
            }
            Boolean[] array = new Boolean[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast((Object)array, owner);
            }
            int i = 0;
            block5: while (i < len) {
                switch (input.readFieldNumber((Schema)this)) {
                    case 2: {
                        array[i++] = input.readBool();
                        continue block5;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block5;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber((Schema)this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        public void writeTo(Output output, Object value) throws IOException {
            if (this.primitive) {
                boolean[] array = (boolean[])value;
                output.writeUInt32(1, array.length, false);
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    output.writeBool(2, array[i], true);
                }
                return;
            }
            Boolean[] array = (Boolean[])value;
            output.writeUInt32(1, array.length, false);
            int nullCount = 0;
            for (Boolean v : array) {
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    output.writeBool(2, v.booleanValue(), true);
                    continue;
                }
                if (!RuntimeEnv.ALLOW_NULL_ARRAY_ELEMENT) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }
    }

    public static abstract class Base
    extends PolymorphicSchema {
        protected final PolymorphicSchema.Handler handler;

        public Base(PolymorphicSchema.Handler handler) {
            super(null);
            this.handler = handler;
        }

        public String getFieldName(int number) {
            return ArraySchemas.name(number);
        }

        public int getFieldNumber(String name) {
            return ArraySchemas.number(name);
        }

        public String messageFullName() {
            return Array.class.getName();
        }

        public String messageName() {
            return Array.class.getSimpleName();
        }

        @Override
        protected void setValue(Object value, Object owner) {
            this.handler.setValue(value, owner);
        }

        public void mergeFrom(Input input, Object owner) throws IOException {
            this.setValue(this.readFrom(input, owner), owner);
        }

        protected abstract Object readFrom(Input var1, Object var2) throws IOException;
    }
}

