/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func2;
import rx.internal.operators.SingleDelayedProducer;

public final class OperatorToObservableSortedList<T>
implements Observable.Operator<List<T>, T> {
    private final Comparator<? super T> sortFunction;
    private final int initialCapacity;
    private static Comparator DEFAULT_SORT_FUNCTION = new DefaultComparableFunction();

    public OperatorToObservableSortedList(int initialCapacity) {
        this.sortFunction = DEFAULT_SORT_FUNCTION;
        this.initialCapacity = initialCapacity;
    }

    public OperatorToObservableSortedList(final Func2<? super T, ? super T, Integer> sortFunction, int initialCapacity) {
        this.initialCapacity = initialCapacity;
        this.sortFunction = new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return (Integer)sortFunction.call(o1, o2);
            }
        };
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super List<T>> child) {
        final SingleDelayedProducer<? super List<T>> producer = new SingleDelayedProducer<List<T>>(child);
        Subscriber result = new Subscriber<T>(){
            List<T> list;
            boolean completed;
            {
                this.list = new ArrayList(OperatorToObservableSortedList.this.initialCapacity);
            }

            @Override
            public void onStart() {
                this.request(Long.MAX_VALUE);
            }

            @Override
            public void onCompleted() {
                if (!this.completed) {
                    this.completed = true;
                    List a = this.list;
                    this.list = null;
                    try {
                        Collections.sort(a, OperatorToObservableSortedList.this.sortFunction);
                    }
                    catch (Throwable e) {
                        this.onError(e);
                        return;
                    }
                    producer.set(a);
                }
            }

            @Override
            public void onError(Throwable e) {
                child.onError(e);
            }

            @Override
            public void onNext(T value) {
                if (!this.completed) {
                    this.list.add(value);
                }
            }
        };
        child.add(result);
        child.setProducer(producer);
        return result;
    }

    private static class DefaultComparableFunction
    implements Comparator<Object> {
        private DefaultComparableFunction() {
        }

        @Override
        public int compare(Object t1, Object t2) {
            Comparable c1 = (Comparable)t1;
            Comparable c2 = (Comparable)t2;
            return c1.compareTo(c2);
        }
    }
}

