/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.exec.mysql;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.loader.LoadLevel;
import io.seata.common.loader.Scope;
import io.seata.common.util.StringUtils;
import io.seata.rm.datasource.StatementProxy;
import io.seata.rm.datasource.exec.BaseInsertExecutor;
import io.seata.rm.datasource.exec.StatementCallback;
import io.seata.rm.datasource.sql.struct.ColumnMeta;
import io.seata.sqlparser.SQLRecognizer;
import io.seata.sqlparser.struct.Defaultable;
import io.seata.sqlparser.struct.Null;
import io.seata.sqlparser.struct.SqlMethodExpr;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="mysql", scope=Scope.PROTOTYPE)
public class MySQLInsertExecutor
extends BaseInsertExecutor
implements Defaultable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySQLInsertExecutor.class);
    public static final String ERR_SQL_STATE = "S1009";

    public MySQLInsertExecutor(StatementProxy statementProxy, StatementCallback statementCallback, SQLRecognizer sqlRecognizer) {
        super(statementProxy, statementCallback, sqlRecognizer);
    }

    @Override
    public Map<String, List<Object>> getPkValues() throws SQLException {
        Map<String, List<Object>> pkValuesMap = null;
        List<String> pkColumnNameList = this.getTableMeta().getPrimaryKeyOnlyName();
        Boolean isContainsPk = this.containsPK();
        if (this.getTableMeta().getPrimaryKeyOnlyName().size() == 1) {
            pkValuesMap = isContainsPk.booleanValue() ? this.getPkValuesByColumn() : (this.containsColumns() ? this.getPkValuesByAuto() : this.getPkValuesByColumn());
        } else {
            pkValuesMap = this.getPkValuesByColumn();
            for (String columnName : pkColumnNameList) {
                ColumnMeta pkColumnMeta;
                if (pkValuesMap.containsKey(columnName) || !Objects.nonNull(pkColumnMeta = this.getTableMeta().getColumnMeta(columnName)) || !pkColumnMeta.isAutoincrement()) continue;
                pkValuesMap.putAll(this.getPkValuesByAuto());
            }
        }
        return pkValuesMap;
    }

    public Map<String, List<Object>> getPkValuesByAuto() throws SQLException {
        ResultSet genKeys;
        HashMap<String, List<Object>> pkValuesMap = new HashMap<String, List<Object>>(8);
        Map<String, ColumnMeta> pkMetaMap = this.getTableMeta().getPrimaryKeyMap();
        String autoColumnName = null;
        for (Map.Entry<String, ColumnMeta> entry : pkMetaMap.entrySet()) {
            if (!entry.getValue().isAutoincrement()) continue;
            autoColumnName = entry.getKey();
            break;
        }
        if (StringUtils.isBlank(autoColumnName)) {
            throw new ShouldNeverHappenException();
        }
        try {
            genKeys = this.statementProxy.getGeneratedKeys();
        }
        catch (SQLException e) {
            if (ERR_SQL_STATE.equalsIgnoreCase(e.getSQLState())) {
                LOGGER.warn("Fail to get auto-generated keys, use 'SELECT LAST_INSERT_ID()' instead. Be cautious, statement could be polluted. Recommend you set the statement to return generated keys.");
                genKeys = this.statementProxy.getTargetStatement().executeQuery("SELECT LAST_INSERT_ID()");
            }
            throw e;
        }
        ArrayList<Object> pkValues = new ArrayList<Object>();
        while (genKeys.next()) {
            Object v = genKeys.getObject(1);
            pkValues.add(v);
        }
        try {
            genKeys.beforeFirst();
        }
        catch (SQLException e) {
            LOGGER.warn("Fail to reset ResultSet cursor. can not get primary key value");
        }
        pkValuesMap.put(autoColumnName, pkValues);
        return pkValuesMap;
    }

    @Override
    public Map<String, List<Object>> getPkValuesByColumn() throws SQLException {
        Map<String, List<Object>> pkValuesMap = this.parsePkValuesFromStatement();
        HashSet<String> keySet = new HashSet<String>(pkValuesMap.keySet());
        for (String pkKey : keySet) {
            List<Object> pkValues = pkValuesMap.get(pkKey);
            if (pkValues.size() == 1 && pkValues.get(0) instanceof SqlMethodExpr) {
                pkValuesMap.putAll(this.getPkValuesByAuto());
                continue;
            }
            if (pkValues.isEmpty() || !(pkValues.get(0) instanceof Null)) continue;
            pkValuesMap.putAll(this.getPkValuesByAuto());
        }
        return pkValuesMap;
    }

    @Override
    public List<Object> getPkValuesByDefault() throws SQLException {
        throw new NotSupportYetException();
    }
}

