/*
 * Decompiled with CFR 0.152.
 */
package io.seata.integration.tx.api.interceptor.parser;

import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.util.CollectionUtils;
import io.seata.integration.tx.api.interceptor.parser.TargetClassParser;
import java.util.ArrayList;
import java.util.List;

public class DefaultTargetClassParser
implements TargetClassParser {
    protected static List<TargetClassParser> allTargetClassParsers = new ArrayList<TargetClassParser>();

    public static DefaultTargetClassParser get() {
        return SingletonHolder.INSTANCE;
    }

    protected DefaultTargetClassParser() {
        this.initTargetClassParser();
    }

    protected void initTargetClassParser() {
        List<TargetClassParser> targetClassParsers = EnhancedServiceLoader.loadAll(TargetClassParser.class);
        if (CollectionUtils.isNotEmpty(targetClassParsers)) {
            allTargetClassParsers.addAll(targetClassParsers);
        }
    }

    @Override
    public Class<?> findTargetClass(Object target) throws Exception {
        for (TargetClassParser targetClassParser : allTargetClassParsers) {
            Class<?> result = targetClassParser.findTargetClass(target);
            if (result == null) continue;
            return result;
        }
        return target.getClass();
    }

    @Override
    public Class<?>[] findInterfaces(Object target) throws Exception {
        for (TargetClassParser targetClassParser : allTargetClassParsers) {
            Class<?>[] result = targetClassParser.findInterfaces(target);
            if (result == null) continue;
            return result;
        }
        return target.getClass().getInterfaces();
    }

    private static class SingletonHolder {
        private static final DefaultTargetClassParser INSTANCE = new DefaultTargetClassParser();

        private SingletonHolder() {
        }
    }
}

