/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.fence;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.common.exception.SkipCallbackWrapperException;
import io.seata.common.executor.Callback;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.integration.tx.api.fence.DefaultCommonFenceHandler;
import io.seata.integration.tx.api.fence.FenceHandler;
import io.seata.integration.tx.api.fence.exception.CommonFenceException;
import io.seata.integration.tx.api.fence.store.CommonFenceDO;
import io.seata.integration.tx.api.fence.store.CommonFenceStore;
import io.seata.integration.tx.api.fence.store.db.CommonFenceStoreDataBaseDAO;
import io.seata.integration.tx.api.remoting.TwoPhaseResult;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;

public class SpringFenceHandler
implements FenceHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringFenceHandler.class);
    private static final CommonFenceStore COMMON_FENCE_DAO = CommonFenceStoreDataBaseDAO.getInstance();
    private static DataSource dataSource;
    private static TransactionTemplate transactionTemplate;
    private static final int MAX_THREAD_CLEAN = 1;
    private static final int MAX_QUEUE_SIZE = 500;
    private static final int LIMIT_DELETE = 1000;
    private static final LinkedBlockingQueue<FenceLogIdentity> LOG_QUEUE;
    private static FenceLogCleanRunnable fenceLogCleanRunnable;
    private static ExecutorService logCleanExecutor;

    public static DataSource getDataSource() {
        return dataSource;
    }

    public static void setDataSource(DataSource dataSource) {
        SpringFenceHandler.dataSource = dataSource;
    }

    public static void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        SpringFenceHandler.transactionTemplate = transactionTemplate;
    }

    @Override
    public Object prepareFence(String xid, Long branchId, String actionName, Callback<Object> targetCallback) {
        return transactionTemplate.execute(status -> {
            try {
                Connection conn = DataSourceUtils.getConnection((DataSource)dataSource);
                boolean result = SpringFenceHandler.insertCommonFenceLog(conn, xid, branchId, actionName, 1);
                LOGGER.info("Common fence prepare result: {}. xid: {}, branchId: {}", new Object[]{result, xid, branchId});
                if (result) {
                    return targetCallback.execute();
                }
                throw new CommonFenceException(String.format("Insert common fence record error, prepare fence failed. xid= %s, branchId= %s", xid, branchId), FrameworkErrorCode.InsertRecordError);
            }
            catch (CommonFenceException e) {
                if (e.getErrcode() == FrameworkErrorCode.DuplicateKeyException) {
                    LOGGER.error("Branch transaction has already rollbacked before,prepare fence failed. xid= {},branchId = {}", (Object)xid, (Object)branchId);
                    SpringFenceHandler.addToLogCleanQueue(xid, branchId);
                }
                status.setRollbackOnly();
                throw new SkipCallbackWrapperException(e);
            }
            catch (Throwable t) {
                status.setRollbackOnly();
                throw new SkipCallbackWrapperException(t);
            }
        });
    }

    @Override
    public boolean commitFence(Method commitMethod, Object targetTCCBean, String xid, Long branchId, Object[] args) {
        return (Boolean)transactionTemplate.execute(status -> {
            try {
                Connection conn = DataSourceUtils.getConnection((DataSource)dataSource);
                CommonFenceDO commonFenceDO = COMMON_FENCE_DAO.queryCommonFenceDO(conn, xid, branchId);
                if (commonFenceDO == null) {
                    throw new CommonFenceException(String.format("Common fence record not exists, commit fence method failed. xid= %s, branchId= %s", xid, branchId), FrameworkErrorCode.RecordNotExists);
                }
                if (2 == commonFenceDO.getStatus()) {
                    LOGGER.info("Branch transaction has already committed before. idempotency rejected. xid: {}, branchId: {}, status: {}", new Object[]{xid, branchId, commonFenceDO.getStatus()});
                    return true;
                }
                if (3 == commonFenceDO.getStatus() || 4 == commonFenceDO.getStatus()) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Branch transaction status is unexpected. xid: {}, branchId: {}, status: {}", new Object[]{xid, branchId, commonFenceDO.getStatus()});
                    }
                    return false;
                }
                return SpringFenceHandler.updateStatusAndInvokeTargetMethod(conn, commitMethod, targetTCCBean, xid, branchId, 2, status, args);
            }
            catch (Throwable t) {
                status.setRollbackOnly();
                throw new SkipCallbackWrapperException(t);
            }
        });
    }

    @Override
    public boolean rollbackFence(Method rollbackMethod, Object targetTCCBean, String xid, Long branchId, Object[] args, String actionName) {
        return (Boolean)transactionTemplate.execute(status -> {
            try {
                Connection conn = DataSourceUtils.getConnection((DataSource)dataSource);
                CommonFenceDO commonFenceDO = COMMON_FENCE_DAO.queryCommonFenceDO(conn, xid, branchId);
                if (commonFenceDO == null) {
                    boolean result = SpringFenceHandler.insertCommonFenceLog(conn, xid, branchId, actionName, 4);
                    LOGGER.info("Insert common fence record result: {}. xid: {}, branchId: {}", new Object[]{result, xid, branchId});
                    if (!result) {
                        throw new CommonFenceException(String.format("Insert common fence record error, rollback fence method failed. xid= %s, branchId= %s", xid, branchId), FrameworkErrorCode.InsertRecordError);
                    }
                    return true;
                }
                if (3 == commonFenceDO.getStatus() || 4 == commonFenceDO.getStatus()) {
                    LOGGER.info("Branch transaction had already rollbacked before, idempotency rejected. xid: {}, branchId: {}, status: {}", new Object[]{xid, branchId, commonFenceDO.getStatus()});
                    return true;
                }
                if (2 == commonFenceDO.getStatus()) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Branch transaction status is unexpected. xid: {}, branchId: {}, status: {}", new Object[]{xid, branchId, commonFenceDO.getStatus()});
                    }
                    return false;
                }
                return SpringFenceHandler.updateStatusAndInvokeTargetMethod(conn, rollbackMethod, targetTCCBean, xid, branchId, 3, status, args);
            }
            catch (Throwable t) {
                status.setRollbackOnly();
                throw new SkipCallbackWrapperException(t);
            }
        });
    }

    private static boolean insertCommonFenceLog(Connection conn, String xid, Long branchId, String actionName, Integer status) {
        CommonFenceDO commonFenceDO = new CommonFenceDO();
        commonFenceDO.setXid(xid);
        commonFenceDO.setBranchId(branchId);
        commonFenceDO.setActionName(actionName);
        commonFenceDO.setStatus(status);
        return COMMON_FENCE_DAO.insertCommonFenceDO(conn, commonFenceDO);
    }

    private static boolean updateStatusAndInvokeTargetMethod(Connection conn, Method method, Object targetTCCBean, String xid, Long branchId, int status, TransactionStatus transactionStatus, Object[] args) throws Exception {
        Object ret;
        boolean result = COMMON_FENCE_DAO.updateCommonFenceDO(conn, xid, branchId, status, 1);
        if (result && null != (ret = method.invoke(targetTCCBean, args)) && !(result = ret instanceof TwoPhaseResult ? ((TwoPhaseResult)ret).isSuccess() : ((Boolean)ret).booleanValue())) {
            transactionStatus.setRollbackOnly();
        }
        return result;
    }

    public static boolean deleteFence(String xid, Long branchId) {
        return (Boolean)transactionTemplate.execute(status -> {
            boolean ret = false;
            try {
                Connection conn = DataSourceUtils.getConnection((DataSource)dataSource);
                ret = COMMON_FENCE_DAO.deleteCommonFenceDO(conn, xid, branchId);
            }
            catch (RuntimeException e) {
                status.setRollbackOnly();
                LOGGER.error("delete fence log failed, xid: {}, branchId: {}", new Object[]{xid, branchId, e});
            }
            return ret;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteFenceByDate(Date datetime) {
        DataSource dataSource = SpringFenceHandler.getDataSource();
        Connection connection = null;
        int total = 0;
        try {
            Set<String> xidSet;
            connection = DataSourceUtils.getConnection((DataSource)dataSource);
            do {
                if ((xidSet = COMMON_FENCE_DAO.queryEndStatusXidsByDate(connection, datetime, 1000)).isEmpty()) {
                    break;
                }
                total += COMMON_FENCE_DAO.deleteTCCFenceDO(connection, new ArrayList<String>(xidSet));
            } while (xidSet.size() >= 1000);
        }
        catch (RuntimeException e) {
            LOGGER.error("delete fence log failed ", (Throwable)e);
        }
        finally {
            if (connection != null) {
                DataSourceUtils.releaseConnection((Connection)connection, (DataSource)dataSource);
            }
        }
        return total;
    }

    private static void initLogCleanExecutor() {
        logCleanExecutor = new ThreadPoolExecutor(1, 1, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("fenceLogCleanThread", 1, true));
        fenceLogCleanRunnable = new FenceLogCleanRunnable();
        logCleanExecutor.submit(fenceLogCleanRunnable);
    }

    private static void addToLogCleanQueue(String xid, long branchId) {
        FenceLogIdentity logIdentity = new FenceLogIdentity();
        logIdentity.setXid(xid);
        logIdentity.setBranchId(branchId);
        try {
            LOG_QUEUE.add(logIdentity);
        }
        catch (Exception e) {
            LOGGER.warn("Insert tcc fence record into queue for async delete error,xid:{},branchId:{}", new Object[]{xid, branchId, e});
        }
    }

    static {
        LOG_QUEUE = new LinkedBlockingQueue(500);
        try {
            SpringFenceHandler.initLogCleanExecutor();
            DefaultCommonFenceHandler.get().setFenceHandler(new SpringFenceHandler());
        }
        catch (Exception e) {
            LOGGER.error("init fence log clean executor error", (Throwable)e);
        }
    }

    private static class FenceLogIdentity {
        private String xid;
        private Long branchId;

        private FenceLogIdentity() {
        }

        public String getXid() {
            return this.xid;
        }

        public Long getBranchId() {
            return this.branchId;
        }

        public void setXid(String xid) {
            this.xid = xid;
        }

        public void setBranchId(Long branchId) {
            this.branchId = branchId;
        }
    }

    private static class FenceLogCleanRunnable
    implements Runnable {
        private FenceLogCleanRunnable() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        FenceLogIdentity logIdentity;
                        boolean ret;
                        if (ret = SpringFenceHandler.deleteFence((logIdentity = (FenceLogIdentity)LOG_QUEUE.take()).getXid(), logIdentity.getBranchId())) {
                            continue;
                        }
                        LOGGER.error("delete fence log failed, xid: {}, branchId: {}", (Object)logIdentity.getXid(), (Object)logIdentity.getBranchId());
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.error("take fence log from queue for clean be interrupted", (Throwable)e);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("exception occur when clean fence log", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

