/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.store.db;

public class StateLogStoreSqls {
    private static final String STATE_MACHINE_INSTANCE_FIELDS = "id, machine_id, tenant_id, parent_id, business_key, gmt_started, gmt_end, status, compensation_status, is_running, gmt_updated, start_params, end_params, excep";
    private static final String STATE_MACHINE_INSTANCE_FIELDS_WITHOUT_PARAMS = "id, machine_id, tenant_id, parent_id, business_key, gmt_started, gmt_end, status, compensation_status, is_running, gmt_updated";
    private static final String RECORD_STATE_MACHINE_STARTED_SQL = "INSERT INTO ${TABLE_PREFIX}state_machine_inst\n(id, machine_id, tenant_id, parent_id, gmt_started, business_key, start_params, is_running, status, gmt_updated)\nVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String RECORD_STATE_MACHINE_FINISHED_SQL = "UPDATE ${TABLE_PREFIX}state_machine_inst SET gmt_end = ?, excep = ?, end_params = ?,status = ?, compensation_status = ?, is_running = ?, gmt_updated = ? WHERE id = ? and gmt_updated = ?";
    private static final String UPDATE_STATE_MACHINE_RUNNING_STATUS_SQL = "UPDATE ${TABLE_PREFIX}state_machine_inst SET\nis_running = ?, gmt_updated = ? where id = ? and gmt_updated = ?";
    private static final String GET_STATE_MACHINE_INSTANCE_BY_ID_SQL = "SELECT id, machine_id, tenant_id, parent_id, business_key, gmt_started, gmt_end, status, compensation_status, is_running, gmt_updated, start_params, end_params, excep FROM ${TABLE_PREFIX}state_machine_inst WHERE id = ?";
    private static final String GET_STATE_MACHINE_INSTANCE_BY_BUSINESS_KEY_SQL = "SELECT id, machine_id, tenant_id, parent_id, business_key, gmt_started, gmt_end, status, compensation_status, is_running, gmt_updated, start_params, end_params, excep FROM ${TABLE_PREFIX}state_machine_inst WHERE business_key = ? AND tenant_id = ?";
    private static final String QUERY_STATE_MACHINE_INSTANCES_BY_PARENT_ID_SQL = "SELECT id, machine_id, tenant_id, parent_id, business_key, gmt_started, gmt_end, status, compensation_status, is_running, gmt_updated FROM ${TABLE_PREFIX}state_machine_inst WHERE parent_id = ? ORDER BY gmt_started DESC";
    private static final String STATE_INSTANCE_FIELDS = "id, machine_inst_id, name, type, business_key, gmt_started, service_name, service_method, service_type, is_for_update, status, input_params, output_params, excep, gmt_end, state_id_compensated_for, state_id_retried_for";
    private static final String RECORD_STATE_STARTED_SQL = "INSERT INTO ${TABLE_PREFIX}state_inst (id, machine_inst_id, name, type, gmt_started, service_name, service_method, service_type, is_for_update, input_params, status, business_key, state_id_compensated_for, state_id_retried_for, gmt_updated)\nVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String RECORD_STATE_FINISHED_SQL = "UPDATE ${TABLE_PREFIX}state_inst SET gmt_end = ?, excep = ?, status = ?, output_params = ?, gmt_updated = ? WHERE id = ? AND machine_inst_id = ?";
    private static final String UPDATE_STATE_EXECUTION_STATUS_SQL = "UPDATE ${TABLE_PREFIX}state_inst SET status = ?, gmt_updated = ? WHERE machine_inst_id = ? AND id = ?";
    private static final String QUERY_STATE_INSTANCES_BY_MACHINE_INSTANCE_ID_SQL = "SELECT id, machine_inst_id, name, type, business_key, gmt_started, service_name, service_method, service_type, is_for_update, status, input_params, output_params, excep, gmt_end, state_id_compensated_for, state_id_retried_for FROM ${TABLE_PREFIX}state_inst WHERE machine_inst_id = ? ORDER BY gmt_started, ID ASC";
    private static final String GET_STATE_INSTANCE_BY_ID_AND_MACHINE_INSTANCE_ID_SQL = "SELECT id, machine_inst_id, name, type, business_key, gmt_started, service_name, service_method, service_type, is_for_update, status, input_params, output_params, excep, gmt_end, state_id_compensated_for, state_id_retried_for FROM ${TABLE_PREFIX}state_inst WHERE machine_inst_id = ? AND id = ?";
    private static final String TABLE_PREFIX_REGEX = "\\$\\{TABLE_PREFIX}";
    private String tablePrefix;
    private String recordStateMachineStartedSql;
    private String recordStateMachineFinishedSql;
    private String updateStateMachineRunningStatusSql;
    private String getStateMachineInstanceByIdSql;
    private String getStateMachineInstanceByBusinessKeySql;
    private String queryStateMachineInstancesByParentIdSql;
    private String recordStateStartedSql;
    private String recordStateFinishedSql;
    private String updateStateExecutionStatusSql;
    private String queryStateInstancesByMachineInstanceIdSql;
    private String getStateInstanceByIdAndMachineInstanceIdSql;

    public StateLogStoreSqls(String tablePrefix) {
        this.tablePrefix = tablePrefix;
        this.init();
    }

    private void init() {
        this.recordStateMachineStartedSql = RECORD_STATE_MACHINE_STARTED_SQL.replaceAll(TABLE_PREFIX_REGEX, this.tablePrefix);
        this.recordStateMachineFinishedSql = RECORD_STATE_MACHINE_FINISHED_SQL.replaceAll(TABLE_PREFIX_REGEX, this.tablePrefix);
        this.updateStateMachineRunningStatusSql = UPDATE_STATE_MACHINE_RUNNING_STATUS_SQL.replaceAll(TABLE_PREFIX_REGEX, this.tablePrefix);
        this.getStateMachineInstanceByIdSql = GET_STATE_MACHINE_INSTANCE_BY_ID_SQL.replaceAll(TABLE_PREFIX_REGEX, this.tablePrefix);
        this.getStateMachineInstanceByBusinessKeySql = GET_STATE_MACHINE_INSTANCE_BY_BUSINESS_KEY_SQL.replaceAll(TABLE_PREFIX_REGEX, this.tablePrefix);
        this.queryStateMachineInstancesByParentIdSql = QUERY_STATE_MACHINE_INSTANCES_BY_PARENT_ID_SQL.replaceAll(TABLE_PREFIX_REGEX, this.tablePrefix);
        this.recordStateStartedSql = RECORD_STATE_STARTED_SQL.replaceAll(TABLE_PREFIX_REGEX, this.tablePrefix);
        this.recordStateFinishedSql = RECORD_STATE_FINISHED_SQL.replaceAll(TABLE_PREFIX_REGEX, this.tablePrefix);
        this.updateStateExecutionStatusSql = UPDATE_STATE_EXECUTION_STATUS_SQL.replaceAll(TABLE_PREFIX_REGEX, this.tablePrefix);
        this.queryStateInstancesByMachineInstanceIdSql = QUERY_STATE_INSTANCES_BY_MACHINE_INSTANCE_ID_SQL.replaceAll(TABLE_PREFIX_REGEX, this.tablePrefix);
        this.getStateInstanceByIdAndMachineInstanceIdSql = GET_STATE_INSTANCE_BY_ID_AND_MACHINE_INSTANCE_ID_SQL.replaceAll(TABLE_PREFIX_REGEX, this.tablePrefix);
    }

    public String getRecordStateMachineStartedSql(String dbType) {
        return this.recordStateMachineStartedSql;
    }

    public String getRecordStateMachineFinishedSql(String dbType) {
        return this.recordStateMachineFinishedSql;
    }

    public String getUpdateStateMachineRunningStatusSql(String dbType) {
        return this.updateStateMachineRunningStatusSql;
    }

    public String getGetStateMachineInstanceByIdSql(String dbType) {
        return this.getStateMachineInstanceByIdSql;
    }

    public String getGetStateMachineInstanceByBusinessKeySql(String dbType) {
        return this.getStateMachineInstanceByBusinessKeySql;
    }

    public String getQueryStateMachineInstancesByParentIdSql(String dbType) {
        return this.queryStateMachineInstancesByParentIdSql;
    }

    public String getRecordStateStartedSql(String dbType) {
        return this.recordStateStartedSql;
    }

    public String getRecordStateFinishedSql(String dbType) {
        return this.recordStateFinishedSql;
    }

    public String getUpdateStateExecutionStatusSql(String dbType) {
        return this.updateStateExecutionStatusSql;
    }

    public String getQueryStateInstancesByMachineInstanceIdSql(String dbType) {
        return this.queryStateInstancesByMachineInstanceIdSql;
    }

    public String getGetStateInstanceByIdAndMachineInstanceIdSql(String dbType) {
        return this.getStateInstanceByIdAndMachineInstanceIdSql;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }
}

