/*
 * Decompiled with CFR 0.152.
 */
package io.seata.metrics.registry.compact;

import io.seata.common.loader.LoadLevel;
import io.seata.common.util.CollectionUtils;
import io.seata.metrics.Counter;
import io.seata.metrics.Gauge;
import io.seata.metrics.Id;
import io.seata.metrics.Measurement;
import io.seata.metrics.Meter;
import io.seata.metrics.Summary;
import io.seata.metrics.Timer;
import io.seata.metrics.registry.Registry;
import io.seata.metrics.registry.compact.CompactCounter;
import io.seata.metrics.registry.compact.CompactGauge;
import io.seata.metrics.registry.compact.CompactSummary;
import io.seata.metrics.registry.compact.CompactTimer;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

@LoadLevel(name="compact", order=1)
public class CompactRegistry
implements Registry {
    private static final Map<String, Meter> METERS = new ConcurrentHashMap<String, Meter>();

    public <T extends Number> Gauge<T> getGauge(Id id, Supplier<T> supplier) {
        return (Gauge)CollectionUtils.computeIfAbsent(METERS, (Object)id.getMeterKey(), key -> new CompactGauge(new Id(id.getName()).withTag(id.getTags()), supplier));
    }

    public Counter getCounter(Id id) {
        return (Counter)CollectionUtils.computeIfAbsent(METERS, (Object)id.getMeterKey(), key -> new CompactCounter(new Id(id.getName()).withTag(id.getTags())));
    }

    public Summary getSummary(Id id) {
        return (Summary)CollectionUtils.computeIfAbsent(METERS, (Object)id.getMeterKey(), key -> new CompactSummary(new Id(id.getName()).withTag(id.getTags())));
    }

    public Timer getTimer(Id id) {
        return (Timer)CollectionUtils.computeIfAbsent(METERS, (Object)id.getMeterKey(), key -> new CompactTimer(new Id(id.getName()).withTag(id.getTags())));
    }

    public Iterable<Measurement> measure() {
        ArrayList<Measurement> measurements = new ArrayList<Measurement>();
        if (METERS.isEmpty()) {
            return measurements;
        }
        METERS.values().iterator().forEachRemaining(meter -> meter.measure().forEach(measurements::add));
        return measurements;
    }

    public void clearUp() {
        METERS.clear();
    }
}

