/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.sql.dml.update;

import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Keyword;
import io.shardingsphere.core.parsing.parser.clause.facade.AbstractUpdateClauseParserFacade;
import io.shardingsphere.core.parsing.parser.sql.SQLParser;
import io.shardingsphere.core.parsing.parser.sql.dml.DMLStatement;
import io.shardingsphere.core.rule.ShardingRule;
import java.beans.ConstructorProperties;
import java.util.Collections;

public abstract class AbstractUpdateParser
implements SQLParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;
    private final AbstractUpdateClauseParserFacade updateClauseParserFacade;

    @Override
    public final DMLStatement parse() {
        this.lexerEngine.nextToken();
        this.lexerEngine.skipAll(this.getSkippedKeywordsBetweenUpdateAndTable());
        this.lexerEngine.unsupportedIfEqual(this.getUnsupportedKeywordsBetweenUpdateAndTable());
        DMLStatement result = new DMLStatement();
        this.updateClauseParserFacade.getTableReferencesClauseParser().parse(result, true);
        this.updateClauseParserFacade.getUpdateSetItemsClauseParser().parse(result);
        this.lexerEngine.skipUntil(DefaultKeyword.WHERE);
        this.updateClauseParserFacade.getWhereClauseParser().parse(this.shardingRule, result, Collections.emptyList());
        return result;
    }

    protected abstract Keyword[] getSkippedKeywordsBetweenUpdateAndTable();

    protected abstract Keyword[] getUnsupportedKeywordsBetweenUpdateAndTable();

    @ConstructorProperties(value={"shardingRule", "lexerEngine", "updateClauseParserFacade"})
    public AbstractUpdateParser(ShardingRule shardingRule, LexerEngine lexerEngine, AbstractUpdateClauseParserFacade updateClauseParserFacade) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
        this.updateClauseParserFacade = updateClauseParserFacade;
    }
}

