/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing.router.sharding;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.shardingsphere.api.algorithm.sharding.ListShardingValue;
import io.shardingsphere.api.algorithm.sharding.ShardingValue;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.constant.ShardingOperator;
import io.shardingsphere.core.metadata.ShardingMetaData;
import io.shardingsphere.core.optimizer.OptimizeEngineFactory;
import io.shardingsphere.core.optimizer.condition.ShardingCondition;
import io.shardingsphere.core.optimizer.condition.ShardingConditions;
import io.shardingsphere.core.parsing.SQLParsingEngine;
import io.shardingsphere.core.parsing.parser.context.condition.AndCondition;
import io.shardingsphere.core.parsing.parser.context.condition.Column;
import io.shardingsphere.core.parsing.parser.context.condition.Condition;
import io.shardingsphere.core.parsing.parser.context.condition.Conditions;
import io.shardingsphere.core.parsing.parser.context.condition.GeneratedKeyCondition;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dml.insert.InsertStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.rewrite.SQLBuilder;
import io.shardingsphere.core.rewrite.SQLRewriteEngine;
import io.shardingsphere.core.routing.RouteUnit;
import io.shardingsphere.core.routing.SQLRouteResult;
import io.shardingsphere.core.routing.router.sharding.GeneratedKey;
import io.shardingsphere.core.routing.router.sharding.RoutingEngineFactory;
import io.shardingsphere.core.routing.router.sharding.ShardingRouter;
import io.shardingsphere.core.routing.type.RoutingResult;
import io.shardingsphere.core.routing.type.TableUnit;
import io.shardingsphere.core.rule.BindingTableRule;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.rule.TableRule;
import io.shardingsphere.core.util.SQLLogger;
import io.shardingsphere.spi.parsing.ParsingHook;
import io.shardingsphere.spi.parsing.SPIParsingHook;
import java.beans.ConstructorProperties;
import java.util.LinkedList;
import java.util.List;

public final class ParsingSQLRouter
implements ShardingRouter {
    private final ShardingRule shardingRule;
    private final ShardingMetaData shardingMetaData;
    private final DatabaseType databaseType;
    private final boolean showSQL;
    private final List<Number> generatedKeys = new LinkedList<Number>();
    private final ParsingHook parsingHook = new SPIParsingHook();

    @Override
    public SQLStatement parse(String logicSQL, boolean useCache) {
        this.parsingHook.start(logicSQL);
        try {
            SQLStatement result = new SQLParsingEngine(this.databaseType, logicSQL, this.shardingRule, this.shardingMetaData.getTable()).parse(useCache);
            this.parsingHook.finishSuccess();
            return result;
        }
        catch (Exception ex) {
            this.parsingHook.finishFailure(ex);
            throw ex;
        }
    }

    @Override
    public SQLRouteResult route(String logicSQL, List<Object> parameters, SQLStatement sqlStatement) {
        Optional<GeneratedKey> generatedKey = sqlStatement instanceof InsertStatement ? this.getGenerateKey(this.shardingRule, (InsertStatement)sqlStatement, parameters) : Optional.absent();
        SQLRouteResult result = new SQLRouteResult(sqlStatement, (GeneratedKey)generatedKey.orNull());
        ShardingConditions shardingConditions = OptimizeEngineFactory.newInstance(this.shardingRule, sqlStatement, parameters, (GeneratedKey)generatedKey.orNull()).optimize();
        if (generatedKey.isPresent()) {
            this.setGeneratedKeys(result, (GeneratedKey)generatedKey.get());
        }
        if (sqlStatement instanceof SelectStatement && !sqlStatement.getTables().isEmpty() && !((SelectStatement)sqlStatement).getSubQueryConditions().isEmpty()) {
            this.mergeShardingValueForSubQuery(sqlStatement.getConditions(), shardingConditions);
        }
        RoutingResult routingResult = RoutingEngineFactory.newInstance(this.shardingRule, this.shardingMetaData.getDataSource(), sqlStatement, shardingConditions).route();
        SQLRewriteEngine rewriteEngine = new SQLRewriteEngine(this.shardingRule, logicSQL, this.databaseType, sqlStatement, shardingConditions, parameters);
        if (sqlStatement instanceof SelectStatement && null != ((SelectStatement)sqlStatement).getLimit()) {
            this.processLimit(parameters, (SelectStatement)sqlStatement);
        }
        SQLBuilder sqlBuilder = rewriteEngine.rewrite(routingResult.isSingleRouting());
        for (TableUnit each : routingResult.getTableUnits().getTableUnits()) {
            result.getRouteUnits().add(new RouteUnit(each.getDataSourceName(), rewriteEngine.generateSQL(each, sqlBuilder, this.shardingMetaData.getDataSource())));
        }
        if (this.showSQL) {
            SQLLogger.logSQL(logicSQL, sqlStatement, result.getRouteUnits());
        }
        return result;
    }

    private Optional<GeneratedKey> getGenerateKey(ShardingRule shardingRule, InsertStatement insertStatement, List<Object> parameters) {
        GeneratedKey result = null;
        if (-1 != insertStatement.getGenerateKeyColumnIndex()) {
            for (GeneratedKeyCondition generatedKeyCondition : insertStatement.getGeneratedKeyConditions()) {
                if (null == result) {
                    result = new GeneratedKey(generatedKeyCondition.getColumn());
                }
                if (-1 == generatedKeyCondition.getIndex()) {
                    result.getGeneratedKeys().add(generatedKeyCondition.getValue());
                    continue;
                }
                result.getGeneratedKeys().add((Number)parameters.get(generatedKeyCondition.getIndex()));
            }
            return Optional.fromNullable(result);
        }
        String logicTableName = insertStatement.getTables().getSingleTableName();
        Optional<TableRule> tableRule = shardingRule.findTableRuleByLogicTable(logicTableName);
        if (!tableRule.isPresent()) {
            return Optional.absent();
        }
        Optional<Column> generateKeyColumn = shardingRule.getGenerateKeyColumn(logicTableName);
        if (generateKeyColumn.isPresent()) {
            result = new GeneratedKey((Column)generateKeyColumn.get());
            for (int i = 0; i < insertStatement.getInsertValues().getInsertValues().size(); ++i) {
                result.getGeneratedKeys().add(shardingRule.generateKey(logicTableName));
            }
        }
        return Optional.fromNullable((Object)result);
    }

    private void setGeneratedKeys(SQLRouteResult sqlRouteResult, GeneratedKey generatedKey) {
        this.generatedKeys.addAll(generatedKey.getGeneratedKeys());
        sqlRouteResult.getGeneratedKey().getGeneratedKeys().clear();
        sqlRouteResult.getGeneratedKey().getGeneratedKeys().addAll(this.generatedKeys);
    }

    private void mergeShardingValueForSubQuery(Conditions conditions, ShardingConditions shardingConditions) {
        Preconditions.checkState((!shardingConditions.getShardingConditions().isEmpty() ? 1 : 0) != 0, (Object)"Must have sharding column with subquery.");
        Preconditions.checkState((boolean)this.isAllEqualShardingOperator(conditions), (Object)"Only support sharding by '=' with subquery.");
        ShardingCondition firstShardingCondition = shardingConditions.getShardingConditions().remove(0);
        Preconditions.checkState((boolean)this.isListShardingValue(firstShardingCondition), (Object)"Only support sharding by '=' with subquery.");
        for (ShardingCondition each : shardingConditions.getShardingConditions()) {
            Preconditions.checkState((boolean)this.isSameShardingCondition(firstShardingCondition, each), (Object)"Sharding value must same with subquery.");
        }
        shardingConditions.getShardingConditions().clear();
        shardingConditions.getShardingConditions().add(firstShardingCondition);
    }

    private boolean isAllEqualShardingOperator(Conditions conditions) {
        for (AndCondition each : conditions.getOrCondition().getAndConditions()) {
            if (this.isAllEqualShardingOperator(each)) continue;
            return false;
        }
        return true;
    }

    private boolean isAllEqualShardingOperator(AndCondition andCondition) {
        for (Condition each : andCondition.getConditions()) {
            if (ShardingOperator.EQUAL == each.getOperator()) continue;
            return false;
        }
        return true;
    }

    private boolean isListShardingValue(ShardingCondition shardingCondition) {
        for (ShardingValue each : shardingCondition.getShardingValues()) {
            if (each instanceof ListShardingValue) continue;
            return false;
        }
        return true;
    }

    private boolean isSameShardingCondition(ShardingCondition shardingCondition1, ShardingCondition shardingCondition2) {
        if (shardingCondition1.getShardingValues().size() != shardingCondition2.getShardingValues().size()) {
            return false;
        }
        for (int i = 0; i < shardingCondition1.getShardingValues().size(); ++i) {
            ShardingValue shardingValue1 = shardingCondition1.getShardingValues().get(i);
            ShardingValue shardingValue2 = shardingCondition2.getShardingValues().get(i);
            Preconditions.checkArgument((boolean)(shardingValue1 instanceof ListShardingValue), (Object)"Only support sharding by '=' with subquery.");
            Preconditions.checkArgument((boolean)(shardingValue2 instanceof ListShardingValue), (Object)"Only support sharding by '=' with subquery.");
            if (this.isSameShardingValue((ListShardingValue)shardingValue1, (ListShardingValue)shardingValue2)) continue;
            return false;
        }
        return true;
    }

    private boolean isSameShardingValue(ListShardingValue shardingValue1, ListShardingValue shardingValue2) {
        return this.isSameLogicTable(shardingValue1, shardingValue2) && shardingValue1.getColumnName().equals(shardingValue2.getColumnName()) && shardingValue1.getValues().equals(shardingValue2.getValues());
    }

    private boolean isSameLogicTable(ListShardingValue shardingValue1, ListShardingValue shardingValue2) {
        return shardingValue1.getLogicTableName().equals(shardingValue2.getLogicTableName()) || this.isBindingTable(shardingValue1, shardingValue2);
    }

    private boolean isBindingTable(ListShardingValue shardingValue1, ListShardingValue shardingValue2) {
        Optional<BindingTableRule> bindingRule = this.shardingRule.findBindingTableRule(shardingValue1.getLogicTableName());
        return bindingRule.isPresent() && ((BindingTableRule)bindingRule.get()).hasLogicTable(shardingValue2.getLogicTableName());
    }

    private void processLimit(List<Object> parameters, SelectStatement selectStatement) {
        boolean isNeedFetchAll = (!selectStatement.getGroupByItems().isEmpty() || !selectStatement.getAggregationSelectItems().isEmpty()) && !selectStatement.isSameGroupByAndOrderByItems();
        selectStatement.getLimit().processParameters(parameters, isNeedFetchAll, this.databaseType);
    }

    @ConstructorProperties(value={"shardingRule", "shardingMetaData", "databaseType", "showSQL"})
    public ParsingSQLRouter(ShardingRule shardingRule, ShardingMetaData shardingMetaData, DatabaseType databaseType, boolean showSQL) {
        this.shardingRule = shardingRule;
        this.shardingMetaData = shardingMetaData;
        this.databaseType = databaseType;
        this.showSQL = showSQL;
    }
}

