/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing.router.sharding;

import io.shardingsphere.core.metadata.datasource.ShardingDataSourceMetaData;
import io.shardingsphere.core.optimizer.condition.ShardingConditions;
import io.shardingsphere.core.parsing.antlr.sql.statement.dcl.DCLStatement;
import io.shardingsphere.core.parsing.antlr.sql.statement.ddl.DDLStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowDatabasesStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowTableStatusStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowTablesStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.UseStatement;
import io.shardingsphere.core.parsing.parser.dialect.postgresql.statement.ResetParamStatement;
import io.shardingsphere.core.parsing.parser.dialect.postgresql.statement.SetParamStatement;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dal.DALStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.routing.type.RoutingEngine;
import io.shardingsphere.core.routing.type.broadcast.DatabaseBroadcastRoutingEngine;
import io.shardingsphere.core.routing.type.broadcast.InstanceBroadcastRoutingEngine;
import io.shardingsphere.core.routing.type.broadcast.TableBroadcastRoutingEngine;
import io.shardingsphere.core.routing.type.complex.ComplexRoutingEngine;
import io.shardingsphere.core.routing.type.defaultdb.DefaultDatabaseRoutingEngine;
import io.shardingsphere.core.routing.type.ignore.IgnoreRoutingEngine;
import io.shardingsphere.core.routing.type.standard.StandardRoutingEngine;
import io.shardingsphere.core.routing.type.unicast.UnicastRoutingEngine;
import io.shardingsphere.core.rule.ShardingRule;
import java.util.Collection;

public final class RoutingEngineFactory {
    public static RoutingEngine newInstance(ShardingRule shardingRule, ShardingDataSourceMetaData shardingDataSourceMetaData, SQLStatement sqlStatement, ShardingConditions shardingConditions) {
        Collection<String> tableNames = sqlStatement.getTables().getTableNames();
        RoutingEngine result = sqlStatement instanceof UseStatement ? new IgnoreRoutingEngine() : (shardingRule.isAllBroadcastTables(tableNames) && !(sqlStatement instanceof SelectStatement) ? new DatabaseBroadcastRoutingEngine(shardingRule) : (sqlStatement instanceof DDLStatement || sqlStatement instanceof DCLStatement && ((DCLStatement)sqlStatement).isGrantForSingleTable() ? new TableBroadcastRoutingEngine(shardingRule, sqlStatement) : (sqlStatement instanceof ShowDatabasesStatement || (sqlStatement instanceof ShowTablesStatement || sqlStatement instanceof ShowTableStatusStatement) && tableNames.isEmpty() || sqlStatement instanceof SetParamStatement || sqlStatement instanceof ResetParamStatement ? new DatabaseBroadcastRoutingEngine(shardingRule) : (sqlStatement instanceof DCLStatement ? new InstanceBroadcastRoutingEngine(shardingRule, shardingDataSourceMetaData) : (shardingRule.isAllInDefaultDataSource(tableNames) ? new DefaultDatabaseRoutingEngine(shardingRule, tableNames) : (shardingConditions.isAlwaysFalse() ? new UnicastRoutingEngine(shardingRule, tableNames) : (sqlStatement instanceof DALStatement ? new UnicastRoutingEngine(shardingRule, tableNames) : (tableNames.isEmpty() && sqlStatement instanceof SelectStatement || shardingRule.isAllBroadcastTables(tableNames) && sqlStatement instanceof SelectStatement ? new UnicastRoutingEngine(shardingRule, tableNames) : (tableNames.isEmpty() ? new DatabaseBroadcastRoutingEngine(shardingRule) : (1 == tableNames.size() || shardingRule.isAllBindingTables(tableNames) ? new StandardRoutingEngine(shardingRule, tableNames.iterator().next(), shardingConditions) : new ComplexRoutingEngine(shardingRule, tableNames, shardingConditions)))))))))));
        return result;
    }

    private RoutingEngineFactory() {
    }
}

