/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.persistence;

import com.alibaba.nacos.config.server.configuration.ConditionOnExternalStorage;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.service.repository.PaginationHelper;
import com.alibaba.nacos.config.server.service.repository.extrnal.ExternalStoragePersistServiceImpl;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.plugin.auth.impl.persistence.AuthRowMapperManager;
import com.alibaba.nacos.plugin.auth.impl.persistence.User;
import com.alibaba.nacos.plugin.auth.impl.persistence.UserPersistService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Conditional(value={ConditionOnExternalStorage.class})
@Component
public class ExternalUserPersistServiceImpl
implements UserPersistService {
    @Autowired
    private ExternalStoragePersistServiceImpl persistService;
    private JdbcTemplate jt;

    @PostConstruct
    protected void init() {
        this.jt = this.persistService.getJdbcTemplate();
    }

    @Override
    public void createUser(String username, String password) {
        String sql = "INSERT INTO users (username, password, enabled) VALUES (?, ?, ?)";
        try {
            this.jt.update(sql, new Object[]{username, password, true});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void deleteUser(String username) {
        String sql = "DELETE FROM users WHERE username=?";
        try {
            this.jt.update(sql, new Object[]{username});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void updateUserPassword(String username, String password) {
        try {
            this.jt.update("UPDATE users SET password = ? WHERE username=?", new Object[]{password, username});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public User findUserByUsername(String username) {
        String sql = "SELECT username,password FROM users WHERE username=? ";
        try {
            return (User)this.jt.queryForObject(sql, new Object[]{username}, AuthRowMapperManager.USER_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (Exception e) {
            LogUtil.FATAL_LOG.error("[db-other-error]" + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Page<User> getUsers(int pageNo, int pageSize) {
        PaginationHelper helper = this.persistService.createPaginationHelper();
        String sqlCountRows = "SELECT count(*) FROM users WHERE ";
        String sqlFetchRows = "SELECT username,password FROM users WHERE ";
        String where = " 1=1 ";
        try {
            Page pageInfo = helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, new ArrayList().toArray(), pageNo, pageSize, AuthRowMapperManager.USER_ROW_MAPPER);
            if (pageInfo == null) {
                pageInfo = new Page();
                pageInfo.setTotalCount(0);
                pageInfo.setPageItems(new ArrayList());
            }
            return pageInfo;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<String> findUserLikeUsername(String username) {
        String sql = "SELECT username FROM users WHERE username LIKE '%' ? '%'";
        List users = this.jt.queryForList(sql, (Object[])new String[]{username}, String.class);
        return users;
    }
}

