/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationModelsProviderPlugin;
import springfox.documentation.spi.service.contexts.RequestMappingContext;
import springfox.documentation.swagger.annotations.Annotations;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component
@Order(value=-2147482648)
public class SwaggerOperationModelsProvider
implements OperationModelsProviderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(SwaggerOperationModelsProvider.class);
    private final TypeResolver typeResolver;

    @Autowired
    public SwaggerOperationModelsProvider(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public void apply(RequestMappingContext context) {
        this.collectFromApiOperation(context);
        this.collectApiResponses(context);
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }

    private void collectFromApiOperation(RequestMappingContext context) {
        ResolvedType returnType = context.getReturnType();
        returnType = context.alternateFor(returnType);
        Optional<ResolvedType> returnParameter = context.findAnnotation(ApiOperation.class).map(Annotations.resolvedTypeFromApiOperation(this.typeResolver, returnType));
        if (returnParameter.isPresent() && returnParameter.get() != returnType) {
            LOG.debug("Adding return parameter of type {}", (Object)ResolvedTypes.resolvedTypeSignature((ResolvedType)returnParameter.get()).orElse("<null>"));
            context.operationModelsBuilder().addReturn(returnParameter.get());
        }
    }

    private void collectApiResponses(RequestMappingContext context) {
        List allApiResponses = context.findAnnotations(ApiResponses.class);
        LOG.debug("Reading parameters models for handlerMethod |{}|", (Object)context.getName());
        HashSet<ResolvedType> seenTypes = new HashSet<ResolvedType>();
        for (ApiResponses apiResponses : allApiResponses) {
            List<ResolvedType> modelTypes = this.toResolvedTypes(context).apply(apiResponses);
            for (ResolvedType modelType : modelTypes) {
                if (seenTypes.contains(modelType)) continue;
                seenTypes.add(modelType);
                context.operationModelsBuilder().addReturn(modelType);
            }
        }
    }

    private Function<ApiResponses, List<ResolvedType>> toResolvedTypes(RequestMappingContext context) {
        return input -> {
            ArrayList<ResolvedType> resolvedTypes = new ArrayList<ResolvedType>();
            for (ApiResponse response : input.value()) {
                ResolvedType modelType = context.alternateFor(this.typeResolver.resolve((Type)response.response(), new Type[0]));
                LOG.debug("Adding input parameter of type {}", (Object)ResolvedTypes.resolvedTypeSignature((ResolvedType)modelType).orElse("<null>"));
                resolvedTypes.add(modelType);
            }
            return resolvedTypes;
        };
    }
}

