/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.transform.internal;

import io.sundr.adapter.api.AdapterContext;
import io.sundr.adapter.api.Adapters;
import io.sundr.adapter.apt.AptContext;
import io.sundr.adapter.apt.utils.Apt;
import io.sundr.codegen.annotations.AnnotationSelector;
import io.sundr.codegen.annotations.PackageSelector;
import io.sundr.codegen.annotations.ResourceSelector;
import io.sundr.codegen.processor.JavaGeneratingProcessor;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeDefBuilder;
import io.sundr.model.repo.DefinitionRepository;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import io.sundr.utils.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"io.sundr.transform.annotations.VelocityTransformation", "io.sundr.transform.annotations.VelocityTransformations"})
public class VelocityTransformationProcessor
extends JavaGeneratingProcessor {
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        Elements elements = this.processingEnv.getElementUtils();
        Types types = this.processingEnv.getTypeUtils();
        Filer filer = this.processingEnv.getFiler();
        AptContext aptContext = AptContext.create((Elements)elements, (Types)types, (DefinitionRepository)DefinitionRepository.getRepository());
        HashMap annotatedTypes = new HashMap();
        for (TypeElement typeElement : annotations) {
            for (Element element : env.getElementsAnnotatedWith(typeElement)) {
                VelocityTransformations transformations = element.getAnnotation(VelocityTransformations.class);
                VelocityTransformation transformation = element.getAnnotation(VelocityTransformation.class);
                ArrayList<VelocityTransformation> all = new ArrayList<VelocityTransformation>();
                if (transformation != null) {
                    all.add(transformation);
                }
                if (transformations != null) {
                    for (VelocityTransformation t : transformations.value()) {
                        all.add(t);
                    }
                }
                TypeDef def = new TypeDefBuilder(Adapters.adapt((Object)Apt.getClassElement((Element)element), (AdapterContext)aptContext)).build();
                Iterator iterator = all.iterator();
                while (iterator.hasNext()) {
                    VelocityTransformation t = (VelocityTransformation)iterator.next();
                    if (!annotatedTypes.containsKey(t)) {
                        annotatedTypes.put(t, new HashMap());
                    }
                    if (transformations == null) {
                        ((Map)annotatedTypes.get(t)).put(def.getFullyQualifiedName(), def);
                        continue;
                    }
                    if (transformations.annotations().length > 0) {
                        for (AnnotationSelector annotationSelector : transformations.annotations()) {
                            this.selectAnnotated(env, types, annotationSelector, (Map)annotatedTypes.get(t));
                        }
                        continue;
                    }
                    if (transformations.packages().length > 0) {
                        for (AnnotationSelector annotationSelector : transformations.packages()) {
                            this.selectPackages(elements, (PackageSelector)annotationSelector, (Map)annotatedTypes.get(t));
                        }
                        continue;
                    }
                    if (transformations.resources().length > 0) {
                        for (AnnotationSelector annotationSelector : transformations.resources()) {
                            this.selectFromResource(elements, filer, (ResourceSelector)annotationSelector, (Map)annotatedTypes.get(t));
                        }
                        continue;
                    }
                    ((Map)annotatedTypes.get(t)).put(def.getFullyQualifiedName(), def);
                }
            }
            for (Map.Entry entry : annotatedTypes.entrySet()) {
                VelocityTransformation transformation = (VelocityTransformation)entry.getKey();
                Map annotated = (Map)entry.getValue();
                try {
                    if (transformation.gather()) {
                        this.generateFromStringTemplate(annotated, transformation.outputPath(), this.readTemplate(filer, null, transformation.value()));
                        continue;
                    }
                    for (TypeDef typeDef : annotated.values()) {
                        this.generateFromStringTemplate(typeDef, transformation.paremters(), transformation.outputPath(), this.readTemplate(filer, typeDef.getPackageName(), transformation.value()));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return false;
    }

    public void selectFromResource(Elements elements, Filer filer, ResourceSelector selector, Map<String, TypeDef> definitions) {
        try {
            FileObject fileObject = filer.getResource(StandardLocation.CLASS_PATH, "", selector.value());
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(fileObject.openInputStream()));){
                List lines = reader.lines().map(String::trim).filter(l -> !Strings.isNullOrEmpty((String)l)).collect(Collectors.toList());
                AptContext aptContext = AptContext.getContext();
                Map<String, TypeDef> map = lines.stream().map(l -> elements.getTypeElement((CharSequence)l)).filter(e -> e instanceof TypeElement).map(e -> Adapters.adapt((Object)e, (AdapterContext)aptContext)).collect(Collectors.toMap(e -> e.getFullyQualifiedName(), e -> e));
                definitions.putAll(map);
            }
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public void selectAnnotated(RoundEnvironment env, Types types, AnnotationSelector selector, Map<String, TypeDef> definitions) {
        for (Element element : env.getElementsAnnotatedWith((TypeElement)types.asElement(this.annotationMirror(selector)))) {
            if (!(element instanceof TypeElement)) continue;
            TypeDef typeDef = new TypeDefBuilder(Adapters.adapt((Object)Apt.getClassElement((Element)element), (AdapterContext)AptContext.getContext())).build();
            definitions.put(typeDef.getFullyQualifiedName(), typeDef);
        }
    }

    public void selectPackages(Elements elements, PackageSelector selector, Map<String, TypeDef> definitions) {
        Pattern pattern = Pattern.compile(selector.pattern());
        PackageElement packageElement = elements.getPackageElement(selector.value());
        ArrayList<TypeElement> typeElements = new ArrayList<TypeElement>();
        if (packageElement != null) {
            for (Element element : packageElement.getEnclosedElements()) {
                if (!(element instanceof TypeElement)) continue;
                typeElements.add((TypeElement)element);
            }
        } else {
            TypeElement e = elements.getTypeElement(selector.value());
            if (e != null) {
                typeElements.add(e);
            }
        }
        for (TypeElement typeElement : typeElements) {
            TypeDef typeDef = new TypeDefBuilder(Adapters.adapt((Object)Apt.getClassElement((Element)typeElement), (AdapterContext)AptContext.getContext())).build();
            Matcher m = pattern.matcher(typeDef.getName());
            if (!m.matches()) continue;
            definitions.put(typeDef.getFullyQualifiedName(), typeDef);
        }
    }

    private TypeMirror annotationMirror(AnnotationSelector selector) {
        try {
            selector.value();
            return null;
        }
        catch (MirroredTypeException m) {
            return m.getTypeMirror();
        }
    }

    private String readTemplate(Filer filer, String pkg, String template) throws IOException {
        FileObject o;
        if (template == null) {
            throw new IllegalArgumentException("Template in:" + VelocityTransformation.class.getName() + " cannot be null.");
        }
        String targetPkg = pkg == null || template != null && template.startsWith("/") ? "" : pkg;
        String targetTemplate = template.startsWith("/") ? template.substring(1) : template;
        try {
            o = filer.getResource(StandardLocation.SOURCE_PATH, targetPkg, targetTemplate);
        }
        catch (IOException e) {
            try {
                o = filer.getResource(StandardLocation.CLASS_PATH, targetPkg, targetTemplate);
            }
            catch (IOException ex) {
                throw e;
            }
        }
        if (o == null) {
            throw new IOException("Template resource: " + template + " couldn't be found in sources or classpath.");
        }
        return o.getCharContent(false).toString();
    }
}

