/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.maven.testing;

import io.takari.incrementalbuild.maven.testing.IncrementalBuildLog;
import io.takari.incrementalbuild.maven.testing.IncrementalBuildRuntime;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.testing.AbstractMojoTestCase;
import org.apache.maven.plugin.testing.MojoRule;
import org.apache.maven.project.MavenProject;
import org.junit.Assert;

public class IncrementalBuildRule
extends MojoRule {
    public IncrementalBuildRule() {
        super((AbstractMojoTestCase)new IncrementalBuildRuntime());
    }

    public void executeMojo(MavenSession session, MavenProject project, MojoExecution execution) throws Exception {
        this.getBuildContextLog().clear();
        super.executeMojo(session, project, execution);
    }

    public IncrementalBuildLog getBuildContextLog() throws Exception {
        return (IncrementalBuildLog)this.lookup(IncrementalBuildLog.class);
    }

    public void assertBuildOutputs(File basedir, String ... paths) throws Exception {
        Set<File> expected = this.toFileSet(basedir, paths);
        TreeSet<File> actual = new TreeSet<File>(this.getBuildContextLog().getRegisteredOutputs());
        Assert.assertEquals((String)"(re)created outputs", (Object)IncrementalBuildRule.toString(expected), (Object)IncrementalBuildRule.toString(actual, true));
    }

    public void assertDeletedOutputs(File basedir, String ... paths) throws Exception {
        Set<File> expected = this.toFileSet(basedir, paths);
        TreeSet<File> actual = new TreeSet<File>(this.getBuildContextLog().getDeletedOutputs());
        actual.removeAll(this.getBuildContextLog().getRegisteredOutputs());
        Assert.assertEquals((String)"deleted outputs", (Object)IncrementalBuildRule.toString(expected), (Object)IncrementalBuildRule.toString(actual, false));
    }

    public void assertCarriedOverOutputs(File basedir, String ... paths) throws Exception {
        Set<File> expected = this.toFileSet(basedir, paths);
        TreeSet<File> actual = new TreeSet<File>(this.getBuildContextLog().getCarriedOverOutputs());
        Assert.assertEquals((String)"carried over outputs", (Object)IncrementalBuildRule.toString(expected), (Object)IncrementalBuildRule.toString(actual, true));
    }

    public void assertMessages(File basedir, String path, String ... messages) throws Exception {
        ArrayList<String> actual = new ArrayList<String>(this.getBuildContextLog().getMessages(new File(basedir, path)));
        List<String> expected = Arrays.asList(messages);
        Assert.assertEquals((Object)IncrementalBuildRule.toString(expected), (Object)IncrementalBuildRule.toString(actual));
    }

    private static String toString(Collection<?> objects) {
        StringBuilder sb = new StringBuilder();
        for (Object file : objects) {
            sb.append(file.toString()).append('\n');
        }
        return sb.toString();
    }

    private static String toString(Collection<File> files, boolean canRead) {
        StringBuilder sb = new StringBuilder();
        for (File file : files) {
            if (canRead != file.canRead()) {
                sb.append(file.canRead() ? "EXISTS " : "DOES NOT EXIST ");
            }
            sb.append(file.toString()).append('\n');
        }
        return sb.toString();
    }

    private Set<File> toFileSet(File basedir, String ... paths) {
        TreeSet<File> expected = new TreeSet<File>();
        for (String path : paths) {
            expected.add(new File(basedir, path));
        }
        return expected;
    }
}

