/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.spi;

import io.takari.incrementalbuild.spi.Plexus_MatchPatterns;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

class FileMatcher {
    private static final Matcher MATCH_EVERYTHING = new Matcher(){

        @Override
        public boolean matches(String path) {
            return true;
        }
    };
    private final Matcher includesMatcher;
    private final Matcher excludesMatcher;

    private FileMatcher(Matcher includesMatcher, Matcher excludesMatcher) {
        this.includesMatcher = includesMatcher;
        this.excludesMatcher = excludesMatcher;
    }

    public boolean matches(File file) {
        String path = file.getAbsolutePath();
        if (this.excludesMatcher != null && this.excludesMatcher.matches(path)) {
            return false;
        }
        if (this.includesMatcher != null) {
            return this.includesMatcher.matches(path);
        }
        return true;
    }

    private static Matcher fromStrings(String basepath, Collection<String> globs, Matcher everything) {
        if (globs == null || globs.isEmpty()) {
            return null;
        }
        ArrayList<String> normalized = new ArrayList<String>();
        for (String glob : globs) {
            if ("*".equals(glob) || "**".equals(glob) || "**/*".equals(glob)) {
                return everything;
            }
            StringBuilder gb = new StringBuilder();
            gb.append(basepath).append('/');
            if (!glob.startsWith("**") && !glob.startsWith("/**")) {
                gb.append("**/");
            }
            gb.append(glob.startsWith("/") ? glob.substring(1) : glob);
            if (glob.endsWith("/")) {
                gb.append("**");
            }
            normalized.add(gb.toString().replace('/', File.separatorChar));
        }
        final Plexus_MatchPatterns matcher = Plexus_MatchPatterns.from(normalized);
        return new Matcher(){

            @Override
            public boolean matches(String path) {
                return matcher.matches(path, false);
            }
        };
    }

    public static FileMatcher matcher(File basedir, Collection<String> includes, Collection<String> excludes) {
        String basepath = basedir.getAbsolutePath();
        Matcher includesMatcher = FileMatcher.fromStrings(basepath, includes, null);
        Matcher excludesMatcher = FileMatcher.fromStrings(basepath, excludes, MATCH_EVERYTHING);
        return new FileMatcher(includesMatcher, excludesMatcher);
    }

    private static interface Matcher {
        public boolean matches(String var1);
    }
}

