/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.proviso.archive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.tesla.proviso.archive.ArchiveHandler;
import io.tesla.proviso.archive.ArchiverHelper;
import io.tesla.proviso.archive.ExtendedArchiveEntry;
import io.tesla.proviso.archive.Selector;
import io.tesla.proviso.archive.Source;
import io.tesla.proviso.archive.source.DirectoryEntry;
import io.tesla.proviso.archive.source.DirectorySource;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.codehaus.plexus.util.SelectorUtils;

public class Archiver {
    public static final long DOS_EPOCH_IN_JAVA_TIME = 315561600000L;
    public static final long MINIMUM_TIMESTAMP_INCREMENT = 2000L;
    private final Map<String, ExtendedArchiveEntry> entries = new TreeMap<String, ExtendedArchiveEntry>();
    private final List<String> executables;
    private final boolean useRoot;
    private final boolean flatten;
    private final boolean normalize;
    private final String prefix;
    private final Selector selector;
    private final ArchiverBuilder builder;

    private Archiver(ArchiverBuilder builder) {
        this.builder = builder;
        this.executables = builder.executables;
        this.useRoot = builder.useRoot;
        this.flatten = builder.flatten;
        this.normalize = builder.normalize;
        this.prefix = builder.prefix;
        this.selector = new Selector(builder.includes, builder.excludes);
    }

    public void archive(File archive, List<String> sourceDirectories) throws IOException {
        File[] fileSourceDirectories = new File[sourceDirectories.size()];
        int i = 0;
        while (i < sourceDirectories.size()) {
            fileSourceDirectories[i] = new File(sourceDirectories.get(i));
            ++i;
        }
        this.archive(archive, fileSourceDirectories);
    }

    public void archive(File archive, File ... sourceDirectories) throws IOException {
        this.archive(archive, new DirectorySource(sourceDirectories));
    }

    public void archive(File archive, Source ... sources) throws IOException {
        ArchiveHandler archiveHandler = ArchiverHelper.getArchiveHandler(archive, this.builder);
        Throwable throwable = null;
        Object var5_6 = null;
        try (ArchiveOutputStream aos = archiveHandler.getOutputStream();){
            HashMap<String, Boolean> paths = new HashMap<String, Boolean>();
            Source[] sourceArray = sources;
            int n = sources.length;
            int n2 = 0;
            while (n2 < n) {
                Source source = sourceArray[n2];
                for (ExtendedArchiveEntry entry : source.entries()) {
                    String entryName = entry.getName();
                    if (!this.selector.include(entryName)) continue;
                    if (!this.useRoot && source.isDirectory()) {
                        entryName = entryName.substring(entryName.indexOf(47) + 1);
                    }
                    if (this.flatten && source.isDirectory()) {
                        if (entry.isDirectory()) continue;
                        entryName = entryName.substring(entryName.lastIndexOf(47) + 1);
                    }
                    if (this.prefix != null) {
                        entryName = String.valueOf(this.prefix) + entryName;
                    }
                    boolean isExecutable = false;
                    for (String executable : this.executables) {
                        if (!SelectorUtils.match((String)executable, (String)entry.getName())) continue;
                        isExecutable = true;
                        break;
                    }
                    if (entry.isDirectory() && !entryName.endsWith("/")) {
                        entryName = String.valueOf(entryName) + "/";
                    }
                    for (String directoryName : this.getParentDirectoryNames(entryName)) {
                        if (paths.containsKey(directoryName)) continue;
                        paths.put(directoryName, Boolean.FALSE);
                        ExtendedArchiveEntry directoryEntry = archiveHandler.createEntryFor(directoryName, new DirectoryEntry(directoryName), false);
                        this.addEntry(directoryName, directoryEntry, aos);
                    }
                    if (!paths.containsKey(entryName)) {
                        paths.put(entryName, Boolean.TRUE);
                        ExtendedArchiveEntry archiveEntry = archiveHandler.createEntryFor(entryName, entry, isExecutable);
                        this.addEntry(entryName, archiveEntry, aos);
                        continue;
                    }
                    if (!Boolean.TRUE.equals(paths.get(entryName))) continue;
                    throw new IllegalArgumentException("Duplicate archive entry " + entryName);
                }
                source.close();
                ++n2;
            }
            if (!this.entries.isEmpty()) {
                for (Map.Entry<String, ExtendedArchiveEntry> entry : this.entries.entrySet()) {
                    ExtendedArchiveEntry archiveEntry = entry.getValue();
                    this.writeEntry(archiveEntry, aos);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Iterable<String> getParentDirectoryNames(String entryName) {
        ArrayList<String> directoryNames = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(entryName, "/");
        if (st.hasMoreTokens()) {
            StringBuilder directoryName = new StringBuilder(st.nextToken());
            while (st.hasMoreTokens()) {
                directoryName.append('/');
                directoryNames.add(directoryName.toString());
                directoryName.append(st.nextToken());
            }
        }
        return directoryNames;
    }

    private long normalizedTimestamp(String name) {
        if (name.endsWith(".class")) {
            return 315561602000L;
        }
        return 315561600000L;
    }

    private long newEntryTimeMillis(String filename) {
        return this.normalize ? this.normalizedTimestamp(filename) : System.currentTimeMillis();
    }

    private void addEntry(String entryName, ExtendedArchiveEntry entry, ArchiveOutputStream aos) throws IOException {
        if (entryName.startsWith("/")) {
            entryName = entryName.substring(1);
        } else if (entryName.startsWith("./")) {
            entryName = entryName.substring(2);
        }
        if (this.normalize) {
            entry.setTime(this.newEntryTimeMillis(entryName));
            this.entries.put(entryName, entry);
        } else {
            this.writeEntry(entry, aos);
        }
    }

    private void writeEntry(ExtendedArchiveEntry entry, ArchiveOutputStream aos) throws IOException {
        aos.putArchiveEntry((ArchiveEntry)entry);
        if (!entry.isHardLink() && !entry.isDirectory()) {
            entry.writeEntry((OutputStream)aos);
        }
        aos.closeArchiveEntry();
    }

    public static ArchiverBuilder builder() {
        return new ArchiverBuilder();
    }

    /* synthetic */ Archiver(ArchiverBuilder archiverBuilder, Archiver archiver) {
        this(archiverBuilder);
    }

    public static class ArchiverBuilder {
        List<String> includes = Lists.newArrayList();
        List<String> excludes = Lists.newArrayList();
        List<String> executables = Lists.newArrayList();
        boolean useRoot = true;
        boolean flatten = false;
        boolean normalize = false;
        String prefix;
        boolean posixLongFileMode;
        List<String> hardLinkIncludes = Lists.newArrayList();
        List<String> hardLinkExcludes = Lists.newArrayList();

        public ArchiverBuilder includes(String ... includes) {
            return this.includes((Iterable<String>)ImmutableList.copyOf((Object[])includes));
        }

        public ArchiverBuilder includes(Iterable<String> includes) {
            Iterables.addAll(this.includes, includes);
            return this;
        }

        public ArchiverBuilder excludes(String ... excludes) {
            return this.excludes((Iterable<String>)ImmutableList.copyOf((Object[])excludes));
        }

        public ArchiverBuilder excludes(Iterable<String> excludes) {
            Iterables.addAll(this.excludes, excludes);
            return this;
        }

        public ArchiverBuilder useRoot(boolean useRoot) {
            this.useRoot = useRoot;
            return this;
        }

        public ArchiverBuilder normalize(boolean normalize) {
            this.normalize = normalize;
            return this;
        }

        public ArchiverBuilder executable(String ... executables) {
            return this.executable((Iterable<String>)ImmutableList.copyOf((Object[])executables));
        }

        public ArchiverBuilder executable(Iterable<String> executables) {
            Iterables.addAll(this.executables, executables);
            return this;
        }

        public ArchiverBuilder flatten(boolean flatten) {
            this.flatten = flatten;
            return this;
        }

        public ArchiverBuilder withPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public ArchiverBuilder posixLongFileMode(boolean posixLongFileMode) {
            this.posixLongFileMode = posixLongFileMode;
            return this;
        }

        public ArchiverBuilder hardLinkIncludes(String ... hardLinkIncludes) {
            return this.hardLinkIncludes((Iterable<String>)ImmutableList.copyOf((Object[])hardLinkIncludes));
        }

        public ArchiverBuilder hardLinkIncludes(Iterable<String> hardLinkIncludes) {
            Iterables.addAll(this.hardLinkIncludes, hardLinkIncludes);
            return this;
        }

        public ArchiverBuilder hardLinkExcludes(String ... hardLinkExcludes) {
            return this.hardLinkExcludes((Iterable<String>)ImmutableList.copyOf((Object[])hardLinkExcludes));
        }

        public ArchiverBuilder hardLinkExcludes(Iterable<String> hardLinkExcludes) {
            Iterables.addAll(this.hardLinkExcludes, hardLinkExcludes);
            return this;
        }

        public Archiver build() {
            return new Archiver(this, null);
        }
    }
}

