/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.proviso.archive.source;

import com.google.common.io.ByteStreams;
import io.tesla.proviso.archive.ExtendedArchiveEntry;
import io.tesla.proviso.archive.perms.FileMode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;

public class FileEntry
implements ExtendedArchiveEntry {
    private final String name;
    private final File file;

    public FileEntry(String name, File file) {
        this.name = name;
        this.file = file;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public boolean isHardLink() {
        return false;
    }

    @Override
    public String getHardLinkPath() {
        return null;
    }

    public long getSize() {
        return this.file.length();
    }

    @Override
    public void writeEntry(OutputStream outputStream) throws IOException {
        if (this.file.isDirectory()) {
            return;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream entryInputStream = this.getInputStream();){
            ByteStreams.copy((InputStream)entryInputStream, (OutputStream)outputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void setFileMode(int mode) {
    }

    @Override
    public int getFileMode() {
        return FileMode.getFileMode(this.file);
    }

    @Override
    public void setSize(long size) {
    }

    @Override
    public void setTime(long time) {
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public Date getLastModifiedDate() {
        return null;
    }

    @Override
    public boolean isExecutable() {
        return FileMode.EXECUTABLE_FILE.equals(this.getFileMode());
    }

    @Override
    public long getTime() {
        return this.file.lastModified();
    }
}

