/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans.expression;

import io.vertx.codetrans.CodeBuilder;
import io.vertx.codetrans.CodeWriter;
import io.vertx.codetrans.expression.ExpressionModel;
import java.util.ArrayList;
import java.util.List;

public class BinaryExpressionModel
extends ExpressionModel {
    final ExpressionModel left;
    final String op;
    final ExpressionModel right;

    public BinaryExpressionModel(CodeBuilder builder, ExpressionModel left, String op, ExpressionModel right) {
        super(builder);
        this.left = left;
        this.op = op;
        this.right = right;
    }

    @Override
    public boolean isStringDecl() {
        return this.op.equals("+") && (this.left.isStringDecl() || this.right.isStringDecl());
    }

    public ExpressionModel getLeft() {
        return this.left;
    }

    public String getOp() {
        return this.op;
    }

    public ExpressionModel getRight() {
        return this.right;
    }

    @Override
    public void render(CodeWriter writer) {
        if (this.op.equals("+") && (this.left.isStringDecl() || this.right.isStringDecl())) {
            ArrayList<Object> parts = new ArrayList<Object>();
            this.collectParts(parts);
            writer.renderStringLiteral(parts);
        } else {
            writer.renderBinary(this);
        }
    }

    @Override
    void collectParts(List<Object> parts) {
        if (this.left.isStringDecl()) {
            this.left.collectParts(parts);
        } else {
            parts.add(this.left);
        }
        if (this.right.isStringDecl()) {
            this.right.collectParts(parts);
        } else {
            parts.add(this.right);
        }
    }
}

