/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans.expression;

import io.vertx.codegen.type.TypeInfo;
import io.vertx.codetrans.CodeBuilder;
import io.vertx.codetrans.CodeWriter;
import io.vertx.codetrans.MethodSignature;
import io.vertx.codetrans.TypeArg;
import io.vertx.codetrans.expression.ExpressionModel;
import io.vertx.codetrans.expression.JsonObjectModel;
import io.vertx.codetrans.expression.NullLiteralModel;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.List;

public class JsonArrayModel
extends ExpressionModel {
    final ExpressionModel expression;

    public JsonArrayModel(CodeBuilder builder, ExpressionModel expression) {
        super(builder);
        this.expression = expression;
    }

    @Override
    public ExpressionModel onMethodInvocation(TypeInfo receiverType, MethodSignature method, TypeInfo returnType, List<TypeArg> typeArguments, List<ExpressionModel> argumentModels, List<TypeInfo> argumentTypes) {
        String methodName;
        switch (methodName = method.getName()) {
            case "getString": 
            case "getBoolean": 
            case "getFloat": 
            case "getDouble": 
            case "getLong": 
            case "getInteger": {
                if (argumentModels.size() == 1) {
                    return this.builder.render((CodeWriter writer) -> writer.renderJsonArrayGet(this.expression, JsonObjectModel.classMapping.get(methodName.substring(3)), (ExpressionModel)argumentModels.get(0)));
                }
                throw this.unsupported("Invalid arguments " + argumentModels);
            }
            case "getJsonArray": {
                return new JsonArrayModel(this.builder, this.builder.render((CodeWriter writer) -> writer.renderJsonArrayGet(this.expression, JsonArray.class, (ExpressionModel)argumentModels.get(0))));
            }
            case "getJsonObject": {
                return new JsonObjectModel(this.builder, this.builder.render((CodeWriter writer) -> writer.renderJsonArrayGet(this.expression, JsonObject.class, (ExpressionModel)argumentModels.get(0))));
            }
            case "encode": 
            case "encodePrettily": {
                return this.builder.jsonArrayEncoder(this.expression);
            }
            case "add": {
                return this.builder.render((CodeWriter writer) -> writer.renderJsonArrayAdd(this.expression, (ExpressionModel)argumentModels.get(0)));
            }
            case "addNull": {
                return this.builder.render((CodeWriter writer) -> writer.renderJsonArrayAdd(this.expression, new NullLiteralModel(this.builder)));
            }
        }
        throw this.unsupported("Method " + method);
    }

    @Override
    public void render(CodeWriter writer) {
        this.expression.render(writer);
    }
}

