/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClientOptions;
import io.vertx.redis.client.RedisClientType;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.RedisRole;
import io.vertx.redis.client.RedisSlaves;
import java.util.ArrayList;
import java.util.Map;

public class RedisOptionsConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, RedisOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "connectionString": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setConnectionString((String)member.getValue());
                    break;
                }
                case "connectionStrings": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addConnectionString((String)item);
                        }
                    });
                    break;
                }
                case "endpoint": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setEndpoint((String)member.getValue());
                    break;
                }
                case "endpoints": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setEndpoints(list);
                    break;
                }
                case "masterName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setMasterName((String)member.getValue());
                    break;
                }
                case "maxNestedArrays": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxNestedArrays(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxPoolSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxPoolSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxPoolWaiting": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxPoolWaiting(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxWaitingHandlers": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxWaitingHandlers(((Number)member.getValue()).intValue());
                    break;
                }
                case "netClientOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setNetClientOptions(new NetClientOptions((JsonObject)member.getValue()));
                    break;
                }
                case "poolCleanerInterval": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPoolCleanerInterval(((Number)member.getValue()).intValue());
                    break;
                }
                case "poolRecycleTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPoolRecycleTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "role": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setRole(RedisRole.valueOf((String)member.getValue()));
                    break;
                }
                case "type": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setType(RedisClientType.valueOf((String)member.getValue()));
                    break;
                }
                case "useSlave": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setUseSlave(RedisSlaves.valueOf((String)member.getValue()));
                }
            }
        }
    }

    public static void toJson(RedisOptions obj, JsonObject json) {
        RedisOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(RedisOptions obj, Map<String, Object> json) {
        if (obj.getEndpoint() != null) {
            json.put("endpoint", obj.getEndpoint());
        }
        if (obj.getEndpoints() != null) {
            JsonArray array = new JsonArray();
            obj.getEndpoints().forEach(item -> array.add(item));
            json.put("endpoints", array);
        }
        if (obj.getMasterName() != null) {
            json.put("masterName", obj.getMasterName());
        }
        json.put("maxNestedArrays", obj.getMaxNestedArrays());
        json.put("maxPoolSize", obj.getMaxPoolSize());
        json.put("maxPoolWaiting", obj.getMaxPoolWaiting());
        json.put("maxWaitingHandlers", obj.getMaxWaitingHandlers());
        if (obj.getNetClientOptions() != null) {
            json.put("netClientOptions", obj.getNetClientOptions().toJson());
        }
        json.put("poolCleanerInterval", obj.getPoolCleanerInterval());
        json.put("poolRecycleTimeout", obj.getPoolRecycleTimeout());
        if (obj.getRole() != null) {
            json.put("role", obj.getRole().name());
        }
        if (obj.getType() != null) {
            json.put("type", obj.getType().name());
        }
        if (obj.getUseSlave() != null) {
            json.put("useSlave", obj.getUseSlave().name());
        }
    }
}

