/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.RedisClient;
import io.vertx.redis.RedisOptions;
import io.vertx.redis.RedisTransaction;
import io.vertx.redis.Script;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.ResponseType;
import io.vertx.redis.impl.RedisEncoding;
import io.vertx.redis.op.AggregateOptions;
import io.vertx.redis.op.BitFieldOptions;
import io.vertx.redis.op.BitFieldOverflowOptions;
import io.vertx.redis.op.BitOperation;
import io.vertx.redis.op.ClientReplyOptions;
import io.vertx.redis.op.FailoverOptions;
import io.vertx.redis.op.GeoMember;
import io.vertx.redis.op.GeoRadiusOptions;
import io.vertx.redis.op.GeoUnit;
import io.vertx.redis.op.InsertOptions;
import io.vertx.redis.op.KillFilter;
import io.vertx.redis.op.LimitOptions;
import io.vertx.redis.op.MigrateOptions;
import io.vertx.redis.op.ObjectCmd;
import io.vertx.redis.op.RangeLimitOptions;
import io.vertx.redis.op.RangeOptions;
import io.vertx.redis.op.ResetOptions;
import io.vertx.redis.op.ScanOptions;
import io.vertx.redis.op.ScriptDebugOptions;
import io.vertx.redis.op.SetOptions;
import io.vertx.redis.op.SlotCmd;
import io.vertx.redis.op.SortOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;

@Deprecated
public final class RedisClientImpl
implements RedisClient {
    private final String BASE_ADDRESS = "io.vertx.redis";
    private final Vertx vertx;
    private final RedisOptions options;
    private final AtomicReference<CompletableFuture<RedisConnection>> redis = new AtomicReference();
    private final EventBus eb;
    private final String connectionString;

    public RedisClientImpl(Vertx vertx, RedisOptions options) {
        this.vertx = vertx;
        this.options = options;
        this.eb = vertx.eventBus();
        String connString = "";
        if (options.isDomainSocket()) {
            connString = connString + "unix://" + options.getDomainSocketAddress() + "?";
        } else {
            connString = connString + "redis";
            if (options.isSsl()) {
                connString = connString + "s";
            }
            connString = connString + "://" + options.getHost() + ":" + options.getPort() + "/?";
        }
        if (options.getAuth() != null) {
            connString = connString + "password=" + options.getAuth() + "&";
        }
        if (options.getSelect() != null) {
            connString = connString + "db=" + options.getSelect();
        }
        this.connectionString = connString;
    }

    private static List<?> toPayload(Object ... parameters) {
        ArrayList<Object> result = new ArrayList<Object>(parameters.length);
        for (Object param : parameters) {
            if (param instanceof JsonArray) {
                param = ((JsonArray)param).getList();
            }
            if (param instanceof JsonObject) {
                param = ((JsonObject)param).getMap();
            }
            if (param instanceof Collection) {
                ((Collection)param).stream().filter(Objects::nonNull).forEach(result::add);
                continue;
            }
            if (param instanceof Map) {
                for (Map.Entry pair : ((Map)param).entrySet()) {
                    result.add(pair.getKey());
                    result.add(pair.getValue());
                }
                continue;
            }
            if (param instanceof Stream) {
                ((Stream)param).forEach(e -> {
                    if (e instanceof Object[]) {
                        Collections.addAll(result, (Object[])e);
                    } else {
                        result.add(e);
                    }
                });
                continue;
            }
            if (param == null) continue;
            result.add(param);
        }
        return result;
    }

    private void send(Command command, List arguments, Handler<AsyncResult<Response>> handler) {
        CompletableFuture<RedisConnection> fut;
        Request req = Request.cmd(command);
        if (arguments != null) {
            for (Object o : arguments) {
                if (o == null) {
                    req.nullArg();
                    continue;
                }
                if (o instanceof Buffer) {
                    req.arg((Buffer)o);
                    continue;
                }
                req.arg(o.toString());
            }
        }
        if ((fut = this.redis.get()) == null) {
            CompletableFuture f = new CompletableFuture();
            if (this.redis.compareAndSet(null, f)) {
                fut = f;
                Redis.createClient(this.vertx, new io.vertx.redis.client.RedisOptions().setNetClientOptions(this.options).setConnectionString(this.connectionString)).connect((Handler<AsyncResult<RedisConnection>>)((Handler)onReady -> {
                    if (onReady.succeeded()) {
                        ((RedisConnection)onReady.result()).handler(this::handlePubSubMessage);
                        f.complete(onReady.result());
                    } else {
                        f.completeExceptionally(onReady.cause());
                    }
                }));
            } else {
                fut = this.redis.get();
            }
        }
        fut.whenComplete((client, err) -> {
            if (err == null) {
                client.send(req, handler);
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)err));
            }
        });
    }

    private void handlePubSubMessage(Response response) {
        JsonArray data = RedisClientImpl.toJsonArray(response);
        if (!"message".equals(data.getString(0))) {
            return;
        }
        String channel = data.getString(1);
        String vertxChannel = "io.vertx.redis." + channel;
        JsonObject replyMessage = new JsonObject();
        replyMessage.put("status", "ok");
        JsonObject message = new JsonObject();
        message.put("channel", channel);
        message.put("message", data.getString(2));
        replyMessage.put("value", message);
        this.eb.send(vertxChannel, (Object)replyMessage);
    }

    private void sendLong(Command command, List arguments, Handler<AsyncResult<Long>> handler) {
        this.send(command, arguments, (Handler<AsyncResult<Response>>)((Handler)ar -> {
            if (ar.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)((Response)ar.result()).toLong()));
            }
        }));
    }

    private void sendString(Command command, List arguments, Handler<AsyncResult<String>> handler) {
        this.send(command, arguments, (Handler<AsyncResult<Response>>)((Handler)ar -> {
            if (ar.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture(ar.result() != null ? ((Response)ar.result()).toString() : null));
            }
        }));
    }

    private static JsonArray toJsonArray(Response response) {
        JsonArray json = new JsonArray();
        if (response.type() != ResponseType.MULTI) {
            switch (response.type()) {
                case INTEGER: {
                    json.add(response.toLong());
                    break;
                }
                case SIMPLE: 
                case BULK: {
                    json.add(response.toString());
                }
            }
            return json;
        }
        for (Response r : response) {
            if (r == null) {
                json.addNull();
                continue;
            }
            switch (r.type()) {
                case INTEGER: {
                    json.add(r.toLong());
                    break;
                }
                case SIMPLE: 
                case BULK: {
                    json.add(r.toString());
                    break;
                }
                case MULTI: {
                    json.add(RedisClientImpl.toJsonArray(r));
                }
            }
        }
        return json;
    }

    private void sendJsonArray(Command command, List arguments, Handler<AsyncResult<JsonArray>> handler) {
        this.send(command, arguments, (Handler<AsyncResult<Response>>)((Handler)ar -> {
            if (ar.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture(ar.result() != null ? RedisClientImpl.toJsonArray((Response)ar.result()) : null));
            }
        }));
    }

    private void sendVoid(Command command, List arguments, Handler<AsyncResult<Void>> handler) {
        this.send(command, arguments, (Handler<AsyncResult<Response>>)((Handler)ar -> {
            if (ar.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture());
            }
        }));
    }

    private void sendBuffer(Command command, List arguments, Handler<AsyncResult<Buffer>> handler) {
        this.send(command, arguments, (Handler<AsyncResult<Response>>)((Handler)ar -> {
            if (ar.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture(ar.result() != null ? ((Response)ar.result()).toBuffer() : null));
            }
        }));
    }

    private static JsonObject toJsonObject(Response response) {
        JsonObject json = new JsonObject();
        for (String key : response.getKeys()) {
            Response value = response.get(key);
            switch (value.type()) {
                case INTEGER: {
                    json.put(key, value.toLong());
                    break;
                }
                case SIMPLE: 
                case BULK: {
                    json.put(key, value.toString());
                    break;
                }
                case MULTI: {
                    json.put(key, RedisClientImpl.toJsonArray(value));
                }
            }
        }
        return json;
    }

    private void sendJsonObject(Command command, List arguments, Handler<AsyncResult<JsonObject>> handler) {
        this.send(command, arguments, (Handler<AsyncResult<Response>>)((Handler)ar -> {
            if (ar.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture(ar.result() != null ? RedisClientImpl.toJsonObject((Response)ar.result()) : null));
            }
        }));
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        CompletableFuture prev = this.redis.getAndSet(null);
        if (prev != null) {
            prev.whenComplete((client, err) -> {
                if (err == null) {
                    client.close();
                    if (handler != null) {
                        handler.handle((Object)Future.succeededFuture());
                    }
                } else if (handler != null) {
                    handler.handle((Object)Future.failedFuture((Throwable)err.getCause()));
                }
            });
        }
    }

    @Override
    public RedisClient append(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.APPEND, RedisClientImpl.toPayload(key, value), handler);
        return this;
    }

    @Override
    public RedisClient auth(String password, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.AUTH, RedisClientImpl.toPayload(password), handler);
        return this;
    }

    @Override
    public RedisClient bgrewriteaof(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.BGREWRITEAOF, null, handler);
        return this;
    }

    @Override
    public RedisClient bgsave(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.BGSAVE, null, handler);
        return this;
    }

    @Override
    public RedisClient bitcount(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.BITCOUNT, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient bitcountRange(String key, long start, long end, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.BITCOUNT, RedisClientImpl.toPayload(key, start, end), handler);
        return this;
    }

    @Override
    public RedisClient bitop(BitOperation operation, String destkey, List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.BITOP, RedisClientImpl.toPayload(operation.name(), destkey, keys), handler);
        return this;
    }

    @Override
    public RedisClient bitpos(String key, int bit, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.BITPOS, RedisClientImpl.toPayload(key, bit), handler);
        return this;
    }

    @Override
    public RedisClient bitposFrom(String key, int bit, int start, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.BITPOS, RedisClientImpl.toPayload(key, bit, start), handler);
        return this;
    }

    @Override
    public RedisClient bitposRange(String key, int bit, int start, int stop, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.BITPOS, RedisClientImpl.toPayload(key, bit, start, stop), handler);
        return this;
    }

    @Override
    public RedisClient blpop(String key, int seconds, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.BLPOP, RedisClientImpl.toPayload(key, seconds), handler);
        return this;
    }

    @Override
    public RedisClient blpopMany(List<String> keys, int seconds, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.BLPOP, RedisClientImpl.toPayload(keys, seconds), handler);
        return this;
    }

    @Override
    public RedisClient brpop(String key, int seconds, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.BRPOP, RedisClientImpl.toPayload(key, seconds), handler);
        return this;
    }

    @Override
    public RedisClient brpopMany(List<String> keys, int seconds, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.BRPOP, RedisClientImpl.toPayload(keys, seconds), handler);
        return this;
    }

    @Override
    public RedisClient brpoplpush(String key, String destkey, int seconds, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.BRPOPLPUSH, RedisClientImpl.toPayload(key, destkey, seconds), handler);
        return this;
    }

    @Override
    public RedisClient clientKill(KillFilter filter, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.CLIENT, RedisClientImpl.toPayload("kill", filter.toJsonArray().getList()), handler);
        return this;
    }

    @Override
    public RedisClient clientList(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.CLIENT, RedisClientImpl.toPayload("list"), handler);
        return this;
    }

    @Override
    public RedisClient clientGetname(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.CLIENT, RedisClientImpl.toPayload("GETNAME"), handler);
        return this;
    }

    @Override
    public RedisClient clientPause(long millis, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.CLIENT, RedisClientImpl.toPayload("PAUSE", millis), handler);
        return this;
    }

    @Override
    public RedisClient clientSetname(String name, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.CLIENT, RedisClientImpl.toPayload("SETNAME", name), handler);
        return this;
    }

    @Override
    public RedisClient clusterAddslots(List<Long> slots, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.CLUSTER, RedisClientImpl.toPayload("ADDSLOTS"), handler);
        return this;
    }

    @Override
    public RedisClient clusterCountFailureReports(String nodeId, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.CLUSTER, RedisClientImpl.toPayload("COUNT-FAILURE-REPORTS", nodeId), handler);
        return this;
    }

    @Override
    public RedisClient clusterCountkeysinslot(long slot, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.CLUSTER, RedisClientImpl.toPayload("COUNTKEYSINSLOT", slot), handler);
        return this;
    }

    @Override
    public RedisClient clusterDelslots(long slot, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.CLUSTER, RedisClientImpl.toPayload("DELSLOTS", slot), handler);
        return this;
    }

    @Override
    public RedisClient clusterDelslotsMany(List<Long> slots, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.CLUSTER, RedisClientImpl.toPayload("DELSLOTS", slots), handler);
        return this;
    }

    @Override
    public RedisClient clusterFailover(Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.CLUSTER, RedisClientImpl.toPayload("FAILOVER"), handler);
        return this;
    }

    @Override
    public RedisClient clusterFailOverWithOptions(FailoverOptions options, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.CLUSTER, RedisClientImpl.toPayload(new Object[]{"FAILOVER", options}), handler);
        return this;
    }

    @Override
    public RedisClient clusterForget(String nodeId, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.CLUSTER, RedisClientImpl.toPayload("FORGET", nodeId), handler);
        return this;
    }

    @Override
    public RedisClient clusterGetkeysinslot(long slot, long count, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.CLUSTER, RedisClientImpl.toPayload("GETKEYSINSLOT", slot, count), handler);
        return this;
    }

    @Override
    public RedisClient clusterInfo(Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.CLUSTER, RedisClientImpl.toPayload("INFO"), handler);
        return this;
    }

    @Override
    public RedisClient clusterKeyslot(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.CLUSTER, RedisClientImpl.toPayload("KEYSLOT", key), handler);
        return this;
    }

    @Override
    public RedisClient clusterMeet(String ip, long port, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.CLUSTER, RedisClientImpl.toPayload("MEET", ip, port), handler);
        return this;
    }

    @Override
    public RedisClient clusterNodes(Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.CLUSTER, RedisClientImpl.toPayload("NODES"), handler);
        return this;
    }

    @Override
    public RedisClient clusterReplicate(String nodeId, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.CLUSTER, RedisClientImpl.toPayload("REPLICATE", nodeId), handler);
        return this;
    }

    @Override
    public RedisClient clusterReset(Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.CLUSTER, RedisClientImpl.toPayload("RESET"), handler);
        return this;
    }

    @Override
    public RedisClient clusterResetWithOptions(ResetOptions options, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.CLUSTER, RedisClientImpl.toPayload(new Object[]{"RESET", options}), handler);
        return this;
    }

    @Override
    public RedisClient clusterSaveconfig(Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.CLUSTER, RedisClientImpl.toPayload("SAVECONFIG"), handler);
        return this;
    }

    @Override
    public RedisClient clusterSetConfigEpoch(long epoch, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.CLUSTER, RedisClientImpl.toPayload("SET-CONFIG-EPOCH", epoch), handler);
        return this;
    }

    @Override
    public RedisClient clusterSetslot(long slot, SlotCmd subcommand, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.CLUSTER, RedisClientImpl.toPayload(new Object[]{"SETSLOT", slot, subcommand}), handler);
        return this;
    }

    @Override
    public RedisClient clusterSetslotWithNode(long slot, SlotCmd subcommand, String nodeId, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.CLUSTER, RedisClientImpl.toPayload(new Object[]{"SETSLOT", slot, subcommand, nodeId}), handler);
        return this;
    }

    @Override
    public RedisClient clusterSlaves(String nodeId, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.CLUSTER, RedisClientImpl.toPayload("SLAVES", nodeId), handler);
        return this;
    }

    @Override
    public RedisClient clusterSlots(Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.CLUSTER, RedisClientImpl.toPayload("SLOTS"), handler);
        return this;
    }

    @Override
    public RedisClient command(Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.COMMAND, null, handler);
        return this;
    }

    @Override
    public RedisClient commandCount(Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.COMMAND, RedisClientImpl.toPayload("COUNT"), handler);
        return this;
    }

    @Override
    public RedisClient commandGetkeys(Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.COMMAND, RedisClientImpl.toPayload("GETKEYS"), handler);
        return this;
    }

    @Override
    public RedisClient commandInfo(List<String> commands, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.COMMAND, RedisClientImpl.toPayload("INFO", commands), handler);
        return this;
    }

    @Override
    public RedisClient configGet(String parameter, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.CONFIG, RedisClientImpl.toPayload("GET", parameter), handler);
        return this;
    }

    @Override
    public RedisClient configRewrite(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.CONFIG, RedisClientImpl.toPayload("REWRITE"), handler);
        return this;
    }

    @Override
    public RedisClient configSet(String parameter, String value, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.CONFIG, RedisClientImpl.toPayload("SET", parameter, value), handler);
        return this;
    }

    @Override
    public RedisClient configResetstat(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.CONFIG, RedisClientImpl.toPayload("RESETSTAT"), handler);
        return this;
    }

    @Override
    public RedisClient dbsize(Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.DBSIZE, null, handler);
        return this;
    }

    @Override
    public RedisClient debugObject(String key, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.DEBUG, RedisClientImpl.toPayload("OBJECT", key), handler);
        return this;
    }

    @Override
    public RedisClient debugSegfault(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.DEBUG, RedisClientImpl.toPayload("SEGFAULT"), handler);
        return this;
    }

    @Override
    public RedisClient decr(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.DECR, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient decrby(String key, long decrement, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.DECRBY, RedisClientImpl.toPayload(key, decrement), handler);
        return this;
    }

    @Override
    public RedisClient del(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.DEL, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient delMany(List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.DEL, RedisClientImpl.toPayload(keys), handler);
        return this;
    }

    @Override
    public RedisClient dump(String key, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.DUMP, RedisClientImpl.toPayload(key), (Handler<AsyncResult<String>>)((Handler)dump -> {
            if (dump.failed()) {
                handler.handle(dump);
            } else {
                handler.handle((Object)Future.succeededFuture((Object)RedisEncoding.encode((String)dump.result())));
            }
        }));
        return this;
    }

    @Override
    public RedisClient echo(String message, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.ECHO, RedisClientImpl.toPayload(message), handler);
        return this;
    }

    @Override
    public RedisClient eval(String script, List<String> keys, List<String> args, Handler<AsyncResult<JsonArray>> handler) {
        keys = keys != null ? keys : Collections.emptyList();
        args = args != null ? args : Collections.emptyList();
        this.sendJsonArray(Command.EVAL, RedisClientImpl.toPayload(script, keys.size(), keys, args), handler);
        return this;
    }

    @Override
    public RedisClient evalsha(String sha1, List<String> keys, List<String> args, Handler<AsyncResult<JsonArray>> handler) {
        keys = keys != null ? keys : Collections.emptyList();
        args = args != null ? args : Collections.emptyList();
        this.sendJsonArray(Command.EVALSHA, RedisClientImpl.toPayload(sha1, keys.size(), keys, args), handler);
        return this;
    }

    @Override
    public RedisClient evalScript(Script script, List<String> keys, List<String> args, Handler<AsyncResult<JsonArray>> handler) {
        this.evalsha(script.getSha1(), keys, args, (Handler<AsyncResult<JsonArray>>)((Handler)res -> {
            if (res.failed() && res.cause().getMessage().startsWith("NOSCRIPT")) {
                this.eval(script.getScript(), keys, args, handler);
            } else {
                handler.handle(res);
            }
        }));
        return this;
    }

    @Override
    public RedisClient exists(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.EXISTS, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient existsMany(List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.EXISTS, RedisClientImpl.toPayload(keys), handler);
        return this;
    }

    @Override
    public RedisClient expire(String key, long seconds, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.EXPIRE, RedisClientImpl.toPayload(key, seconds), handler);
        return this;
    }

    @Override
    public RedisClient expireat(String key, long seconds, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.EXPIREAT, RedisClientImpl.toPayload(key, seconds), handler);
        return this;
    }

    @Override
    public RedisClient flushall(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.FLUSHALL, null, handler);
        return this;
    }

    @Override
    public RedisClient flushdb(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.FLUSHDB, null, handler);
        return this;
    }

    @Override
    public RedisClient get(String key, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.GET, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient getBinary(String key, Handler<AsyncResult<Buffer>> handler) {
        this.sendBuffer(Command.GET, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient getbit(String key, long offset, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.GETBIT, RedisClientImpl.toPayload(key, offset), handler);
        return this;
    }

    @Override
    public RedisClient getrange(String key, long start, long end, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.GETRANGE, RedisClientImpl.toPayload(key, start, end), handler);
        return this;
    }

    @Override
    public RedisClient getset(String key, String value, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.GETSET, RedisClientImpl.toPayload(key, value), handler);
        return this;
    }

    @Override
    public RedisClient hdel(String key, String field, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.HDEL, RedisClientImpl.toPayload(key, field), handler);
        return this;
    }

    @Override
    public RedisClient hdelMany(String key, List<String> fields, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.HDEL, RedisClientImpl.toPayload(key, fields), handler);
        return this;
    }

    @Override
    public RedisClient hexists(String key, String field, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.HEXISTS, RedisClientImpl.toPayload(key, field), handler);
        return this;
    }

    @Override
    public RedisClient hget(String key, String field, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.HGET, RedisClientImpl.toPayload(key, field), handler);
        return this;
    }

    @Override
    public RedisClient hgetall(String key, Handler<AsyncResult<JsonObject>> handler) {
        this.sendJsonObject(Command.HGETALL, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient hincrby(String key, String field, long increment, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.HINCRBY, RedisClientImpl.toPayload(key, field, increment), handler);
        return this;
    }

    @Override
    public RedisClient hincrbyfloat(String key, String field, double increment, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.HINCRBYFLOAT, RedisClientImpl.toPayload(key, field, increment), handler);
        return this;
    }

    @Override
    public RedisClient hkeys(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.HKEYS, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient hlen(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.HLEN, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient hmget(String key, List<String> fields, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.HMGET, RedisClientImpl.toPayload(key, fields), handler);
        return this;
    }

    @Override
    public RedisClient hmset(String key, JsonObject values, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.HMSET, RedisClientImpl.toPayload(key, values), handler);
        return this;
    }

    @Override
    public RedisClient hset(String key, String field, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.HSET, RedisClientImpl.toPayload(key, field, value), handler);
        return this;
    }

    @Override
    public RedisClient hsetnx(String key, String field, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.HSETNX, RedisClientImpl.toPayload(key, field, value), handler);
        return this;
    }

    @Override
    public RedisClient hvals(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.HVALS, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient incr(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.INCR, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient incrby(String key, long increment, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.INCRBY, RedisClientImpl.toPayload(key, increment), handler);
        return this;
    }

    @Override
    public RedisClient incrbyfloat(String key, double increment, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.INCRBYFLOAT, RedisClientImpl.toPayload(key, increment), handler);
        return this;
    }

    @Override
    public RedisClient info(Handler<AsyncResult<JsonObject>> handler) {
        this.sendString(Command.INFO, Collections.emptyList(), (Handler<AsyncResult<String>>)((Handler)info -> {
            if (info.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)info.cause()));
            } else {
                JsonObject result;
                JsonObject section = result = new JsonObject();
                for (String line : ((String)info.result()).split("\r?\n")) {
                    if (line.length() <= 0) continue;
                    if (line.charAt(0) == '#') {
                        section = new JsonObject();
                        result.put(line.substring(2).toLowerCase(), section);
                        continue;
                    }
                    int sep = line.indexOf(58);
                    section.put(line.substring(0, sep), line.substring(sep + 1));
                }
                handler.handle((Object)Future.succeededFuture((Object)result));
            }
        }));
        return this;
    }

    @Override
    public RedisClient infoSection(String section, Handler<AsyncResult<JsonObject>> handler) {
        this.sendString(Command.INFO, RedisClientImpl.toPayload(section), (Handler<AsyncResult<String>>)((Handler)info -> {
            if (info.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)info.cause()));
            } else {
                JsonObject result;
                JsonObject sectionJson = result = new JsonObject();
                for (String line : ((String)info.result()).split("\r?\n")) {
                    if (line.length() <= 0) continue;
                    if (line.charAt(0) == '#') {
                        sectionJson = new JsonObject();
                        result.put(line.substring(2).toLowerCase(), sectionJson);
                        continue;
                    }
                    int sep = line.indexOf(58);
                    sectionJson.put(line.substring(0, sep), line.substring(sep + 1));
                }
                handler.handle((Object)Future.succeededFuture((Object)result));
            }
        }));
        return this;
    }

    @Override
    public RedisClient keys(String pattern, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.KEYS, RedisClientImpl.toPayload(pattern), handler);
        return this;
    }

    @Override
    public RedisClient lastsave(Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.LASTSAVE, null, handler);
        return this;
    }

    @Override
    public RedisClient lindex(String key, int index, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.LINDEX, RedisClientImpl.toPayload(key, index), handler);
        return this;
    }

    @Override
    public RedisClient linsert(String key, InsertOptions option, String pivot, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.LINSERT, RedisClientImpl.toPayload(key, option.name(), pivot, value), handler);
        return this;
    }

    @Override
    public RedisClient llen(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.LLEN, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient lpop(String key, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.LPOP, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient lpushMany(String key, List<String> values, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.LPUSH, RedisClientImpl.toPayload(key, values), handler);
        return this;
    }

    @Override
    public RedisClient lpush(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.LPUSH, RedisClientImpl.toPayload(key, value), handler);
        return this;
    }

    @Override
    public RedisClient lpushx(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.LPUSHX, RedisClientImpl.toPayload(key, value), handler);
        return this;
    }

    @Override
    public RedisClient lrange(String key, long from, long to, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.LRANGE, RedisClientImpl.toPayload(key, from, to), handler);
        return this;
    }

    @Override
    public RedisClient lrem(String key, long count, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.LREM, RedisClientImpl.toPayload(key, count, value), handler);
        return this;
    }

    @Override
    public RedisClient lset(String key, long index, String value, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.LSET, RedisClientImpl.toPayload(key, index, value), handler);
        return this;
    }

    @Override
    public RedisClient ltrim(String key, long from, long to, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.LTRIM, RedisClientImpl.toPayload(key, from, to), handler);
        return this;
    }

    @Override
    public RedisClient mget(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.MGET, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient mgetMany(List<String> keys, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.MGET, RedisClientImpl.toPayload(keys), handler);
        return this;
    }

    @Override
    public RedisClient migrate(String host, int port, String key, int destdb, long timeout, MigrateOptions options, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.MIGRATE, RedisClientImpl.toPayload(host, port, key, destdb, timeout, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient monitor(Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.MONITOR, null, handler);
        return this;
    }

    @Override
    public RedisClient move(String key, int destdb, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.MOVE, RedisClientImpl.toPayload(key, destdb), handler);
        return this;
    }

    @Override
    public RedisClient mset(JsonObject keyvals, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.MSET, RedisClientImpl.toPayload(keyvals), handler);
        return this;
    }

    @Override
    public RedisClient msetnx(JsonObject keyvals, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.MSETNX, RedisClientImpl.toPayload(keyvals), handler);
        return this;
    }

    @Override
    public RedisClient object(String key, ObjectCmd cmd, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.OBJECT, RedisClientImpl.toPayload(cmd.name(), key), handler);
        return this;
    }

    @Override
    public RedisClient persist(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.PERSIST, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient pexpire(String key, long millis, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.PEXPIRE, RedisClientImpl.toPayload(key, millis), handler);
        return this;
    }

    @Override
    public RedisClient pexpireat(String key, long millis, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.PEXPIREAT, RedisClientImpl.toPayload(key, millis), handler);
        return this;
    }

    @Override
    public RedisClient pfadd(String key, String element, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.PFADD, RedisClientImpl.toPayload(key, element), handler);
        return this;
    }

    @Override
    public RedisClient pfaddMany(String key, List<String> elements, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.PFADD, RedisClientImpl.toPayload(key, elements), handler);
        return this;
    }

    @Override
    public RedisClient pfcount(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.PFCOUNT, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient pfcountMany(List<String> key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.PFCOUNT, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient pfmerge(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.PFMERGE, RedisClientImpl.toPayload(destkey, keys), handler);
        return this;
    }

    @Override
    public RedisClient ping(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.PING, null, handler);
        return this;
    }

    @Override
    public RedisClient psetex(String key, long millis, String value, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.PSETEX, RedisClientImpl.toPayload(key, millis, value), handler);
        return this;
    }

    @Override
    public RedisClient psubscribe(String pattern, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.PSUBSCRIBE, RedisClientImpl.toPayload(pattern), handler);
        return this;
    }

    @Override
    public RedisClient psubscribeMany(List<String> patterns, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.PSUBSCRIBE, RedisClientImpl.toPayload(patterns), handler);
        return this;
    }

    @Override
    public RedisClient pubsubChannels(String pattern, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.PUBSUB, RedisClientImpl.toPayload("CHANNELS", pattern == null || "".equals(pattern) ? null : pattern), handler);
        return this;
    }

    @Override
    public RedisClient pubsubNumsub(List<String> channels, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.PUBSUB, RedisClientImpl.toPayload("NUMSUB", channels), handler);
        return this;
    }

    @Override
    public RedisClient pubsubNumpat(Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.PUBSUB, RedisClientImpl.toPayload("NUMPAT"), handler);
        return this;
    }

    @Override
    public RedisClient pttl(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.PTTL, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient publish(String channel, String message, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.PUBLISH, RedisClientImpl.toPayload(channel, message), handler);
        return this;
    }

    @Override
    public RedisClient punsubscribe(List<String> patterns, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.PUNSUBSCRIBE, RedisClientImpl.toPayload(patterns), handler);
        return this;
    }

    @Override
    public RedisClient randomkey(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.RANDOMKEY, null, handler);
        return this;
    }

    @Override
    public RedisClient rename(String key, String newkey, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.RENAME, RedisClientImpl.toPayload(key, newkey), handler);
        return this;
    }

    @Override
    public RedisClient renamenx(String key, String newkey, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.RENAMENX, RedisClientImpl.toPayload(key, newkey), handler);
        return this;
    }

    @Override
    public RedisClient restore(String key, long millis, String serialized, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.RESTORE, RedisClientImpl.toPayload(key, millis, RedisEncoding.decode(serialized)), handler);
        return this;
    }

    @Override
    public RedisClient role(Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.ROLE, null, handler);
        return this;
    }

    @Override
    public RedisClient rpop(String key, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.RPOP, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient rpoplpush(String key, String destkey, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.RPOPLPUSH, RedisClientImpl.toPayload(key, destkey), handler);
        return this;
    }

    @Override
    public RedisClient rpushMany(String key, List<String> values, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.RPUSH, RedisClientImpl.toPayload(key, values), handler);
        return this;
    }

    @Override
    public RedisClient rpush(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.RPUSH, RedisClientImpl.toPayload(key, value), handler);
        return this;
    }

    @Override
    public RedisClient rpushx(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.RPUSHX, RedisClientImpl.toPayload(key, value), handler);
        return this;
    }

    @Override
    public RedisClient sadd(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.SADD, RedisClientImpl.toPayload(key, member), handler);
        return this;
    }

    @Override
    public RedisClient saddMany(String key, List<String> members, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.SADD, RedisClientImpl.toPayload(key, members), handler);
        return this;
    }

    @Override
    public RedisClient save(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.SAVE, null, handler);
        return this;
    }

    @Override
    public RedisClient scard(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.SCARD, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient scriptExists(String script, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SCRIPT, RedisClientImpl.toPayload("EXISTS", script), handler);
        return this;
    }

    @Override
    public RedisClient scriptExistsMany(List<String> scripts, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SCRIPT, RedisClientImpl.toPayload("EXISTS", scripts), handler);
        return this;
    }

    @Override
    public RedisClient scriptFlush(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.SCRIPT, RedisClientImpl.toPayload("FLUSH"), handler);
        return this;
    }

    @Override
    public RedisClient scriptKill(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.SCRIPT, RedisClientImpl.toPayload("KILL"), handler);
        return this;
    }

    @Override
    public RedisClient scriptLoad(String script, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.SCRIPT, RedisClientImpl.toPayload("LOAD", script), handler);
        return this;
    }

    @Override
    public RedisClient sdiff(String key, List<String> cmpkeys, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SDIFF, RedisClientImpl.toPayload(key, cmpkeys), handler);
        return this;
    }

    @Override
    public RedisClient sdiffstore(String destkey, String key, List<String> cmpkeys, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.SDIFFSTORE, RedisClientImpl.toPayload(destkey, key, cmpkeys), handler);
        return this;
    }

    @Override
    public RedisClient select(int dbindex, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.SELECT, RedisClientImpl.toPayload(dbindex), handler);
        return this;
    }

    @Override
    public RedisClient set(String key, String value, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.SET, RedisClientImpl.toPayload(key, value), handler);
        return this;
    }

    @Override
    public RedisClient setWithOptions(String key, String value, SetOptions options, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.SET, RedisClientImpl.toPayload(key, value, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient setBinary(String key, Buffer value, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.SET, RedisClientImpl.toPayload(key, value), handler);
        return this;
    }

    @Override
    public RedisClient setBinaryWithOptions(String key, Buffer value, SetOptions options, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.SET, RedisClientImpl.toPayload(key, value, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient setbit(String key, long offset, int bit, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.SETBIT, RedisClientImpl.toPayload(key, offset, bit), handler);
        return this;
    }

    @Override
    public RedisClient setex(String key, long seconds, String value, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.SETEX, RedisClientImpl.toPayload(key, seconds, value), handler);
        return this;
    }

    @Override
    public RedisClient setnx(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.SETNX, RedisClientImpl.toPayload(key, value), handler);
        return this;
    }

    @Override
    public RedisClient setrange(String key, int offset, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.SETRANGE, RedisClientImpl.toPayload(key, offset, value), handler);
        return this;
    }

    @Override
    public RedisClient sinter(List<String> keys, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SINTER, RedisClientImpl.toPayload(keys), handler);
        return this;
    }

    @Override
    public RedisClient sinterstore(String destkey, List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.SINTERSTORE, RedisClientImpl.toPayload(destkey, keys), handler);
        return this;
    }

    @Override
    public RedisClient sismember(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.SISMEMBER, RedisClientImpl.toPayload(key, member), handler);
        return this;
    }

    @Override
    public RedisClient slaveof(String host, int port, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.SLAVEOF, RedisClientImpl.toPayload(host, port), handler);
        return this;
    }

    @Override
    public RedisClient slaveofNoone(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.SLAVEOF, RedisClientImpl.toPayload("NO", "ONE"), handler);
        return this;
    }

    @Override
    public RedisClient slowlogGet(int limit, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SLOWLOG, RedisClientImpl.toPayload("GET", limit < 0 ? null : Integer.valueOf(limit)), handler);
        return this;
    }

    @Override
    public RedisClient slowlogLen(Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.SLOWLOG, RedisClientImpl.toPayload("LEN"), handler);
        return this;
    }

    @Override
    public RedisClient slowlogReset(Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.SLOWLOG, RedisClientImpl.toPayload("RESET"), handler);
        return this;
    }

    @Override
    public RedisClient smembers(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SMEMBERS, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient smove(String key, String destkey, String member, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.SMOVE, RedisClientImpl.toPayload(key, destkey, member), handler);
        return this;
    }

    @Override
    public RedisClient sort(String key, SortOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SORT, RedisClientImpl.toPayload(key, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient spop(String key, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.SPOP, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient spopMany(String key, int count, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SPOP, RedisClientImpl.toPayload(key, count), handler);
        return this;
    }

    @Override
    public RedisClient srandmember(String key, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.SRANDMEMBER, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient srandmemberCount(String key, int count, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SRANDMEMBER, RedisClientImpl.toPayload(key, count), handler);
        return this;
    }

    @Override
    public RedisClient srem(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.SREM, RedisClientImpl.toPayload(key, member), handler);
        return this;
    }

    @Override
    public RedisClient sremMany(String key, List<String> members, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.SREM, RedisClientImpl.toPayload(key, members), handler);
        return this;
    }

    @Override
    public RedisClient strlen(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.STRLEN, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient subscribe(String channel, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SUBSCRIBE, RedisClientImpl.toPayload(channel), handler);
        return this;
    }

    @Override
    public RedisClient subscribeMany(List<String> channels, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SUBSCRIBE, RedisClientImpl.toPayload(channels), handler);
        return this;
    }

    @Override
    public RedisClient sunion(List<String> keys, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SUNION, RedisClientImpl.toPayload(keys), handler);
        return this;
    }

    @Override
    public RedisClient sunionstore(String destkey, List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.SUNIONSTORE, RedisClientImpl.toPayload(destkey, keys), handler);
        return this;
    }

    @Override
    public RedisClient sync(Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.SYNC, null, handler);
        return this;
    }

    @Override
    public RedisClient time(Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.TIME, null, handler);
        return this;
    }

    @Override
    public RedisTransaction transaction() {
        return new RedisTransactionImpl();
    }

    @Override
    public RedisClient ttl(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.TTL, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient type(String key, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.TYPE, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient unsubscribe(List<String> channels, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.UNSUBSCRIBE, RedisClientImpl.toPayload(channels), handler);
        return this;
    }

    @Override
    public RedisClient wait(long numSlaves, long timeout, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.WAIT, RedisClientImpl.toPayload(numSlaves, timeout), handler);
        return this;
    }

    @Override
    public RedisClient zadd(String key, double score, String member, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.ZADD, RedisClientImpl.toPayload(key, score, member), handler);
        return this;
    }

    /*
     * Exception decompiling
     */
    @Override
    public RedisClient zaddMany(String key, Map<String, Double> members, Handler<AsyncResult<Long>> handler) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public RedisClient zcard(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.ZCARD, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient zcount(String key, double min, double max, Handler<AsyncResult<Long>> handler) {
        String minVal = min == Double.NEGATIVE_INFINITY ? "-inf" : String.valueOf(min);
        String maxVal = max == Double.POSITIVE_INFINITY ? "+inf" : String.valueOf(max);
        this.sendLong(Command.ZCOUNT, RedisClientImpl.toPayload(key, minVal, maxVal), handler);
        return this;
    }

    @Override
    public RedisClient zincrby(String key, double increment, String member, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.ZINCRBY, RedisClientImpl.toPayload(key, increment, member), handler);
        return this;
    }

    @Override
    public RedisClient zinterstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.ZINTERSTORE, RedisClientImpl.toPayload(destkey, sets.size(), sets, options != null ? options.name() : null), handler);
        return this;
    }

    @Override
    public RedisClient zinterstoreWeighed(String destkey, Map<String, Double> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.ZINTERSTORE, RedisClientImpl.toPayload(destkey, sets.size(), sets.keySet(), "WEIGHTS", sets.values(), options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient zlexcount(String key, String min, String max, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.ZLEXCOUNT, RedisClientImpl.toPayload(key, min, max), handler);
        return this;
    }

    @Override
    public RedisClient zrange(String key, long start, long stop, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.ZRANGE, RedisClientImpl.toPayload(key, start, stop), handler);
        return this;
    }

    @Override
    public RedisClient zrangeWithOptions(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.ZRANGE, RedisClientImpl.toPayload(key, start, stop, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient zrangebylex(String key, String min, String max, LimitOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.ZRANGEBYLEX, RedisClientImpl.toPayload(key, min, max, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient zrangebyscore(String key, String min, String max, RangeLimitOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.ZRANGEBYSCORE, RedisClientImpl.toPayload(key, min, max, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient zrank(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.ZRANK, RedisClientImpl.toPayload(key, member), handler);
        return this;
    }

    @Override
    public RedisClient zrem(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.ZREM, RedisClientImpl.toPayload(key, member), handler);
        return this;
    }

    @Override
    public RedisClient zremMany(String key, List<String> members, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.ZREM, RedisClientImpl.toPayload(key, members), handler);
        return this;
    }

    @Override
    public RedisClient zremrangebylex(String key, String min, String max, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.ZREMRANGEBYLEX, RedisClientImpl.toPayload(key, min, max), handler);
        return this;
    }

    @Override
    public RedisClient zremrangebyrank(String key, long start, long stop, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.ZREMRANGEBYRANK, RedisClientImpl.toPayload(key, start, stop), handler);
        return this;
    }

    @Override
    public RedisClient zremrangebyscore(String key, String min, String max, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.ZREMRANGEBYSCORE, RedisClientImpl.toPayload(key, min, max), handler);
        return this;
    }

    @Override
    public RedisClient zrevrange(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.ZREVRANGE, RedisClientImpl.toPayload(key, start, stop, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient zrevrangebylex(String key, String max, String min, LimitOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.ZREVRANGEBYLEX, RedisClientImpl.toPayload(key, max, min, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient zrevrangebyscore(String key, String max, String min, RangeLimitOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.ZREVRANGEBYSCORE, RedisClientImpl.toPayload(key, max, min, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient zrevrank(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.ZREVRANK, RedisClientImpl.toPayload(key, member), handler);
        return this;
    }

    @Override
    public RedisClient zscore(String key, String member, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.ZSCORE, RedisClientImpl.toPayload(key, member), handler);
        return this;
    }

    @Override
    public RedisClient zunionstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.ZUNIONSTORE, RedisClientImpl.toPayload(destkey, sets.size(), sets, options != null ? options.name() : null), handler);
        return this;
    }

    @Override
    public RedisClient zunionstoreWeighed(String destkey, Map<String, Double> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.ZUNIONSTORE, RedisClientImpl.toPayload(destkey, sets.size(), sets.keySet(), "WEIGHTS", sets.values(), options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient scan(String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SCAN, RedisClientImpl.toPayload(cursor, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient sscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SSCAN, RedisClientImpl.toPayload(key, cursor, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient hscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.HSCAN, RedisClientImpl.toPayload(key, cursor, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient zscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.ZSCAN, RedisClientImpl.toPayload(key, cursor, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient geoadd(String key, double longitude, double latitude, String member, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.GEOADD, RedisClientImpl.toPayload(key, longitude, latitude, member), handler);
        return this;
    }

    @Override
    public RedisClient geoaddMany(String key, List<GeoMember> members, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.GEOADD, RedisClientImpl.toPayload(key, members), handler);
        return this;
    }

    @Override
    public RedisClient geohash(String key, String member, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.GEOHASH, RedisClientImpl.toPayload(key, member), handler);
        return this;
    }

    @Override
    public RedisClient geohashMany(String key, List<String> members, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.GEOHASH, RedisClientImpl.toPayload(key, members), handler);
        return this;
    }

    @Override
    public RedisClient geopos(String key, String member, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.GEOPOS, RedisClientImpl.toPayload(key, member), handler);
        return this;
    }

    @Override
    public RedisClient geoposMany(String key, List<String> members, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.GEOPOS, RedisClientImpl.toPayload(key, members), handler);
        return this;
    }

    @Override
    public RedisClient geodist(String key, String member1, String member2, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.GEODIST, RedisClientImpl.toPayload(key, member1, member2), handler);
        return this;
    }

    @Override
    public RedisClient geodistWithUnit(String key, String member1, String member2, GeoUnit unit, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.GEODIST, RedisClientImpl.toPayload(new Object[]{key, member1, member2, unit}), handler);
        return this;
    }

    @Override
    public RedisClient georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.GEORADIUS, RedisClientImpl.toPayload(new Object[]{key, longitude, latitude, radius, unit}), handler);
        return this;
    }

    @Override
    public RedisClient georadiusWithOptions(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.GEORADIUS, RedisClientImpl.toPayload(new Object[]{key, longitude, latitude, radius, unit, options != null ? options.toJsonArray() : null}), handler);
        return this;
    }

    @Override
    public RedisClient georadiusbymember(String key, String member, double radius, GeoUnit unit, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.GEORADIUSBYMEMBER, RedisClientImpl.toPayload(new Object[]{key, member, radius, unit}), handler);
        return this;
    }

    @Override
    public RedisClient georadiusbymemberWithOptions(String key, String member, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.GEORADIUSBYMEMBER, RedisClientImpl.toPayload(new Object[]{key, member, radius, unit, options != null ? options.toJsonArray() : null}), handler);
        return this;
    }

    @Override
    public RedisClient clientReply(ClientReplyOptions options, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.CLIENT, RedisClientImpl.toPayload(new Object[]{"REPLY", options}), handler);
        return this;
    }

    @Override
    public RedisClient hstrlen(String key, String field, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.HSTRLEN, RedisClientImpl.toPayload(key, field), handler);
        return this;
    }

    @Override
    public RedisClient touch(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.TOUCH, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient touchMany(List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.TOUCH, keys, handler);
        return this;
    }

    @Override
    public RedisClient scriptDebug(ScriptDebugOptions scriptDebugOptions, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.SCRIPT, RedisClientImpl.toPayload(new Object[]{"DEBUG", scriptDebugOptions}), handler);
        return this;
    }

    @Override
    public RedisClient bitfield(String key, BitFieldOptions bitFieldOptions, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.BITFIELD, RedisClientImpl.toPayload(key, bitFieldOptions != null ? bitFieldOptions.toJsonArray() : null), handler);
        return this;
    }

    @Override
    public RedisClient bitfieldWithOverflow(String key, BitFieldOptions bitFieldOptions, BitFieldOverflowOptions overflow, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.BITFIELD, RedisClientImpl.toPayload(new Object[]{key, bitFieldOptions != null ? bitFieldOptions.toJsonArray() : null, overflow}), handler);
        return this;
    }

    @Override
    public RedisClient unlink(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.UNLINK, RedisClientImpl.toPayload(key), handler);
        return this;
    }

    @Override
    public RedisClient unlinkMany(List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.UNLINK, RedisClientImpl.toPayload(keys), handler);
        return this;
    }

    @Override
    public RedisClient swapdb(int index1, int index2, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.SWAPDB, RedisClientImpl.toPayload(index1, index2), handler);
        return this;
    }

    public class RedisTransactionImpl
    implements RedisTransaction {
        @Override
        public void close(Handler<AsyncResult<Void>> handler) {
            RedisClientImpl.this.close(handler);
        }

        @Override
        public RedisTransaction append(String key, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.APPEND, RedisClientImpl.toPayload(new Object[]{key, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction auth(String password, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.AUTH, RedisClientImpl.toPayload(new Object[]{password}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction bgrewriteaof(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.BGREWRITEAOF, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction bgsave(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.BGSAVE, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction bitcount(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.BITCOUNT, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction bitcountRange(String key, long start, long end, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.BITCOUNT, RedisClientImpl.toPayload(new Object[]{key, start, end}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction bitop(BitOperation operation, String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.BITOP, RedisClientImpl.toPayload(new Object[]{operation.name(), destkey, keys}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction bitpos(String key, int bit, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.BITPOS, RedisClientImpl.toPayload(new Object[]{key, bit}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction bitposFrom(String key, int bit, int start, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.BITPOS, RedisClientImpl.toPayload(new Object[]{key, bit, start}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction bitposRange(String key, int bit, int start, int stop, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.BITPOS, RedisClientImpl.toPayload(new Object[]{key, bit, start, stop}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction blpop(String key, int seconds, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.BLPOP, RedisClientImpl.toPayload(new Object[]{key, seconds}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction blpopMany(List<String> keys, int seconds, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.BLPOP, RedisClientImpl.toPayload(new Object[]{keys, seconds}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction brpop(String key, int seconds, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.BRPOP, RedisClientImpl.toPayload(new Object[]{key, seconds}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction brpopMany(List<String> keys, int seconds, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.BRPOP, RedisClientImpl.toPayload(new Object[]{keys, seconds}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction brpoplpush(String key, String destkey, int seconds, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.BRPOPLPUSH, RedisClientImpl.toPayload(new Object[]{key, destkey, seconds}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction clientKill(KillFilter filter, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CLIENT, RedisClientImpl.toPayload(new Object[]{"KILL", filter.toJsonArray().getList()}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction clientList(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CLIENT, RedisClientImpl.toPayload(new Object[]{"LIST"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction clientGetname(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CLIENT, RedisClientImpl.toPayload(new Object[]{"GETNAME"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction clientPause(long millis, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CLIENT, RedisClientImpl.toPayload(new Object[]{"PAUSE", millis}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction clientSetname(String name, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CLIENT, RedisClientImpl.toPayload(new Object[]{"SETNAME", name}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction clusterAddslots(List<String> slots, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CLUSTER, RedisClientImpl.toPayload(new Object[]{"ADDSLOTS"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction clusterCountFailureReports(String nodeId, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CLUSTER, RedisClientImpl.toPayload(new Object[]{"COUNT-FAILURE-REPORTS", nodeId}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction clusterCountkeysinslot(long slot, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CLUSTER, RedisClientImpl.toPayload(new Object[]{"COUNTKEYSINSLOT", slot}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction clusterDelslots(long slot, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CLUSTER, RedisClientImpl.toPayload(new Object[]{"DELSLOTS", slot}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction clusterDelslotsMany(List<String> slots, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CLUSTER, RedisClientImpl.toPayload(new Object[]{"DELSLOTS", slots}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction clusterFailover(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CLUSTER, RedisClientImpl.toPayload(new Object[]{"FAILOVER"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction clusterFailOverWithOptions(FailoverOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CLUSTER, RedisClientImpl.toPayload(new Object[]{"FAILOVER", options}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction clusterForget(String nodeId, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CLUSTER, RedisClientImpl.toPayload(new Object[]{"FORGET", nodeId}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction clusterGetkeysinslot(long slot, long count, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CLUSTER, RedisClientImpl.toPayload(new Object[]{"GETKEYSINSLOT", slot, count}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction clusterInfo(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CLUSTER, RedisClientImpl.toPayload(new Object[]{"INFO"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction clusterKeyslot(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CLUSTER, RedisClientImpl.toPayload(new Object[]{"KEYSLOT", key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction clusterMeet(String ip, long port, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CLUSTER, RedisClientImpl.toPayload(new Object[]{"MEET", ip, port}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction clusterNodes(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CLUSTER, RedisClientImpl.toPayload(new Object[]{"NODES"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction clusterReplicate(String nodeId, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CLUSTER, RedisClientImpl.toPayload(new Object[]{"REPLICATE", nodeId}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction clusterReset(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CLUSTER, RedisClientImpl.toPayload(new Object[]{"RESET"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction clusterResetWithOptions(ResetOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CLUSTER, RedisClientImpl.toPayload(new Object[]{"RESET", options}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction clusterSaveconfig(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CLUSTER, RedisClientImpl.toPayload(new Object[]{"SAVECONFIG"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction clusterSetConfigEpoch(long epoch, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CLUSTER, RedisClientImpl.toPayload(new Object[]{"SET-CONFIG-EPOCH", epoch}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction clusterSetslot(long slot, SlotCmd subcommand, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CLUSTER, RedisClientImpl.toPayload(new Object[]{"SETSLOT", slot, subcommand}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction clusterSetslotWithNode(long slot, SlotCmd subcommand, String nodeId, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CLUSTER, RedisClientImpl.toPayload(new Object[]{"SETSLOT", slot, subcommand, nodeId}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction clusterSlaves(String nodeId, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CLUSTER, RedisClientImpl.toPayload(new Object[]{"SLAVES", nodeId}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction clusterSlots(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CLUSTER, RedisClientImpl.toPayload(new Object[]{"SLOTS"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction command(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.COMMAND, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction commandCount(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.COMMAND, RedisClientImpl.toPayload(new Object[]{"COUNT"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction commandGetkeys(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.COMMAND, RedisClientImpl.toPayload(new Object[]{"GETKEYS"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction commandInfo(List<String> commands, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.COMMAND, RedisClientImpl.toPayload(new Object[]{"INFO", commands}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction configGet(String parameter, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CONFIG, RedisClientImpl.toPayload(new Object[]{"GET", parameter}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction configRewrite(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CONFIG, RedisClientImpl.toPayload(new Object[]{"REWRITE"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction configSet(String parameter, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CONFIG, RedisClientImpl.toPayload(new Object[]{"SET", parameter, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction configResetstat(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.CONFIG, RedisClientImpl.toPayload(new Object[]{"RESETSTAT"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction dbsize(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.DBSIZE, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction debugObject(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.DEBUG, RedisClientImpl.toPayload(new Object[]{"OBJECT", key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction debugSegfault(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.DEBUG, RedisClientImpl.toPayload(new Object[]{"SEGFAULT"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction decr(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.DECR, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction decrby(String key, long decrement, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.DECRBY, RedisClientImpl.toPayload(new Object[]{key, decrement}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction del(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.DEL, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction delMany(List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.DEL, RedisClientImpl.toPayload(new Object[]{keys}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction discard(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.DISCARD, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction dump(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.DUMP, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)dump -> {
                if (dump.failed()) {
                    handler.handle(dump);
                } else {
                    handler.handle((Object)Future.succeededFuture((Object)RedisEncoding.encode((String)dump.result())));
                }
            });
            return this;
        }

        @Override
        public RedisTransaction echo(String message, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.ECHO, RedisClientImpl.toPayload(new Object[]{message}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction eval(String script, List<String> keys, List<String> args, Handler<AsyncResult<String>> handler) {
            keys = keys != null ? keys : Collections.emptyList();
            args = args != null ? args : Collections.emptyList();
            RedisClientImpl.this.sendString(Command.EVAL, RedisClientImpl.toPayload(new Object[]{script, keys.size(), keys, args}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction evalsha(String sha1, List<String> keys, List<String> args, Handler<AsyncResult<String>> handler) {
            keys = keys != null ? keys : Collections.emptyList();
            args = args != null ? args : Collections.emptyList();
            RedisClientImpl.this.sendString(Command.EVALSHA, RedisClientImpl.toPayload(new Object[]{sha1, keys.size(), keys, args}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction exec(Handler<AsyncResult<JsonArray>> handler) {
            RedisClientImpl.this.sendJsonArray(Command.EXEC, null, (Handler<AsyncResult<JsonArray>>)handler);
            return this;
        }

        @Override
        public RedisTransaction exists(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.EXISTS, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction existsMany(List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.EXISTS, RedisClientImpl.toPayload(new Object[]{keys}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction expire(String key, int seconds, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.EXPIRE, RedisClientImpl.toPayload(new Object[]{key, seconds}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction expireat(String key, long seconds, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.EXPIREAT, RedisClientImpl.toPayload(new Object[]{key, seconds}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction flushall(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.FLUSHALL, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction flushdb(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.FLUSHDB, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction get(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.GET, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction getBinary(String key, Handler<AsyncResult<Buffer>> handler) {
            RedisClientImpl.this.sendBuffer(Command.GET, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<Buffer>>)handler);
            return this;
        }

        @Override
        public RedisTransaction getbit(String key, long offset, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.GETBIT, RedisClientImpl.toPayload(new Object[]{key, offset}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction getrange(String key, long start, long end, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.GETRANGE, RedisClientImpl.toPayload(new Object[]{key, start, end}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction getset(String key, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.GETSET, RedisClientImpl.toPayload(new Object[]{key, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction hdel(String key, String field, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.HDEL, RedisClientImpl.toPayload(new Object[]{key, field}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction hdelMany(String key, List<String> fields, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.HDEL, RedisClientImpl.toPayload(new Object[]{key, fields}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction hexists(String key, String field, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.HEXISTS, RedisClientImpl.toPayload(new Object[]{key, field}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction hget(String key, String field, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.HGET, RedisClientImpl.toPayload(new Object[]{key, field}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction hgetall(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.HGETALL, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction hincrby(String key, String field, long increment, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.HINCRBY, RedisClientImpl.toPayload(new Object[]{key, field, increment}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction hincrbyfloat(String key, String field, double increment, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.HINCRBYFLOAT, RedisClientImpl.toPayload(new Object[]{key, field, increment}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction hkeys(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.HKEYS, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction hlen(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.HLEN, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction hmget(String key, List<String> fields, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.HMGET, RedisClientImpl.toPayload(new Object[]{key, fields}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction hmset(String key, JsonObject values, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.HMSET, RedisClientImpl.toPayload(new Object[]{key, values}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction hset(String key, String field, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.HSET, RedisClientImpl.toPayload(new Object[]{key, field, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction hsetnx(String key, String field, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.HSETNX, RedisClientImpl.toPayload(new Object[]{key, field, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction hvals(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.HVALS, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction incr(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.INCR, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction incrby(String key, long increment, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.INCRBY, RedisClientImpl.toPayload(new Object[]{key, increment}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction incrbyfloat(String key, double increment, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.INCRBYFLOAT, RedisClientImpl.toPayload(new Object[]{key, increment}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction info(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.INFO, Collections.emptyList(), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction infoSection(String section, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.INFO, RedisClientImpl.toPayload(new Object[]{section}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction keys(String pattern, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.KEYS, RedisClientImpl.toPayload(new Object[]{pattern}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction lastsave(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.LASTSAVE, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction lindex(String key, int index, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.LINDEX, RedisClientImpl.toPayload(new Object[]{key, index}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction linsert(String key, InsertOptions option, String pivot, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.LINSERT, RedisClientImpl.toPayload(new Object[]{key, option.name(), pivot, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction llen(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.LLEN, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction lpop(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.LPOP, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction lpushMany(String key, List<String> values, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.LPUSH, RedisClientImpl.toPayload(new Object[]{key, values}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction lpush(String key, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.LPUSH, RedisClientImpl.toPayload(new Object[]{key, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction lpushx(String key, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.LPUSHX, RedisClientImpl.toPayload(new Object[]{key, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction lrange(String key, long from, long to, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.LRANGE, RedisClientImpl.toPayload(new Object[]{key, from, to}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction lrem(String key, long count, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.LREM, RedisClientImpl.toPayload(new Object[]{key, count, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction lset(String key, long index, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.LSET, RedisClientImpl.toPayload(new Object[]{key, index, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction ltrim(String key, long from, long to, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.LTRIM, RedisClientImpl.toPayload(new Object[]{key, from, to}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction mget(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.MGET, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction mgetMany(List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.MGET, RedisClientImpl.toPayload(new Object[]{keys}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction migrate(String host, int port, String key, int destdb, long timeout, MigrateOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.MIGRATE, RedisClientImpl.toPayload(new Object[]{host, port, key, destdb, timeout, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction monitor(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.MONITOR, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction move(String key, int destdb, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.MOVE, RedisClientImpl.toPayload(new Object[]{key, destdb}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction mset(JsonObject keyvals, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.MSET, RedisClientImpl.toPayload(new Object[]{keyvals}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction msetnx(JsonObject keyvals, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.MSETNX, RedisClientImpl.toPayload(new Object[]{keyvals}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction multi(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.MULTI, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction object(String key, ObjectCmd cmd, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.OBJECT, RedisClientImpl.toPayload(new Object[]{cmd.name(), key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction persist(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.PERSIST, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction pexpire(String key, long millis, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.PEXPIRE, RedisClientImpl.toPayload(new Object[]{key, millis}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction pexpireat(String key, long millis, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.PEXPIREAT, RedisClientImpl.toPayload(new Object[]{key, millis}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction pfadd(String key, String element, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.PFADD, RedisClientImpl.toPayload(new Object[]{key, element}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction pfaddMany(String key, List<String> elements, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.PFADD, RedisClientImpl.toPayload(new Object[]{key, elements}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction pfcount(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.PFCOUNT, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction pfcountMany(List<String> key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.PFCOUNT, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction pfmerge(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.PFMERGE, RedisClientImpl.toPayload(new Object[]{destkey, keys}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction ping(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.PING, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction psetex(String key, long millis, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.PSETEX, RedisClientImpl.toPayload(new Object[]{key, millis, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction psubscribe(String pattern, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.PSUBSCRIBE, RedisClientImpl.toPayload(new Object[]{pattern}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction psubscribeMany(List<String> patterns, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.PSUBSCRIBE, RedisClientImpl.toPayload(new Object[]{patterns}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction pubsubChannels(String pattern, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.PUBSUB, RedisClientImpl.toPayload(new Object[]{"CHANNELS", pattern == null || "".equals(pattern) ? null : pattern}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction pubsubNumsub(List<String> channels, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.PUBSUB, RedisClientImpl.toPayload(new Object[]{"NUMSUB", channels}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction pubsubNumpat(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.PUBSUB, RedisClientImpl.toPayload(new Object[]{"NUMPAT"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction pttl(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.PTTL, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction publish(String channel, String message, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.PUBLISH, RedisClientImpl.toPayload(new Object[]{channel, message}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction punsubscribe(List<String> patterns, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.PUNSUBSCRIBE, RedisClientImpl.toPayload(new Object[]{patterns}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction randomkey(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.RANDOMKEY, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction rename(String key, String newkey, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.RENAME, RedisClientImpl.toPayload(new Object[]{key, newkey}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction renamenx(String key, String newkey, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.RENAMENX, RedisClientImpl.toPayload(new Object[]{key, newkey}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction restore(String key, long millis, String serialized, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.RESTORE, RedisClientImpl.toPayload(new Object[]{key, millis, RedisEncoding.decode(serialized)}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction role(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.ROLE, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction rpop(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.RPOP, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction rpoplpush(String key, String destkey, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.RPOPLPUSH, RedisClientImpl.toPayload(new Object[]{key, destkey}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction rpushMany(String key, List<String> values, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.RPUSH, RedisClientImpl.toPayload(new Object[]{key, values}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction rpush(String key, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.RPUSH, RedisClientImpl.toPayload(new Object[]{key, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction rpushx(String key, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.RPUSHX, RedisClientImpl.toPayload(new Object[]{key, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction sadd(String key, String member, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SADD, RedisClientImpl.toPayload(new Object[]{key, member}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction saddMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SADD, RedisClientImpl.toPayload(new Object[]{key, members}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction save(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SAVE, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction scard(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SCARD, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction scriptExists(String script, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SCRIPT, RedisClientImpl.toPayload(new Object[]{"EXISTS", script}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction scriptExistsMany(List<String> scripts, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SCRIPT, RedisClientImpl.toPayload(new Object[]{"EXISTS", scripts}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction scriptFlush(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SCRIPT, RedisClientImpl.toPayload(new Object[]{"FLUSH"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction scriptKill(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SCRIPT, RedisClientImpl.toPayload(new Object[]{"KILL"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction scriptLoad(String script, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SCRIPT, RedisClientImpl.toPayload(new Object[]{"LOAD", script}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction sdiff(String key, List<String> cmpkeys, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SDIFF, RedisClientImpl.toPayload(new Object[]{key, cmpkeys}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction sdiffstore(String destkey, String key, List<String> cmpkeys, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SDIFFSTORE, RedisClientImpl.toPayload(new Object[]{destkey, key, cmpkeys}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction select(int dbindex, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SELECT, RedisClientImpl.toPayload(new Object[]{dbindex}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction set(String key, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SET, RedisClientImpl.toPayload(new Object[]{key, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction setWithOptions(String key, String value, SetOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SET, RedisClientImpl.toPayload(new Object[]{key, value, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction setBinary(String key, Buffer value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SET, RedisClientImpl.toPayload(new Object[]{key, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction setBinaryWithOptions(String key, Buffer value, SetOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SET, RedisClientImpl.toPayload(new Object[]{key, value, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction setbit(String key, long offset, int bit, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SETBIT, RedisClientImpl.toPayload(new Object[]{key, offset, bit}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction setex(String key, long seconds, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SETEX, RedisClientImpl.toPayload(new Object[]{key, seconds, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction setnx(String key, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SETNX, RedisClientImpl.toPayload(new Object[]{key, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction setrange(String key, int offset, String value, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SETRANGE, RedisClientImpl.toPayload(new Object[]{key, offset, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction sinter(List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SINTER, RedisClientImpl.toPayload(new Object[]{keys}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction sinterstore(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SINTERSTORE, RedisClientImpl.toPayload(new Object[]{destkey, keys}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction sismember(String key, String member, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SISMEMBER, RedisClientImpl.toPayload(new Object[]{key, member}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction slaveof(String host, int port, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SLAVEOF, RedisClientImpl.toPayload(new Object[]{host, port}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction slaveofNoone(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SLAVEOF, RedisClientImpl.toPayload(new Object[]{"NO", "ONE"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction slowlogGet(int limit, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SLOWLOG, RedisClientImpl.toPayload(new Object[]{"GET", limit < 0 ? null : Integer.valueOf(limit)}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction slowlogLen(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SLOWLOG, RedisClientImpl.toPayload(new Object[]{"LEN"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction slowlogReset(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SLOWLOG, RedisClientImpl.toPayload(new Object[]{"RESET"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction smembers(String key, Handler<AsyncResult<JsonArray>> handler) {
            RedisClientImpl.this.sendJsonArray(Command.SMEMBERS, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<JsonArray>>)handler);
            return this;
        }

        @Override
        public RedisTransaction smove(String key, String destkey, String member, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SMOVE, RedisClientImpl.toPayload(new Object[]{key, destkey, member}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction sort(String key, SortOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SORT, RedisClientImpl.toPayload(new Object[]{key, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction spop(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SPOP, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction spopMany(String key, int count, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SPOP, RedisClientImpl.toPayload(new Object[]{key, count}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction srandmember(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SRANDMEMBER, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction srandmemberCount(String key, int count, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SRANDMEMBER, RedisClientImpl.toPayload(new Object[]{key, count}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction srem(String key, String member, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SREM, RedisClientImpl.toPayload(new Object[]{key, member}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction sremMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SREM, RedisClientImpl.toPayload(new Object[]{key, members}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction strlen(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.STRLEN, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction subscribe(String channel, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SUBSCRIBE, RedisClientImpl.toPayload(new Object[]{channel}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction subscribeMany(List<String> channels, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SUBSCRIBE, RedisClientImpl.toPayload(new Object[]{channels}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction sunion(List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SUNION, RedisClientImpl.toPayload(new Object[]{keys}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction sunionstore(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SUNIONSTORE, RedisClientImpl.toPayload(new Object[]{destkey, keys}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction sync(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SYNC, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction time(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.TIME, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction ttl(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.TTL, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction type(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.TYPE, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction unsubscribe(List<String> channels, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.UNSUBSCRIBE, RedisClientImpl.toPayload(new Object[]{channels}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction unwatch(Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.UNWATCH, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction wait(long numSlaves, long timeout, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.WAIT, RedisClientImpl.toPayload(new Object[]{numSlaves, timeout}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction watch(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.WATCH, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction watchMany(List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.WATCH, RedisClientImpl.toPayload(new Object[]{keys}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction zadd(String key, double score, String member, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.ZADD, RedisClientImpl.toPayload(new Object[]{key, score, member}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        /*
         * Exception decompiling
         */
        @Override
        public RedisTransaction zaddMany(String key, Map<String, Double> members, Handler<AsyncResult<String>> handler) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public RedisTransaction zcard(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.ZCARD, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction zcount(String key, double min, double max, Handler<AsyncResult<String>> handler) {
            String minVal = min == Double.NEGATIVE_INFINITY ? "-inf" : String.valueOf(min);
            String maxVal = max == Double.POSITIVE_INFINITY ? "+inf" : String.valueOf(max);
            RedisClientImpl.this.sendString(Command.ZCOUNT, RedisClientImpl.toPayload(new Object[]{key, minVal, maxVal}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction zincrby(String key, double increment, String member, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.ZINCRBY, RedisClientImpl.toPayload(new Object[]{key, increment, member}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction zinterstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.ZINTERSTORE, RedisClientImpl.toPayload(new Object[]{destkey, sets.size(), sets, options != null ? options.name() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction zinterstoreWeighed(String destkey, Map<String, Double> sets, AggregateOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.ZINTERSTORE, RedisClientImpl.toPayload(new Object[]{destkey, sets.size(), sets.keySet(), "WEIGHTS", sets.values(), options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction zlexcount(String key, String min, String max, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.ZLEXCOUNT, RedisClientImpl.toPayload(new Object[]{key, min, max}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction zrange(String key, long start, long stop, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.ZRANGE, RedisClientImpl.toPayload(new Object[]{key, start, stop}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction zrangeWithOptions(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.ZRANGE, RedisClientImpl.toPayload(new Object[]{key, start, stop, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction zrangebylex(String key, String min, String max, LimitOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.ZRANGEBYLEX, RedisClientImpl.toPayload(new Object[]{key, min, max, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction zrangebyscore(String key, String min, String max, RangeLimitOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.ZRANGEBYSCORE, RedisClientImpl.toPayload(new Object[]{key, min, max, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction zrank(String key, String member, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.ZRANK, RedisClientImpl.toPayload(new Object[]{key, member}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction zrem(String key, String member, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.ZREM, RedisClientImpl.toPayload(new Object[]{key, member}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction zremMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.ZREM, RedisClientImpl.toPayload(new Object[]{key, members}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction zremrangebylex(String key, String min, String max, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.ZREMRANGEBYLEX, RedisClientImpl.toPayload(new Object[]{key, min, max}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction zremrangebyrank(String key, long start, long stop, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.ZREMRANGEBYRANK, RedisClientImpl.toPayload(new Object[]{key, start, stop}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction zremrangebyscore(String key, String min, String max, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.ZREMRANGEBYSCORE, RedisClientImpl.toPayload(new Object[]{key, min, max}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction zrevrange(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.ZREVRANGE, RedisClientImpl.toPayload(new Object[]{key, start, stop, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction zrevrangebylex(String key, String max, String min, LimitOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.ZREVRANGEBYLEX, RedisClientImpl.toPayload(new Object[]{key, max, min, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction zrevrangebyscore(String key, String max, String min, RangeLimitOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.ZREVRANGEBYSCORE, RedisClientImpl.toPayload(new Object[]{key, max, min, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction zrevrank(String key, String member, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.ZREVRANK, RedisClientImpl.toPayload(new Object[]{key, member}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction zscore(String key, String member, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.ZSCORE, RedisClientImpl.toPayload(new Object[]{key, member}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction zunionstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.ZUNIONSTORE, RedisClientImpl.toPayload(new Object[]{destkey, sets.size(), sets, options != null ? options.name() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction zunionstoreWeighed(String destkey, Map<String, Double> sets, AggregateOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.ZUNIONSTORE, RedisClientImpl.toPayload(new Object[]{destkey, sets.size(), sets.keySet(), "WEIGHTS", sets.values(), options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction scan(String cursor, ScanOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SCAN, RedisClientImpl.toPayload(new Object[]{cursor, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction sscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SSCAN, RedisClientImpl.toPayload(new Object[]{key, cursor, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction hscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.HSCAN, RedisClientImpl.toPayload(new Object[]{key, cursor, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction zscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.ZSCAN, RedisClientImpl.toPayload(new Object[]{key, cursor, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction geoadd(String key, double longitude, double latitude, String member, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.GEOADD, RedisClientImpl.toPayload(new Object[]{key, longitude, latitude, member}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction geoaddMany(String key, List<GeoMember> members, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.GEOADD, RedisClientImpl.toPayload(new Object[]{key, members}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction geohash(String key, String member, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.GEOHASH, RedisClientImpl.toPayload(new Object[]{key, member}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction geohashMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.GEOHASH, RedisClientImpl.toPayload(new Object[]{key, members}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction geopos(String key, String member, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.GEOPOS, RedisClientImpl.toPayload(new Object[]{key, member}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction geoposMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.GEOPOS, RedisClientImpl.toPayload(new Object[]{key, members}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction geodist(String key, String member1, String member2, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.GEODIST, RedisClientImpl.toPayload(new Object[]{key, member1, member2}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction geodistWithUnit(String key, String member1, String member2, GeoUnit unit, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.GEODIST, RedisClientImpl.toPayload(new Object[]{key, member1, member2, unit}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.GEORADIUS, RedisClientImpl.toPayload(new Object[]{key, longitude, latitude, radius, unit}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction georadiusWithOptions(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.GEORADIUS, RedisClientImpl.toPayload(new Object[]{key, longitude, latitude, radius, unit, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction georadiusbymember(String key, String member, double radius, GeoUnit unit, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.GEORADIUSBYMEMBER, RedisClientImpl.toPayload(new Object[]{key, member, radius, unit}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction georadiusbymemberWithOptions(String key, String member, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.GEORADIUSBYMEMBER, RedisClientImpl.toPayload(new Object[]{key, member, radius, unit, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction unlink(String key, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.UNLINK, RedisClientImpl.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction unlinkMany(List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.UNLINK, RedisClientImpl.toPayload(new Object[]{keys}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        @Override
        public RedisTransaction swapdb(int index1, int index2, Handler<AsyncResult<String>> handler) {
            RedisClientImpl.this.sendString(Command.SWAPDB, RedisClientImpl.toPayload(new Object[]{index1, index2}), (Handler<AsyncResult<String>>)handler);
            return this;
        }
    }
}

