/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.ext.web.RoutingContext;
import io.vertx.core.Handler;

/**
 * Handler which adds a header `x-response-time` in the response of matching requests containing the time taken
 * in ms to process the request.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.ResponseTimeHandler original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.ext.web.handler.ResponseTimeHandler.class)
public class ResponseTimeHandler implements io.vertx.core.Handler<RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ResponseTimeHandler that = (ResponseTimeHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.reactivex.TypeArg<ResponseTimeHandler> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new ResponseTimeHandler((io.vertx.ext.web.handler.ResponseTimeHandler) obj),
    ResponseTimeHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.ResponseTimeHandler delegate;
  
  public ResponseTimeHandler(io.vertx.ext.web.handler.ResponseTimeHandler delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.handler.ResponseTimeHandler getDelegate() {
    return delegate;
  }

  public void handle(RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * Create a handler
   * @return the handler
   */
  public static ResponseTimeHandler create() { 
    ResponseTimeHandler ret = ResponseTimeHandler.newInstance(io.vertx.ext.web.handler.ResponseTimeHandler.create());
    return ret;
  }


  public static  ResponseTimeHandler newInstance(io.vertx.ext.web.handler.ResponseTimeHandler arg) {
    return arg != null ? new ResponseTimeHandler(arg) : null;
  }
}
