/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.web.handler;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.rxjava.ext.auth.User;
import java.util.Set;
import io.vertx.core.json.JsonObject;
import io.vertx.rxjava.ext.web.RoutingContext;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.rxjava.ext.auth.AuthProvider;

/**
 * An auth handler that's used to handle auth by redirecting user to a custom login page.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.RedirectAuthHandler original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.ext.web.handler.RedirectAuthHandler.class)
public class RedirectAuthHandler implements AuthHandler, io.vertx.core.Handler<RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RedirectAuthHandler that = (RedirectAuthHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rxjava.TypeArg<RedirectAuthHandler> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new RedirectAuthHandler((io.vertx.ext.web.handler.RedirectAuthHandler) obj),
    RedirectAuthHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.RedirectAuthHandler delegate;
  
  public RedirectAuthHandler(io.vertx.ext.web.handler.RedirectAuthHandler delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.handler.RedirectAuthHandler getDelegate() {
    return delegate;
  }

  public void handle(RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * Add a required authority for this auth handler
   * @param authority the authority
   * @return a reference to this, so the API can be used fluently
   */
  public AuthHandler addAuthority(String authority) { 
    delegate.addAuthority(authority);
    return this;
  }

  /**
   * Add a set of required authorities for this auth handler
   * @param authorities the set of authorities
   * @return a reference to this, so the API can be used fluently
   */
  public AuthHandler addAuthorities(Set<String> authorities) { 
    delegate.addAuthorities(authorities);
    return this;
  }

  /**
   * Parses the credentials from the request into a JsonObject. The implementation should
   * be able to extract the required info for the auth provider in the format the provider
   * expects.
   * @param context the routing context
   * @param handler the handler to be called once the information is available.
   */
  public void parseCredentials(RoutingContext context, Handler<AsyncResult<JsonObject>> handler) { 
    delegate.parseCredentials(context.getDelegate(), handler);
  }

  /**
   * Parses the credentials from the request into a JsonObject. The implementation should
   * be able to extract the required info for the auth provider in the format the provider
   * expects.
   * @param context the routing context
   * @return 
   * @deprecated use {@link #rxParseCredentials} instead
   */
  @Deprecated()
  public Observable<JsonObject> parseCredentialsObservable(RoutingContext context) { 
    io.vertx.rx.java.ObservableFuture<JsonObject> handler = io.vertx.rx.java.RxHelper.observableFuture();
    parseCredentials(context, handler.toHandler());
    return handler;
  }

  /**
   * Parses the credentials from the request into a JsonObject. The implementation should
   * be able to extract the required info for the auth provider in the format the provider
   * expects.
   * @param context the routing context
   * @return 
   */
  public Single<JsonObject> rxParseCredentials(RoutingContext context) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      parseCredentials(context, fut);
    }));
  }

  /**
   * Authorizes the given user against all added authorities.
   * @param user a user.
   * @param handler the handler for the result.
   */
  public void authorize(User user, Handler<AsyncResult<Void>> handler) { 
    delegate.authorize(user.getDelegate(), handler);
  }

  /**
   * Authorizes the given user against all added authorities.
   * @param user a user.
   * @return 
   * @deprecated use {@link #rxAuthorize} instead
   */
  @Deprecated()
  public Observable<Void> authorizeObservable(User user) { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    authorize(user, handler.toHandler());
    return handler;
  }

  /**
   * Authorizes the given user against all added authorities.
   * @param user a user.
   * @return 
   */
  public Single<Void> rxAuthorize(User user) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      authorize(user, fut);
    }));
  }

  /**
   * Create a handler
   * @param authProvider the auth service to use
   * @return the handler
   */
  public static AuthHandler create(AuthProvider authProvider) { 
    AuthHandler ret = AuthHandler.newInstance(io.vertx.ext.web.handler.RedirectAuthHandler.create(authProvider.getDelegate()));
    return ret;
  }

  /**
   * Create a handler
   * @param authProvider the auth service to use
   * @param loginRedirectURL the url to redirect the user to
   * @return the handler
   */
  public static AuthHandler create(AuthProvider authProvider, String loginRedirectURL) { 
    AuthHandler ret = AuthHandler.newInstance(io.vertx.ext.web.handler.RedirectAuthHandler.create(authProvider.getDelegate(), loginRedirectURL));
    return ret;
  }

  /**
   * Create a handler
   * @param authProvider the auth service to use
   * @param loginRedirectURL the url to redirect the user to
   * @param returnURLParam the name of param used to store return url information in session
   * @return the handler
   */
  public static AuthHandler create(AuthProvider authProvider, String loginRedirectURL, String returnURLParam) { 
    AuthHandler ret = AuthHandler.newInstance(io.vertx.ext.web.handler.RedirectAuthHandler.create(authProvider.getDelegate(), loginRedirectURL, returnURLParam));
    return ret;
  }


  public static  RedirectAuthHandler newInstance(io.vertx.ext.web.handler.RedirectAuthHandler arg) {
    return arg != null ? new RedirectAuthHandler(arg) : null;
  }
}
