/*
 * Decompiled with CFR 0.152.
 */
package brave.http;

import brave.Span;
import brave.Tracer;
import brave.http.HttpHandler;
import brave.http.HttpSampler;
import brave.http.HttpServerAdapter;
import brave.http.HttpTracing;
import brave.internal.Nullable;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import zipkin2.Endpoint;

public final class HttpServerHandler<Req, Resp>
extends HttpHandler<Req, Resp, HttpServerAdapter<Req, Resp>> {
    final Tracer tracer;
    final HttpSampler sampler;

    public static <Req, Resp> HttpServerHandler<Req, Resp> create(HttpTracing httpTracing, HttpServerAdapter<Req, Resp> adapter) {
        return new HttpServerHandler<Req, Resp>(httpTracing, adapter);
    }

    HttpServerHandler(HttpTracing httpTracing, HttpServerAdapter<Req, Resp> adapter) {
        super(httpTracing.tracing().currentTraceContext(), adapter, httpTracing.serverParser());
        this.tracer = httpTracing.tracing().tracer();
        this.sampler = httpTracing.serverSampler();
    }

    public Span handleReceive(TraceContext.Extractor<Req> extractor, Req request) {
        return this.handleReceive(extractor, request, request);
    }

    public <C> Span handleReceive(TraceContext.Extractor<C> extractor, C carrier, Req request) {
        Span span = this.nextSpan(extractor.extract(carrier), request);
        span.kind(Span.Kind.SERVER);
        return this.handleStart(request, span);
    }

    @Override
    boolean parseRemoteEndpoint(Req request, Endpoint.Builder remoteEndpoint) {
        return ((HttpServerAdapter)this.adapter).parseClientAddress(request, remoteEndpoint);
    }

    Span nextSpan(TraceContextOrSamplingFlags extracted, Req request) {
        if (extracted.sampled() == null) {
            extracted = extracted.sampled(this.sampler.trySample(this.adapter, request));
        }
        return extracted.context() != null ? this.tracer.joinSpan(extracted.context()) : this.tracer.nextSpan(extracted);
    }

    public void handleSend(@Nullable Resp response, @Nullable Throwable error, Span span) {
        this.handleFinish(response, error, span);
    }
}

